/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.Weigher;
import org.cache2k.core.Entry;
import org.cache2k.core.Eviction;
import org.cache2k.core.EvictionMetrics;
import org.cache2k.core.ExceptionWrapper;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.LongTo16BitFloatingPoint;
import org.cache2k.core.concurrency.Job;

public abstract class AbstractEviction
implements Eviction,
EvictionMetrics {
    public static final int MINIMAL_CHUNK_SIZE = 4;
    public static final int MAXIMAL_CHUNK_SIZE = 64;
    public static final long MINIMUM_CAPACITY_FOR_CHUNKING = 1000L;
    protected final long maxSize;
    protected final long maxWeight;
    protected final long correctedMaxSizeOrWeight;
    protected final HeapCache heapCache;
    private final Object lock = new Object();
    private long newEntryCounter;
    private long removedCnt;
    private long expiredRemovedCnt;
    private long virginRemovedCnt;
    private long evictedCount;
    private long currentWeight;
    private final HeapCacheListener listener;
    private final boolean noListenerCall;
    private Entry[] evictChunkReuse;
    private int chunkSize;
    private int evictionRunningCount = 0;
    private long evictionRunningWeight = 0L;
    private final Weigher weigher;

    public AbstractEviction(HeapCache _heapCache, HeapCacheListener _listener, long _maxSize, Weigher _weigher, long _maxWeight, boolean _noChunking) {
        this.weigher = _weigher;
        this.heapCache = _heapCache;
        this.listener = _listener;
        this.maxSize = _maxSize;
        this.maxWeight = _maxWeight;
        if (_maxSize < 1000L || _noChunking) {
            this.chunkSize = 1;
        } else {
            this.chunkSize = 4 + Runtime.getRuntime().availableProcessors() - 1;
            this.chunkSize = Math.min(64, this.chunkSize);
        }
        this.noListenerCall = _listener instanceof HeapCacheListener.NoOperation;
        if (this.maxSize >= 0L) {
            this.correctedMaxSizeOrWeight = this.maxSize == Long.MAX_VALUE ? 0x3FFFFFFFFFFFFFFFL : this.maxSize + (long)(this.chunkSize / 2);
        } else {
            if (_maxWeight < 0L) {
                throw new IllegalArgumentException("either maxWeight or entryCapacity must be specified");
            }
            this.correctedMaxSizeOrWeight = _maxWeight == Long.MAX_VALUE ? 0x3FFFFFFFFFFFFFFFL : _maxWeight;
        }
    }

    @Override
    public boolean isWeigherPresent() {
        return this.weigher != null;
    }

    protected static long getWeightFromEntry(Entry e) {
        return LongTo16BitFloatingPoint.toLong(e.getCompressedWeight());
    }

    protected static void updateWeightInEntry(Entry e, long _weight) {
        e.setCompressedWeight(LongTo16BitFloatingPoint.fromLong(_weight));
    }

    private long calculateWeight(Entry e, Object v) {
        long _weight = v instanceof ExceptionWrapper ? 1L : this.weigher.weigh(e.getKey(), v);
        if (_weight < 0L) {
            throw new IllegalArgumentException("weight must be positive.");
        }
        return _weight;
    }

    protected void insertAndWeighInLock(Entry e) {
        if (!this.isWeigherPresent()) {
            return;
        }
    }

    protected void updateWeightInLock(Entry e) {
        Object v = e.getValueOrException();
        long _weight = this.calculateWeight(e, v);
        long _currentWeight = AbstractEviction.getWeightFromEntry(e);
        if (_currentWeight != _weight) {
            this.currentWeight += _weight - _currentWeight;
            AbstractEviction.updateWeightInEntry(e, _weight);
        }
    }

    protected void updateTotalWeightForRemove(Entry e) {
        if (!this.isWeigherPresent()) {
            return;
        }
        this.currentWeight -= AbstractEviction.getWeightFromEntry(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWeight(Entry e) {
        if (!this.isWeigherPresent()) {
            return;
        }
        Entry[] _evictionChunk = null;
        Object object = this.lock;
        synchronized (object) {
            this.updateWeightInLock(e);
            _evictionChunk = this.fillEvictionChunk();
        }
        this.evictChunk(_evictionChunk);
        int _processCount = 1;
        while (this.isEvictionNeeded() && _processCount > 0) {
            Object object2 = this.lock;
            synchronized (object2) {
                _evictionChunk = this.fillEvictionChunk();
            }
            _processCount = this.evictChunk(_evictionChunk);
        }
    }

    Entry[] reuseChunkArray() {
        Entry[] ea = this.evictChunkReuse;
        if (ea != null) {
            this.evictChunkReuse = null;
        } else {
            ea = new Entry[this.chunkSize];
        }
        return ea;
    }

    private void removeEventually(Entry e) {
        if (!e.isRemovedFromReplacementList()) {
            this.removeFromReplacementList(e);
            this.updateTotalWeightForRemove(e);
            long nrt = e.getNextRefreshTime();
            if (nrt == 12L) {
                ++this.expiredRemovedCnt;
            } else if (nrt == 8L) {
                ++this.virginRemovedCnt;
            } else {
                ++this.removedCnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submitWithoutEviction(Entry e) {
        Object object = this.lock;
        synchronized (object) {
            if (e.isNotYetInsertedInReplacementList()) {
                this.insertIntoReplacementList(e);
                this.insertAndWeighInLock(e);
                ++this.newEntryCounter;
            } else {
                this.removeEventually(e);
                this.updateTotalWeightForRemove(e);
            }
            return this.isEvictionNeeded();
        }
    }

    boolean isEvictionNeeded() {
        if (this.isWeigherPresent()) {
            return this.currentWeight >= this.correctedMaxSizeOrWeight + this.evictionRunningWeight;
        }
        return this.getSize() >= this.correctedMaxSizeOrWeight + (long)this.evictionRunningCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictEventually() {
        Entry[] _chunk;
        Object object = this.lock;
        synchronized (object) {
            _chunk = this.fillEvictionChunk();
        }
        this.evictChunk(_chunk);
    }

    @Override
    public void evictEventually(int _hashCodeHint) {
        this.evictEventually();
    }

    private Entry[] fillEvictionChunk() {
        if (!this.isEvictionNeeded()) {
            return null;
        }
        Entry[] _chunk = this.reuseChunkArray();
        return this.refillChunk(_chunk);
    }

    private Entry[] refillChunk(Entry[] _chunk) {
        if (_chunk == null) {
            _chunk = new Entry[this.chunkSize];
        }
        this.evictionRunningCount += _chunk.length;
        for (int i = 0; i < _chunk.length; ++i) {
            _chunk[i] = this.findEvictionCandidate(null);
            if (!this.isWeigherPresent()) continue;
            this.evictionRunningWeight += AbstractEviction.getWeightFromEntry(_chunk[i]);
        }
        return _chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int evictChunk(Entry[] _chunk) {
        if (_chunk == null) {
            return 0;
        }
        int _processCount = this.removeFromHash(_chunk);
        if (_processCount > 0) {
            Object object = this.lock;
            synchronized (object) {
                this.removeAllFromReplacementListOnEvict(_chunk);
                this.evictChunkReuse = _chunk;
            }
        }
        return _processCount;
    }

    private int removeFromHash(Entry[] _chunk) {
        if (!this.noListenerCall) {
            return this.removeFromHashWithListener(_chunk);
        }
        return this.removeFromHashWithoutListener(_chunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFromHashWithoutListener(Entry[] _chunk) {
        int _processCount = 0;
        for (int i = 0; i < _chunk.length; ++i) {
            Entry e;
            Entry entry = e = _chunk[i];
            synchronized (entry) {
                if (e.isGone() || e.isProcessing()) {
                    --this.evictionRunningCount;
                    if (this.isWeigherPresent()) {
                        this.evictionRunningWeight -= AbstractEviction.getWeightFromEntry(e);
                    }
                    _chunk[i] = null;
                    continue;
                }
                this.heapCache.removeEntryForEviction(e);
            }
            ++_processCount;
        }
        return _processCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFromHashWithListener(Entry[] _chunk) {
        int _processCount = 0;
        for (int i = 0; i < _chunk.length; ++i) {
            Entry e;
            Entry entry = e = _chunk[i];
            synchronized (entry) {
                if (e.isGone() || e.isProcessing()) {
                    --this.evictionRunningCount;
                    if (this.isWeigherPresent()) {
                        this.evictionRunningWeight -= AbstractEviction.getWeightFromEntry(e);
                    }
                    _chunk[i] = null;
                    continue;
                }
                e.startProcessing(16);
            }
            this.listener.onEvictionFromHeap(e);
            entry = e;
            synchronized (entry) {
                e.processingDone();
                this.heapCache.removeEntryForEviction(e);
            }
            ++_processCount;
        }
        return _processCount;
    }

    private void removeAllFromReplacementListOnEvict(Entry[] _chunk) {
        for (int i = 0; i < _chunk.length; ++i) {
            Entry e = _chunk[i];
            if (e == null) continue;
            if (!e.isRemovedFromReplacementList()) {
                this.removeFromReplacementListOnEvict(e);
                this.updateTotalWeightForRemove(e);
                ++this.evictedCount;
            }
            --this.evictionRunningCount;
            if (this.isWeigherPresent()) {
                this.evictionRunningWeight -= AbstractEviction.getWeightFromEntry(e);
            }
            _chunk[i] = null;
        }
    }

    @Override
    public long getNewEntryCount() {
        return this.newEntryCounter;
    }

    @Override
    public long getRemovedCount() {
        return this.removedCnt;
    }

    @Override
    public long getVirginRemovedCount() {
        return this.virginRemovedCnt;
    }

    @Override
    public long getExpiredRemovedCount() {
        return this.expiredRemovedCnt;
    }

    @Override
    public long getEvictedCount() {
        return this.evictedCount;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public long getMaxWeight() {
        return this.maxWeight;
    }

    @Override
    public long getCurrentWeight() {
        return this.currentWeight;
    }

    @Override
    public int getEvictionRunningCount() {
        return this.evictionRunningCount;
    }

    @Override
    public EvictionMetrics getMetrics() {
        return this;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean drain() {
        return false;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runLocked(Job<T> j) {
        Object object = this.lock;
        synchronized (object) {
            return j.call();
        }
    }

    protected void removeFromReplacementListOnEvict(Entry e) {
        this.removeFromReplacementList(e);
    }

    protected abstract Entry findEvictionCandidate(Entry var1);

    protected abstract void removeFromReplacementList(Entry var1);

    protected abstract void insertIntoReplacementList(Entry var1);

    @Override
    public String getExtraStatistics() {
        return "impl=" + this.getClass().getSimpleName() + ", chunkSize=" + this.chunkSize;
    }
}

