/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.serverSide;

import java.util.Date;
import java.util.Iterator;
import org.cache2k.core.HealthInfoElement;
import org.cache2k.core.InternalCache;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.jmx.CacheMXBean;

public class CacheMXBeanImpl
implements CacheMXBean {
    private InternalCache cache;

    public String getKeyType() {
        return this.cache.getKeyType().getTypeName();
    }

    public String getValueType() {
        return this.cache.getValueType().getTypeName();
    }

    public CacheMXBeanImpl(InternalCache cache) {
        this.cache = cache;
    }

    private InternalCacheInfo getInfo() {
        return this.cache.getInfo();
    }

    public long getSize() {
        return this.getInfo().getSize();
    }

    public long getEntryCapacity() {
        return this.getInfo().getHeapCapacity();
    }

    public long getMissCount() {
        return this.getInfo().getMissCount();
    }

    public long getInsertCount() {
        return this.getInfo().getNewEntryCount();
    }

    public long getLoadCount() {
        return this.getInfo().getLoadCount();
    }

    public long getRefreshCount() {
        return this.getInfo().getRefreshCount();
    }

    public long getRefreshFailedCount() {
        return this.getInfo().getRefreshFailedCount();
    }

    public long getRefreshedHitCount() {
        return this.getInfo().getRefreshedHitCount();
    }

    public long getExpiredCount() {
        return this.getInfo().getExpiredCount();
    }

    public long getEvictedCount() {
        return this.getInfo().getEvictedCount();
    }

    public long getKeyMutationCount() {
        return this.getInfo().getKeyMutationCount();
    }

    public long getLoadExceptionCount() {
        return this.getInfo().getLoadExceptionCount();
    }

    public long getSuppressedLoadExceptionCount() {
        return this.getInfo().getSuppressedExceptionCount();
    }

    public long getGetCount() {
        return this.getInfo().getGetCount();
    }

    public long getPutCount() {
        return this.getInfo().getPutCount();
    }

    public long getClearCount() {
        return this.getInfo().getClearCount();
    }

    public long getRemoveCount() {
        return this.getInfo().getRemoveCount();
    }

    public long getClearedEntriesCount() {
        return this.getInfo().getClearedEntriesCount();
    }

    public double getHitRate() {
        return this.getInfo().getHitRate();
    }

    public int getHashQuality() {
        return this.getInfo().getHashQuality();
    }

    public double getMillisPerLoad() {
        return this.getInfo().getMillisPerLoad();
    }

    public long getTotalLoadMillis() {
        return this.getInfo().getLoadMillis();
    }

    public String getIntegrityDescriptor() {
        return this.getInfo().getIntegrityDescriptor();
    }

    public Date getCreatedTime() {
        return new Date(this.getInfo().getStartedTime());
    }

    public Date getClearedTime() {
        return this.optionalDate(this.getInfo().getClearedTime());
    }

    public Date getInfoCreatedTime() {
        return new Date(this.getInfo().getInfoCreatedTime());
    }

    Date optionalDate(long _millis) {
        return _millis == 0L ? null : new Date(_millis);
    }

    public int getInfoCreatedDeltaMillis() {
        return this.getInfo().getInfoCreationDeltaMs();
    }

    public String getImplementation() {
        return this.getInfo().getImplementation();
    }

    public void clear() {
        this.cache.clear();
    }

    public int getAlert() {
        Iterator<HealthInfoElement> it = this.getInfo().getHealth().iterator();
        if (!it.hasNext()) {
            return 0;
        }
        HealthInfoElement hi = it.next();
        if ("FAILURE".equals(hi.getLevel())) {
            return 2;
        }
        return 1;
    }

    public String getEvictionStatistics() {
        return this.getInfo().getExtraStatistics();
    }
}

