/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.cache2k.Cache;
import org.cache2k.CacheEntry;
import org.cache2k.CacheManager;
import org.cache2k.CacheOperationCompletionListener;
import org.cache2k.configuration.CacheType;
import org.cache2k.core.BaseCache;
import org.cache2k.core.CacheClosedException;
import org.cache2k.core.CommonMetrics;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.InternalCacheInfo;
import org.cache2k.core.StandardStorageMetrics;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.TimingHandler;
import org.cache2k.core.operation.Operations;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.PurgeableStorage;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.core.util.Log;
import org.cache2k.event.CacheEntryCreatedListener;
import org.cache2k.event.CacheEntryExpiredListener;
import org.cache2k.event.CacheEntryRemovedListener;
import org.cache2k.event.CacheEntryUpdatedListener;
import org.cache2k.integration.AdvancedCacheLoader;
import org.cache2k.integration.CacheWriter;
import org.cache2k.processor.EntryProcessor;

public class WiredCache<K, V>
extends BaseCache<K, V>
implements StorageAdapter.Parent,
HeapCacheListener<K, V> {
    final Operations<K, V> SPEC = Operations.SINGLETON;
    HeapCache<K, V> heapCache;
    StorageAdapter storage;
    AdvancedCacheLoader<K, V> loader;
    CacheWriter<K, V> writer;
    CacheEntryRemovedListener<K, V>[] syncEntryRemovedListeners;
    CacheEntryCreatedListener<K, V>[] syncEntryCreatedListeners;
    CacheEntryUpdatedListener<K, V>[] syncEntryUpdatedListeners;
    CacheEntryExpiredListener<K, V>[] syncEntryExpiredListeners;
    StorageMetrics.Updater storageMetrics = new StandardStorageMetrics();

    private CommonMetrics.Updater metrics() {
        return this.heapCache.metrics;
    }

    @Override
    public Log getLog() {
        return this.heapCache.getLog();
    }

    public HeapCache getHeapCache() {
        return this.heapCache;
    }

    @Override
    public boolean isNullValuePermitted() {
        return this.heapCache.isNullValuePermitted();
    }

    @Override
    public String getName() {
        return this.heapCache.getName();
    }

    @Override
    public CacheType getKeyType() {
        return this.heapCache.getKeyType();
    }

    @Override
    public CacheType getValueType() {
        return this.heapCache.getValueType();
    }

    public CacheManager getCacheManager() {
        return this.heapCache.getCacheManager();
    }

    public V computeIfAbsent(K key, Callable<V> callable) {
        return this.returnValue(this.execute(key, this.SPEC.computeIfAbsent(key, callable)));
    }

    public V peekAndPut(K key, V value) {
        return this.returnValue(this.execute(key, this.SPEC.peekAndPut(key, value)));
    }

    public V peekAndRemove(K key) {
        return this.returnValue(this.execute(key, this.SPEC.peekAndRemove(key)));
    }

    public V peekAndReplace(K key, V value) {
        return this.returnValue(this.execute(key, this.SPEC.peekAndReplace(key, value)));
    }

    public CacheEntry<K, V> peekEntry(K key) {
        return this.execute(key, this.SPEC.peekEntry(key));
    }

    public void prefetch(final K key) {
        if (this.loader == null) {
            return;
        }
        Entry e = this.heapCache.lookupEntryNoHitRecord(key);
        if (e != null && e.hasFreshData()) {
            return;
        }
        try {
            this.heapCache.getPrefetchExecutor().execute(new HeapCache.RunWithCatch(this){

                @Override
                public void action() {
                    WiredCache.this.load(key);
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetchAll(Iterable<? extends K> _keys, CacheOperationCompletionListener l) {
        CacheOperationCompletionListener _listener;
        CacheOperationCompletionListener cacheOperationCompletionListener = _listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        if (this.loader == null) {
            _listener.onCompleted();
            return;
        }
        final AtomicInteger _count = new AtomicInteger(2);
        try {
            Set<K> _keysToLoad = this.heapCache.checkAllPresent(_keys);
            Iterator<K> iterator = _keysToLoad.iterator();
            while (iterator.hasNext()) {
                K k;
                final K key = k = iterator.next();
                HeapCache.RunWithCatch r = new HeapCache.RunWithCatch(this){

                    @Override
                    public void action() {
                        try {
                            WiredCache.this.load(key);
                        }
                        finally {
                            if (_count.decrementAndGet() == 0) {
                                _listener.onCompleted();
                            }
                        }
                    }
                };
                try {
                    this.heapCache.getPrefetchExecutor().execute(r);
                    _count.incrementAndGet();
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        }
        finally {
            if (_count.addAndGet(-2) == 0) {
                _listener.onCompleted();
            }
        }
    }

    private void load(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData()) {
            return;
        }
        this.load(key, e);
    }

    private void load(K key, Entry<K, V> _e) {
        this.execute(key, _e, this.SPEC.get(key));
    }

    public boolean containsKey(K key) {
        return this.execute(key, this.SPEC.contains(key));
    }

    public boolean putIfAbsent(K key, V value) {
        return this.execute(key, this.SPEC.putIfAbsent(key, value));
    }

    public void put(K key, V value) {
        this.execute(key, this.SPEC.put(key, value));
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void remove(K key) {
        this.execute(key, this.SPEC.remove(key));
    }

    public boolean removeIfEquals(K key, V value) {
        return this.execute(key, this.SPEC.remove(key, value));
    }

    public boolean containsAndRemove(K key) {
        return this.execute(key, this.SPEC.containsAndRemove(key));
    }

    public boolean replace(K key, V _newValue) {
        return this.execute(key, this.SPEC.replace(key, _newValue));
    }

    public boolean replaceIfEquals(K key, V _oldValue, V _newValue) {
        return this.execute(key, this.SPEC.replace(key, _oldValue, _newValue));
    }

    @Override
    public CacheEntry<K, V> replaceOrGet(K key, V _oldValue, V _newValue, CacheEntry<K, V> _dummyEntry) {
        return this.execute(key, this.SPEC.replaceOrGet(key, _oldValue, _newValue, _dummyEntry));
    }

    public void loadAll(Iterable<? extends K> _keys, CacheOperationCompletionListener l) {
        this.checkLoaderPresent();
        final CacheOperationCompletionListener _listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keysToLoad = this.heapCache.checkAllPresent(_keys);
        if (_keysToLoad.isEmpty()) {
            _listener.onCompleted();
            return;
        }
        final AtomicInteger _countDown = new AtomicInteger(_keysToLoad.size());
        Iterator<K> iterator = _keysToLoad.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            HeapCache.RunWithCatch r = new HeapCache.RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        WiredCache.this.load(key);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.onCompleted();
                        }
                    }
                }
            };
            try {
                this.heapCache.loaderExecutor.execute(r);
            }
            catch (RejectedExecutionException ex) {
                r.run();
            }
        }
    }

    public void reloadAll(Iterable<? extends K> _keys, CacheOperationCompletionListener l) {
        this.checkLoaderPresent();
        final CacheOperationCompletionListener _listener = l != null ? l : HeapCache.DUMMY_LOAD_COMPLETED_LISTENER;
        Set<K> _keySet = this.heapCache.generateKeySet(_keys);
        final AtomicInteger _countDown = new AtomicInteger(_keySet.size());
        Iterator<K> iterator = _keySet.iterator();
        while (iterator.hasNext()) {
            K k;
            final K key = k = iterator.next();
            HeapCache.RunWithCatch r = new HeapCache.RunWithCatch(this){

                @Override
                public void action() {
                    try {
                        Operations cfr_ignored_0 = WiredCache.this.SPEC;
                        WiredCache.this.execute(key, Operations.UNCONDITIONAL_LOAD);
                    }
                    finally {
                        if (_countDown.decrementAndGet() == 0) {
                            _listener.onCompleted();
                        }
                    }
                }
            };
            try {
                this.heapCache.loaderExecutor.execute(r);
            }
            catch (RejectedExecutionException ex) {
                r.run();
            }
        }
    }

    public void expireAt(K key, long _millis) {
        this.execute(key, this.SPEC.expire(key, _millis));
    }

    private void checkLoaderPresent() {
        if (this.loader == null) {
            throw new UnsupportedOperationException("loader not set");
        }
    }

    V returnValue(V v) {
        return this.heapCache.returnValue(v);
    }

    V returnValue(Entry<K, V> e) {
        return (V)this.returnValue(e.getValueOrException());
    }

    Entry<K, V> lookupQuick(K key) {
        return this.heapCache.lookupEntry(key);
    }

    public V get(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData()) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, e, this.SPEC.get(key)));
    }

    public Map<K, V> getAll(Iterable<? extends K> keys) {
        HashMap<K, CacheEntry> map = new HashMap<K, CacheEntry>();
        for (K k : keys) {
            CacheEntry e = this.execute(k, this.SPEC.getEntry(k));
            if (e == null) continue;
            map.put(k, e);
        }
        return this.heapCache.convertCacheEntry2ValueMap(map);
    }

    public CacheEntry<K, V> getEntry(K key) {
        return this.execute(key, this.SPEC.getEntry(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalEntryCount() {
        Object object = this.lockObject();
        synchronized (object) {
            if (this.storage != null) {
                return (int)this.storage.getTotalEntryCount();
            }
            return (int)this.heapCache.getLocalSize();
        }
    }

    public <R> R invoke(K key, EntryProcessor<K, V, R> entryProcessor) {
        return this.execute(key, this.SPEC.invoke(key, this.loader != null, entryProcessor));
    }

    @Override
    public Iterator<CacheEntry<K, V>> iterator() {
        HeapCache.IteratorFilterEntry2Entry<K, V> tor = this.storage == null ? new HeapCache.IteratorFilterEntry2Entry<K, V>(this.heapCache, this.heapCache.iterateAllHeapEntries(), true) : new HeapCache.IteratorFilterEntry2Entry<K, V>(this.heapCache, this.storage.iterateAll(), false);
        final HeapCache.IteratorFilterEntry2Entry<K, V> it = tor;
        Iterator _adapted = new Iterator<CacheEntry<K, V>>(){
            CacheEntry<K, V> entry;

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public CacheEntry<K, V> next() {
                this.entry = (CacheEntry)it.next();
                return this.entry;
            }

            @Override
            public void remove() {
                if (this.entry == null) {
                    throw new IllegalStateException("call next first");
                }
                WiredCache.this.remove(this.entry.getKey());
            }
        };
        return _adapted;
    }

    public V peek(K key) {
        Entry<K, V> e = this.lookupQuick(key);
        if (e != null && e.hasFreshData()) {
            return this.returnValue(e);
        }
        return this.returnValue(this.execute(key, this.SPEC.peek(key)));
    }

    public Map<K, V> peekAll(Iterable<? extends K> keys) {
        HashMap<K, CacheEntry> map = new HashMap<K, CacheEntry>();
        for (K k : keys) {
            CacheEntry e = this.execute(k, this.SPEC.peekEntry(k));
            if (e == null) continue;
            map.put(k, e);
        }
        return this.heapCache.convertCacheEntry2ValueMap(map);
    }

    @Override
    public InternalCacheInfo getLatestInfo() {
        return this.heapCache.getLatestInfo(this);
    }

    @Override
    public InternalCacheInfo getInfo() {
        return this.heapCache.getInfo(this);
    }

    @Override
    public CommonMetrics getCommonMetrics() {
        return this.heapCache.getCommonMetrics();
    }

    @Override
    public void logAndCountInternalException(String s, Throwable t) {
        this.heapCache.logAndCountInternalException(s, t);
    }

    @Override
    public void checkIntegrity() {
        this.heapCache.checkIntegrity();
    }

    public boolean isClosed() {
        return this.heapCache.isClosed();
    }

    public String toString() {
        return this.heapCache.toString();
    }

    public void init() {
        if (this.storage == null && this.heapCache.eviction.getMetrics().getMaxSize() == 0L) {
            throw new IllegalArgumentException("maxElements must be >0");
        }
        if (this.storage != null) {
            this.storage.open();
        }
        this.heapCache.timing.init(this);
        this.heapCache.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelTimerJobs() {
        Object object = this.lockObject();
        synchronized (object) {
            this.heapCache.cancelTimerJobs();
            if (this.storage != null) {
                this.storage.cancelTimerJobs();
            }
        }
    }

    public void clear() {
        if (this.storage != null) {
            this.storage.clear();
            return;
        }
        this.heapCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.heapCache.closePart1();
        }
        catch (CacheClosedException ex) {
            return;
        }
        Future<Void> _waitForStorage = null;
        if (this.storage != null) {
            _waitForStorage = this.storage.shutdown();
        }
        if (_waitForStorage != null) {
            try {
                _waitForStorage.get();
            }
            catch (Exception ex) {
                StorageAdapter.rethrow("shutdown", ex);
            }
        }
        CacheEntryCreatedListener<K, V>[] cacheEntryCreatedListenerArray = this.lockObject();
        synchronized (cacheEntryCreatedListenerArray) {
            this.storage = null;
        }
        this.heapCache.closePart2(this);
        this.closeCustomization(this.writer);
        if (this.syncEntryCreatedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryCreatedListeners) {
                this.closeCustomization(cacheEntryCreatedListener);
            }
        }
        if (this.syncEntryUpdatedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryUpdatedListeners) {
                this.closeCustomization(cacheEntryCreatedListener);
            }
        }
        if (this.syncEntryRemovedListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryRemovedListeners) {
                this.closeCustomization(cacheEntryCreatedListener);
            }
        }
        if (this.syncEntryExpiredListeners != null) {
            for (CacheEntryCreatedListener<K, V> cacheEntryCreatedListener : this.syncEntryExpiredListeners) {
                this.closeCustomization(cacheEntryCreatedListener);
            }
        }
    }

    private Object lockObject() {
        return this.heapCache.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStorage(StorageAdapter _from, StorageAdapter to) {
        Object object = this.lockObject();
        synchronized (object) {
            this.storage = to;
        }
    }

    @Override
    public StorageAdapter getStorage() {
        return this.storage;
    }

    public void lockAndRunForPurge(K key, PurgeableStorage.PurgeAction _action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onEvictionFromHeap(Entry<K, V> e) {
        boolean _shouldStore;
        boolean _storeEvenImmediatelyExpired = this.heapCache.hasKeepAfterExpired() && (e.isDataValid() || e.isExpired());
        boolean bl = _shouldStore = this.storage != null && (_storeEvenImmediatelyExpired || e.hasFreshData());
        if (_shouldStore) {
            this.storage.evict(e);
        }
    }

    @Override
    protected <R> EntryAction<K, V, R> createEntryAction(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        return new MyEntryAction<R>(op, key, e);
    }

    @Override
    public String getEntryState(K key) {
        return this.heapCache.getEntryState(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventExpireEntry(Entry<K, V> e) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.expireOrScheduleFinalExpireEvent(e);
        }
    }

    @Override
    public void expireOrScheduleFinalExpireEvent(Entry<K, V> e) {
        this.heapCache.expireOrScheduleFinalExpireEvent(e);
        if (e.isExpired() || e.isGone()) {
            this.callExpiryListeners(e);
        }
    }

    private void callExpiryListeners(Entry<K, V> e) {
        if (this.syncEntryExpiredListeners != null) {
            for (CacheEntryExpiredListener<K, V> l : this.syncEntryExpiredListeners) {
                l.onEntryExpired((Cache)this, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventRefresh(final Entry<K, V> e) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            if (e.isGone()) {
                return;
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (WiredCache.this.storage == null) {
                        Entry entry = e;
                        synchronized (entry) {
                            e.waitForProcessing();
                            if (e.isGone()) {
                                return;
                            }
                        }
                    }
                    try {
                        Operations cfr_ignored_0 = WiredCache.this.SPEC;
                        WiredCache.this.execute(e.getKey(), e, Operations.REFRESH);
                    }
                    catch (CacheClosedException cacheClosedException) {
                    }
                    catch (Throwable ex) {
                        WiredCache.this.logAndCountInternalException("Refresh exception", ex);
                        try {
                            Entry entry = e;
                            synchronized (entry) {
                                WiredCache.this.heapCache.expireEntry(e);
                            }
                        }
                        catch (CacheClosedException cacheClosedException) {
                            // empty catch block
                        }
                    }
                }
            };
            try {
                this.heapCache.loaderExecutor.execute(r);
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                this.metrics().refreshFailed();
                this.expireOrScheduleFinalExpireEvent(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timerEventProbationTerminated(Entry<K, V> e) {
        this.metrics().timerEvent();
        Entry<K, V> entry = e;
        synchronized (entry) {
            this.expireOrScheduleFinalExpireEvent(e);
        }
    }

    class MyEntryAction<R>
    extends EntryAction<K, V, R> {
        public MyEntryAction(Semantic<K, V, R> op, K _k, Entry<K, V> e) {
            super(WiredCache.this.heapCache, WiredCache.this, op, _k, e);
        }

        @Override
        protected boolean mightHaveListeners() {
            return true;
        }

        @Override
        protected CacheEntryCreatedListener<K, V>[] entryCreatedListeners() {
            return WiredCache.this.syncEntryCreatedListeners;
        }

        @Override
        protected CacheEntryRemovedListener<K, V>[] entryRemovedListeners() {
            return WiredCache.this.syncEntryRemovedListeners;
        }

        @Override
        protected CacheEntryUpdatedListener<K, V>[] entryUpdatedListeners() {
            return WiredCache.this.syncEntryUpdatedListeners;
        }

        @Override
        protected CacheEntryExpiredListener<K, V>[] entryExpiredListeners() {
            return WiredCache.this.syncEntryExpiredListeners;
        }

        @Override
        protected CacheWriter<K, V> writer() {
            return WiredCache.this.writer;
        }

        @Override
        protected TimingHandler<K, V> timing() {
            return this.heapCache.timing;
        }
    }
}

