/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import org.cache2k.core.AbstractEviction;
import org.cache2k.core.Entry;
import org.cache2k.core.HeapCache;
import org.cache2k.core.HeapCacheListener;
import org.cache2k.core.IntegrityState;

public class ClockEviction
extends AbstractEviction {
    private long hits;
    private long runCnt;
    private long scan24hCnt;
    private long scanCnt;
    private long size = 0L;
    private Entry hand = null;

    public ClockEviction(HeapCache _heapCache, HeapCacheListener _listener, long _maxSize) {
        super(_heapCache, _listener, _maxSize);
    }

    @Override
    public long getHitCount() {
        return this.hits + (long)this.sumUpListHits(this.hand);
    }

    private int sumUpListHits(Entry e) {
        if (e == null) {
            return 0;
        }
        int cnt = 0;
        Entry _head = e;
        do {
            cnt = (int)((long)cnt + e.hitCnt);
        } while ((e = e.prev) != _head);
        return cnt;
    }

    @Override
    public long removeAll() {
        Entry _head;
        int _count = 0;
        Entry e = _head = this.hand;
        long _hits = 0L;
        if (e != null) {
            Entry _next;
            do {
                _hits += e.hitCnt;
                _next = e.prev;
                e.removedFromList();
                ++_count;
            } while ((e = _next) != _head);
            this.hits += _hits;
        }
        return _count;
    }

    @Override
    protected void removeFromReplacementList(Entry e) {
        this.hand = Entry.removeFromCyclicList(this.hand, e);
        this.hits += e.hitCnt;
        --this.size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.size;
        this.hand = Entry.insertIntoTailCyclicList(this.hand, e);
    }

    @Override
    protected Entry findEvictionCandidate(Entry _previous) {
        ++this.runCnt;
        int _scanCnt = 0;
        while (this.hand.hitCnt > 0L) {
            ++_scanCnt;
            this.hits += this.hand.hitCnt;
            this.hand.hitCnt = 0L;
            this.hand = this.hand.next;
        }
        if ((long)_scanCnt > this.size) {
            ++this.scan24hCnt;
        }
        this.scanCnt += (long)_scanCnt;
        return this.hand;
    }

    @Override
    public void checkIntegrity(IntegrityState _integrityState) {
        _integrityState.check("checkCyclicListIntegrity(hand)", Entry.checkCyclicListIntegrity(this.hand)).checkEquals("getCyclicListEntryCount(hand) == size", (long)Entry.getCyclicListEntryCount(this.hand), this.size);
    }

    @Override
    public String getExtraStatistics() {
        return ", clockRunCnt=" + this.runCnt + ", scanCnt=" + this.scanCnt + ", scan24hCnt=" + this.scan24hCnt;
    }
}

