/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.core;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CustomizationException;
import org.cache2k.configuration.CustomizationSupplier;
import org.cache2k.core.CacheInternalError;
import org.cache2k.core.ConcurrentMapWrapper;
import org.cache2k.core.Entry;
import org.cache2k.core.EntryAction;
import org.cache2k.core.InternalCache;
import org.cache2k.core.StorageMetrics;
import org.cache2k.core.operation.Semantic;
import org.cache2k.core.storageApi.StorageAdapter;
import org.cache2k.processor.EntryProcessingException;
import org.cache2k.processor.EntryProcessingResult;
import org.cache2k.processor.EntryProcessor;

public abstract class BaseCache<K, V>
implements InternalCache<K, V> {
    protected abstract Iterator<CacheEntry<K, V>> iterator();

    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                final Iterator it = BaseCache.this.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((CacheEntry)it.next()).getKey();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<CacheEntry<K, V>> entries() {
        return new Iterable<CacheEntry<K, V>>(){

            @Override
            public Iterator<CacheEntry<K, V>> iterator() {
                return BaseCache.this.iterator();
            }
        };
    }

    public void removeAll() {
        for (K key : this.keys()) {
            this.remove(key);
        }
    }

    public void removeAll(Iterable<? extends K> _keys) {
        for (K k : _keys) {
            this.remove(k);
        }
    }

    public <X> X requestInterface(Class<X> _type) {
        if (_type.equals(ConcurrentMap.class) || _type.equals(Map.class)) {
            return (X)new ConcurrentMapWrapper(this);
        }
        if (_type.isAssignableFrom(this.getClass())) {
            return (X)this;
        }
        return null;
    }

    public ConcurrentMap<K, V> asMap() {
        return new ConcurrentMapWrapper(this);
    }

    @Override
    public StorageAdapter getStorage() {
        return null;
    }

    public <R> Map<K, EntryProcessingResult<R>> invokeAll(Iterable<? extends K> keys, EntryProcessor<K, V, R> entryProcessor) {
        HashMap<K, Object> m = new HashMap<K, Object>();
        for (K k : keys) {
            try {
                final Object _result = this.invoke(k, entryProcessor);
                if (_result == null) continue;
                m.put(k, new EntryProcessingResult<R>(){

                    public R getResult() {
                        return _result;
                    }

                    public Throwable getException() {
                        return null;
                    }
                });
            }
            catch (EntryProcessingException t) {
                final Throwable _cause = t.getCause();
                m.put(k, new EntryProcessingResult<R>(){

                    public R getResult() {
                        throw new EntryProcessingException(_cause);
                    }

                    public Throwable getException() {
                        return _cause;
                    }
                });
            }
        }
        return m;
    }

    protected <R> R execute(K key, Entry<K, V> e, Semantic<K, V, R> op) {
        EntryAction<K, V, R> _action = this.createEntryAction(key, e, op);
        return this.execute(op, _action);
    }

    protected abstract <R> EntryAction<K, V, R> createEntryAction(K var1, Entry<K, V> var2, Semantic<K, V, R> var3);

    protected <R> R execute(Semantic<K, V, R> op, EntryAction<K, V, R> _action) {
        op.start(_action);
        if (_action.entryLocked) {
            throw new CacheInternalError("entry not unlocked?");
        }
        RuntimeException t = _action.exceptionToPropagate;
        if (t != null) {
            t.fillInStackTrace();
            throw t;
        }
        return _action.result;
    }

    protected <R> R execute(K key, Semantic<K, V, R> op) {
        return this.execute(key, null, op);
    }

    @Override
    public StorageMetrics getStorageMetrics() {
        return StorageMetrics.DUMMY;
    }

    @Override
    public <T> T createCustomization(CustomizationSupplier<T> f) {
        if (f == null) {
            return null;
        }
        try {
            return (T)f.supply(this.getCacheManager());
        }
        catch (Exception ex) {
            throw new CustomizationException("Initialization of customization failed", (Throwable)ex);
        }
    }

    @Override
    public void closeCustomization(Object _customization) {
        if (_customization instanceof Closeable) {
            try {
                ((Closeable)_customization).close();
            }
            catch (Exception e) {
                throw new CacheException("exception on customization close", (Throwable)e);
            }
        }
    }

    public void clearAndClose() {
        this.close();
    }
}

