/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.xmlConfiguration;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.cache2k.xmlConfiguration.AbstractConfigurationTokenizer;
import org.cache2k.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.xmlConfiguration.TokenizerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XppConfigTokenizer
extends AbstractConfigurationTokenizer {
    private final XmlPullParser input;
    private final LinkedList<String> hierarchy = new LinkedList();
    private String startName;
    private String value;
    private boolean startFlag = true;

    XppConfigTokenizer(String _source, InputStream is, String _encoding) throws XmlPullParserException {
        super(_source);
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        this.input = factory.newPullParser();
        this.input.setInput(is, _encoding);
    }

    @Override
    public int getLineNumber() {
        return this.input.getLineNumber();
    }

    @Override
    public ConfigurationTokenizer.Item next() throws Exception {
        int _eventType;
        while ((_eventType = this.nextEvent()) != 1) {
            switch (_eventType) {
                case 2: {
                    if (this.startName != null) {
                        this.hierarchy.push(this.startName);
                        this.startName = this.input.getName();
                        return this.returnNest(this.hierarchy.element());
                    }
                    this.startName = this.input.getName();
                    break;
                }
                case 4: {
                    this.value = this.input.getText();
                    break;
                }
                case 3: {
                    String _name = this.input.getName();
                    if (this.startName != null && this.startName.equals(_name)) {
                        this.startName = null;
                        return this.returnProperty(_name, this.value);
                    }
                    if (!_name.equals(this.hierarchy.element())) break;
                    this.hierarchy.pop();
                    return this.returnUnnest();
                }
            }
        }
        return null;
    }

    private int nextEvent() throws XmlPullParserException, IOException {
        if (this.startFlag) {
            this.startFlag = false;
            return this.input.getEventType();
        }
        return this.input.next();
    }

    public static class Factory
    implements TokenizerFactory {
        @Override
        public ConfigurationTokenizer createTokenizer(String _source, InputStream in, String _encoding) throws XmlPullParserException {
            return new XppConfigTokenizer(_source, in, _encoding);
        }
    }
}

