/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.xmlConfiguration;

import java.io.InputStream;
import java.util.LinkedList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.cache2k.xmlConfiguration.AbstractConfigurationTokenizer;
import org.cache2k.xmlConfiguration.ConfigurationTokenizer;
import org.cache2k.xmlConfiguration.TokenizerFactory;

public class StaxConfigTokenizer
extends AbstractConfigurationTokenizer {
    private XMLStreamReader input;
    private LinkedList<String> hierarchy = new LinkedList();
    private String startName;
    private String value;

    public StaxConfigTokenizer(String _source, InputStream in, String _encoding) throws XMLStreamException {
        super(_source);
        XMLInputFactory f = XMLInputFactory.newInstance();
        this.input = f.createXMLStreamReader(in, _encoding);
    }

    @Override
    public int getLineNumber() {
        return this.input.getLocation().getLineNumber();
    }

    @Override
    public ConfigurationTokenizer.Item next() throws Exception {
        while (this.input.hasNext()) {
            int _type = this.input.next();
            switch (_type) {
                case 1: {
                    if (this.startName != null) {
                        this.hierarchy.push(this.startName);
                        this.startName = this.input.getLocalName();
                        return this.returnNest(this.hierarchy.element());
                    }
                    this.startName = this.input.getLocalName();
                    break;
                }
                case 4: {
                    this.value = this.input.getText();
                    break;
                }
                case 2: {
                    String _name = this.input.getLocalName();
                    if (this.startName != null && this.startName.equals(_name)) {
                        this.startName = null;
                        return this.returnProperty(_name, this.value);
                    }
                    if (!_name.equals(this.hierarchy.element())) break;
                    this.hierarchy.pop();
                    return this.returnUnnest();
                }
            }
        }
        return null;
    }

    public static class Factory
    implements TokenizerFactory {
        @Override
        public ConfigurationTokenizer createTokenizer(String _source, InputStream in, String _encoding) throws XMLStreamException {
            return new StaxConfigTokenizer(_source, in, _encoding);
        }
    }
}

