/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.ee.impl;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.cache2k.Cache;
import org.cache2k.CacheException;
import org.cache2k.CacheManager;
import org.cache2k.core.CacheManagerImpl;
import org.cache2k.core.InternalCache;
import org.cache2k.core.spi.CacheLifeCycleListener;
import org.cache2k.core.spi.CacheManagerLifeCycleListener;
import org.cache2k.ee.impl.CacheMXBeanImpl;
import org.cache2k.ee.impl.ManagerMXBeanImpl;

public class JmxSupport
implements CacheLifeCycleListener,
CacheManagerLifeCycleListener {
    @Override
    public void cacheCreated(Cache c) {
        InternalCache ic = (InternalCache)c;
        if (!ic.getCommonMetrics().isDisabled()) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            String _name = this.standardName(c.getCacheManager(), c);
            try {
                mbs.registerMBean(new CacheMXBeanImpl(ic), new ObjectName(_name));
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            }
            catch (Exception e) {
                throw new CacheException("register JMX bean, ObjectName: " + _name, e);
            }
        }
    }

    @Override
    public void cacheDestroyed(Cache c) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String _name = this.standardName(c.getCacheManager(), c);
        try {
            mbs.unregisterMBean(new ObjectName(_name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Exception e) {
            throw new CacheException("unregister JMX bean, ObjectName: " + _name, e);
        }
    }

    @Override
    public void managerCreated(CacheManager m) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ManagerMXBeanImpl _mBean = new ManagerMXBeanImpl((CacheManagerImpl)m);
        String _name = JmxSupport.managerName(m);
        try {
            mbs.registerMBean(_mBean, new ObjectName(_name));
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
        }
        catch (Exception e) {
            throw new CacheException("register JMX bean, ObjectName: " + _name, e);
        }
    }

    @Override
    public void managerDestroyed(CacheManager m) {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String _name = JmxSupport.managerName(m);
        try {
            try {
                mbs.unregisterMBean(new ObjectName(_name));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        catch (Exception e) {
            throw new CacheException("Error unregister JMX bean, ObjectName: " + _name, e);
        }
    }

    private static String managerName(CacheManager cm) {
        return "org.cache2k:type=CacheManager,name=" + JmxSupport.sanitizeNameAsJmxValue(cm.getName());
    }

    private String standardName(CacheManager cm, Cache c) {
        return "org.cache2k:type=Cache,manager=" + JmxSupport.sanitizeNameAsJmxValue(cm.getName()) + ",name=" + JmxSupport.sanitizeNameAsJmxValue(c.getName());
    }

    private static String sanitizeNameAsJmxValue(String s) {
        if (s.indexOf(44) >= 0) {
            return '\"' + s + '\"';
        }
        return s;
    }
}

