/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.util.Arrays;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.opencv_core.Point2fVector;
import org.bytedeco.opencv.presets.opencv_core;

@Name(value={"std::vector<std::vector<cv::Point2f> >"})
@Properties(inherit={opencv_core.class})
public class Point2fVectorVector
extends Pointer {
    public Point2fVectorVector(Pointer p) {
        super(p);
    }

    public Point2fVectorVector(Point2fVector value) {
        this(1L);
        this.put(0L, value);
    }

    public Point2fVectorVector(Point2fVector ... array) {
        this(array.length);
        this.put(array);
    }

    public Point2fVectorVector() {
        this.allocate();
    }

    public Point2fVectorVector(long n) {
        this.allocate(n);
    }

    private native void allocate();

    private native void allocate(@Cast(value={"size_t"}) long var1);

    @Name(value={"operator="})
    @ByRef
    public native Point2fVectorVector put(@ByRef Point2fVectorVector var1);

    public boolean empty() {
        return this.size() == 0L;
    }

    public native long size();

    public void clear() {
        this.resize(0L);
    }

    public native void resize(@Cast(value={"size_t"}) long var1);

    @Index(function="at")
    @ByRef
    public native Point2fVector get(@Cast(value={"size_t"}) long var1);

    public native Point2fVectorVector put(@Cast(value={"size_t"}) long var1, Point2fVector var3);

    @ByVal
    public native Iterator insert(@ByVal Iterator var1, @ByRef Point2fVector var2);

    @ByVal
    public native Iterator erase(@ByVal Iterator var1);

    @ByVal
    public native Iterator begin();

    @ByVal
    public native Iterator end();

    public Point2fVector[] get() {
        Point2fVector[] array = new Point2fVector[this.size() < Integer.MAX_VALUE ? (int)this.size() : Integer.MAX_VALUE];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public String toString() {
        return Arrays.toString((Object[])this.get());
    }

    public Point2fVector pop_back() {
        long size = this.size();
        Point2fVector value = this.get(size - 1L);
        this.resize(size - 1L);
        return value;
    }

    public Point2fVectorVector push_back(Point2fVector value) {
        long size = this.size();
        this.resize(size + 1L);
        return this.put(size, value);
    }

    public Point2fVectorVector put(Point2fVector value) {
        if (this.size() != 1L) {
            this.resize(1L);
        }
        return this.put(0L, value);
    }

    public Point2fVectorVector put(Point2fVector ... array) {
        if (this.size() != (long)array.length) {
            this.resize(array.length);
        }
        for (int i = 0; i < array.length; ++i) {
            this.put(i, array[i]);
        }
        return this;
    }

    static {
        Loader.load();
    }

    @NoOffset
    @Name(value={"iterator"})
    public static class Iterator
    extends Pointer {
        public Iterator(Pointer p) {
            super(p);
        }

        public Iterator() {
        }

        @Name(value={"operator++"})
        @ByRef
        public native Iterator increment();

        @Name(value={"operator=="})
        public native boolean equals(@ByRef Iterator var1);

        @Name(value={"operator*"})
        @ByRef
        @Const
        public native Point2fVector get();
    }
}

