/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.LongIndexer;

public class LongArrayIndexer
extends LongIndexer {
    protected long[] array;

    public LongArrayIndexer(long[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public LongArrayIndexer(long[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public long[] array() {
        return this.array;
    }

    @Override
    public long get(long i) {
        return this.array[(int)i];
    }

    @Override
    public LongIndexer get(long i, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public long get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public LongIndexer get(long i, long j, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public long get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public long get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public LongIndexer get(long[] indices, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public LongIndexer put(long i, long l) {
        this.array[(int)i] = l;
        return this;
    }

    @Override
    public LongIndexer put(long i, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = l[offset + n];
        }
        return this;
    }

    @Override
    public LongIndexer put(long i, long j, long l) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = l;
        return this;
    }

    @Override
    public LongIndexer put(long i, long j, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = l[offset + n];
        }
        return this;
    }

    @Override
    public LongIndexer put(long i, long j, long k, long l) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = l;
        return this;
    }

    @Override
    public LongIndexer put(long[] indices, long l) {
        this.array[(int)this.index((long[])indices)] = l;
        return this;
    }

    @Override
    public LongIndexer put(long[] indices, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = l[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

