/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.DoubleIndexer;

public class DoubleArrayIndexer
extends DoubleIndexer {
    protected double[] array;

    public DoubleArrayIndexer(double[] array) {
        this(array, new long[]{array.length}, ONE_STRIDE);
    }

    public DoubleArrayIndexer(double[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public double[] array() {
        return this.array;
    }

    @Override
    public double get(long i) {
        return this.array[(int)i];
    }

    @Override
    public DoubleIndexer get(long i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public double get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public DoubleIndexer get(long i, long j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public double get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public double get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public DoubleIndexer get(long[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long i, double d) {
        this.array[(int)i] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(long i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = d[offset + n];
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long i, long j, double d) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(long i, long j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = d[offset + n];
        }
        return this;
    }

    @Override
    public DoubleIndexer put(long i, long j, long k, double d) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(long[] indices, double d) {
        this.array[(int)this.index((long[])indices)] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(long[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = d[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

