/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.annotation.Platform;
import org.bytedeco.javacpp.tools.Logger;

@Platform
public class Pointer
implements AutoCloseable {
    private static final Logger logger = Logger.create(Pointer.class);
    private static final ReferenceQueue<Pointer> referenceQueue;
    static final Thread deallocatorThread;
    static final long maxBytes;
    static final int maxRetries;
    protected long address = 0L;
    protected long position = 0L;
    protected long limit = 0L;
    protected long capacity = 0L;
    private Deallocator deallocator = null;

    public Pointer() {
    }

    public Pointer(final Pointer p) {
        if (p != null) {
            this.address = p.address;
            this.position = p.position;
            this.limit = p.limit;
            this.capacity = p.capacity;
            if (p.deallocator != null) {
                this.deallocator = new Deallocator(){

                    @Override
                    public void deallocate() {
                        p.deallocate();
                    }
                };
            }
        }
    }

    public Pointer(final Buffer b) {
        if (b != null) {
            this.allocate(b);
        }
        if (!this.isNull()) {
            this.position = b.position();
            this.limit = b.limit();
            this.capacity = b.capacity();
            this.deallocator = new Deallocator(){
                Buffer bb;
                {
                    this.bb = b;
                }

                @Override
                public void deallocate() {
                    this.bb = null;
                }
            };
        }
    }

    private native void allocate(Buffer var1);

    void init(long allocatedAddress, long allocatedCapacity, long ownerAddress, long deallocatorAddress) {
        this.address = allocatedAddress;
        this.position = 0L;
        this.limit = allocatedCapacity;
        this.capacity = allocatedCapacity;
        if (ownerAddress != 0L && deallocatorAddress != 0L) {
            this.deallocator(new NativeDeallocator(this, ownerAddress, deallocatorAddress));
        }
    }

    protected static <P extends Pointer> P withDeallocator(P p) {
        return p.deallocator(new CustomDeallocator(p));
    }

    public static void deallocateReferences() {
        DeallocatorReference r;
        while (referenceQueue != null && (r = (DeallocatorReference)referenceQueue.poll()) != null) {
            r.clear();
            r.remove();
        }
    }

    public static long maxBytes() {
        return maxBytes;
    }

    public static long totalBytes() {
        return DeallocatorReference.totalBytes;
    }

    public boolean isNull() {
        return this.address == 0L;
    }

    public void setNull() {
        this.address = 0L;
    }

    public long address() {
        return this.address;
    }

    public long position() {
        return this.position;
    }

    public <P extends Pointer> P position(long position) {
        this.position = position;
        return (P)this;
    }

    public long limit() {
        return this.limit;
    }

    public <P extends Pointer> P limit(long limit) {
        this.limit = limit;
        return (P)this;
    }

    public long capacity() {
        return this.capacity;
    }

    public <P extends Pointer> P capacity(long capacity) {
        this.limit = capacity;
        this.capacity = capacity;
        return (P)this;
    }

    protected Deallocator deallocator() {
        return this.deallocator;
    }

    protected <P extends Pointer> P deallocator(Deallocator deallocator) {
        if (this.deallocator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Predeallocating " + this);
            }
            this.deallocator.deallocate();
            this.deallocator = null;
        }
        if (deallocator != null && !deallocator.equals(null)) {
            this.deallocator = deallocator;
            DeallocatorReference r = deallocator instanceof DeallocatorReference ? (DeallocatorReference)((Object)deallocator) : new DeallocatorReference(this, deallocator);
            int count = 0;
            while (count++ < maxRetries && maxBytes > 0L && DeallocatorReference.totalBytes + r.bytes > maxBytes) {
                try {
                    System.gc();
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (maxBytes > 0L && DeallocatorReference.totalBytes + r.bytes > maxBytes) {
                this.deallocate();
                throw new OutOfMemoryError("Cannot allocate " + DeallocatorReference.totalBytes + " + " + r.bytes + " bytes (> Pointer.maxBytes)");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Registering " + this);
            }
            r.add();
        }
        return (P)this;
    }

    @Override
    public void close() {
        this.deallocate();
    }

    public void deallocate() {
        this.deallocate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deallocate(boolean deallocate) {
        if (deallocate && this.deallocator != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deallocating " + this);
            }
            this.deallocator.deallocate();
            this.address = 0L;
            return;
        }
        Class<DeallocatorReference> clazz = DeallocatorReference.class;
        synchronized (DeallocatorReference.class) {
            DeallocatorReference r = DeallocatorReference.head;
            while (r != null) {
                if (r.deallocator == this.deallocator) {
                    r.deallocator = null;
                    r.clear();
                    r.remove();
                    break;
                }
                r = r.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int offsetof(String member) {
        int offset = -1;
        try {
            Class<?> c = this.getClass();
            if (c != Pointer.class) {
                offset = Loader.offsetof(c, member);
            }
        }
        catch (NullPointerException e) {
            return offset;
        }
        return offset;
    }

    public int sizeof() {
        Class<?> c = this.getClass();
        if (c == Pointer.class || c == BytePointer.class) {
            return 1;
        }
        return this.offsetof("sizeof");
    }

    private native ByteBuffer asDirectBuffer();

    public ByteBuffer asByteBuffer() {
        if (this.isNull()) {
            return null;
        }
        if (this.limit > 0L && this.limit < this.position) {
            throw new IllegalArgumentException("limit < position: (" + this.limit + " < " + this.position + ")");
        }
        int valueSize = this.sizeof();
        long arrayPosition = this.position;
        long arrayLimit = this.limit;
        this.position = (long)valueSize * arrayPosition;
        this.limit = (long)valueSize * (arrayLimit <= 0L ? arrayPosition + 1L : arrayLimit);
        ByteBuffer b = this.asDirectBuffer().order(ByteOrder.nativeOrder());
        this.position = arrayPosition;
        this.limit = arrayLimit;
        return b;
    }

    public Buffer asBuffer() {
        return this.asByteBuffer();
    }

    public static native Pointer memchr(Pointer var0, int var1, long var2);

    public static native int memcmp(Pointer var0, Pointer var1, long var2);

    public static native Pointer memcpy(Pointer var0, Pointer var1, long var2);

    public static native Pointer memmove(Pointer var0, Pointer var1, long var2);

    public static native Pointer memset(Pointer var0, int var1, long var2);

    public <P extends Pointer> P put(Pointer p) {
        if (p.limit > 0L && p.limit < p.position) {
            throw new IllegalArgumentException("limit < position: (" + p.limit + " < " + p.position + ")");
        }
        int size = this.sizeof();
        int psize = p.sizeof();
        long length = (long)psize * (p.limit <= 0L ? 1L : p.limit - p.position);
        this.position *= (long)size;
        p.position *= (long)psize;
        Pointer.memcpy(this, p, length);
        this.position /= (long)size;
        p.position /= (long)psize;
        return (P)this;
    }

    public <P extends Pointer> P fill(int b) {
        if (this.limit > 0L && this.limit < this.position) {
            throw new IllegalArgumentException("limit < position: (" + this.limit + " < " + this.position + ")");
        }
        int size = this.sizeof();
        long length = (long)size * (this.limit <= 0L ? 1L : this.limit - this.position);
        this.position *= (long)size;
        Pointer.memset(this, b, length);
        this.position /= (long)size;
        return (P)this;
    }

    public <P extends Pointer> P zero() {
        return this.fill(0);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return this.isNull();
        }
        if (obj.getClass() != this.getClass() && obj.getClass() != Pointer.class && this.getClass() != Pointer.class) {
            return false;
        }
        Pointer other = (Pointer)obj;
        return this.address == other.address && this.position == other.position;
    }

    public int hashCode() {
        return (int)this.address;
    }

    public String toString() {
        return this.getClass().getName() + "[address=0x" + Long.toHexString(this.address) + ",position=" + this.position + ",limit=" + this.limit + ",capacity=" + this.capacity + ",deallocator=" + this.deallocator + "]";
    }

    static {
        String s = System.getProperty("org.bytedeco.javacpp.nopointergc", "false").toLowerCase();
        if (s.equals("true") || s.equals("t") || s.equals("")) {
            referenceQueue = null;
            deallocatorThread = null;
        } else {
            referenceQueue = new ReferenceQueue();
            deallocatorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            DeallocatorReference r = (DeallocatorReference)referenceQueue.remove();
                            r.clear();
                            r.remove();
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            });
            deallocatorThread.setName("JavaCPP Deallocator");
            deallocatorThread.setPriority(10);
            deallocatorThread.setDaemon(true);
            deallocatorThread.start();
        }
        long m = Runtime.getRuntime().maxMemory();
        s = System.getProperty("org.bytedeco.javacpp.maxbytes");
        if (s != null && s.length() > 0) {
            try {
                m = Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        maxBytes = m;
        int n = 10;
        s = System.getProperty("org.bytedeco.javacpp.maxretries");
        if (s != null && s.length() > 0) {
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        maxRetries = n;
    }

    static class DeallocatorReference
    extends PhantomReference<Pointer> {
        static volatile DeallocatorReference head = null;
        volatile DeallocatorReference prev = null;
        volatile DeallocatorReference next = null;
        Deallocator deallocator;
        static volatile long totalBytes = 0L;
        long bytes;

        DeallocatorReference(Pointer p, Deallocator deallocator) {
            super(p, referenceQueue);
            this.deallocator = deallocator;
            this.bytes = p.capacity * (long)p.sizeof();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void add() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (head == null) {
                    head = this;
                } else {
                    this.next = head;
                    this.next.prev = head = this;
                }
                totalBytes += this.bytes;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void remove() {
            Class<DeallocatorReference> clazz = DeallocatorReference.class;
            synchronized (DeallocatorReference.class) {
                if (this.prev == this && this.next == this) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (this.prev == null) {
                    head = this.next;
                } else {
                    this.prev.next = this.next;
                }
                if (this.next != null) {
                    this.next.prev = this.prev;
                }
                this.prev = this.next = this;
                totalBytes -= this.bytes;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void clear() {
            super.clear();
            if (this.deallocator != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Collecting " + this);
                }
                this.deallocator.deallocate();
                this.deallocator = null;
            }
        }

        public String toString() {
            return this.getClass().getName() + "[deallocator=" + this.deallocator + "]";
        }
    }

    protected static class NativeDeallocator
    extends DeallocatorReference
    implements Deallocator {
        private long ownerAddress;
        private long deallocatorAddress;

        NativeDeallocator(Pointer p, long ownerAddress, long deallocatorAddress) {
            super(p, (Deallocator)null);
            this.deallocator = this;
            this.ownerAddress = ownerAddress;
            this.deallocatorAddress = deallocatorAddress;
        }

        @Override
        public void deallocate() {
            if (this.ownerAddress != 0L && this.deallocatorAddress != 0L) {
                this.deallocate(this.ownerAddress, this.deallocatorAddress);
                this.deallocatorAddress = 0L;
                this.ownerAddress = 0L;
            }
        }

        private native void deallocate(long var1, long var3);

        @Override
        public String toString() {
            return this.getClass().getName() + "[ownerAddress=0x" + Long.toHexString(this.ownerAddress) + ",deallocatorAddress=0x" + Long.toHexString(this.deallocatorAddress) + "]";
        }
    }

    protected static class CustomDeallocator
    extends DeallocatorReference
    implements Deallocator {
        Pointer pointer = null;
        Method method = null;

        public CustomDeallocator(Pointer p) {
            super(p, (Deallocator)null);
            this.deallocator = this;
            Class<?> cls = p.getClass();
            for (Method m : cls.getDeclaredMethods()) {
                Class<?>[] parameters = m.getParameterTypes();
                if (!Modifier.isStatic(m.getModifiers()) || !m.getReturnType().equals(Void.TYPE) || !m.getName().equals("deallocate") || parameters.length != 1 || !Pointer.class.isAssignableFrom(parameters[0])) continue;
                m.setAccessible(true);
                this.method = m;
                break;
            }
            if (this.method == null) {
                throw new RuntimeException(new NoSuchMethodException("static void " + cls.getCanonicalName() + ".deallocate(" + Pointer.class.getCanonicalName() + ")"));
            }
            try {
                Constructor<?> c = cls.getConstructor(Pointer.class);
                c.setAccessible(true);
                this.pointer = (Pointer)c.newInstance(p);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void deallocate() {
            try {
                this.method.invoke(null, this.pointer);
                this.pointer.setNull();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[pointer=" + this.pointer + ",method=" + this.method + "]";
        }
    }

    protected static interface Deallocator {
        public void deallocate();
    }
}

