/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.helper;

import java.nio.Buffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Index;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.indexer.ByteIndexer;
import org.bytedeco.javacpp.indexer.DoubleIndexer;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.javacpp.indexer.Indexable;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.IntIndexer;
import org.bytedeco.javacpp.indexer.LongIndexer;
import org.bytedeco.javacpp.indexer.ShortIndexer;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.javacpp.indexer.UShortIndexer;
import org.bytedeco.javacpp.tensorflow;

public class tensorflow
extends org.bytedeco.javacpp.presets.tensorflow {

    public static abstract class AbstractSession
    extends Pointer {
        public AbstractSession(Pointer p) {
            super(p);
        }

        public AbstractSession(tensorflow.SessionOptions options) {
            if (org.bytedeco.javacpp.tensorflow.NewSession(options, (tensorflow.Session)this).ok() && !this.isNull()) {
                this.deallocator(new DeleteDeallocator((tensorflow.Session)this));
            }
        }

        @Namespace
        public static native void delete(tensorflow.Session var0);

        static {
            Loader.load();
        }

        protected static class DeleteDeallocator
        extends tensorflow.Session
        implements Pointer.Deallocator {
            DeleteDeallocator(tensorflow.Session p) {
                super(p);
            }

            public void deallocate() {
                tensorflow.Session.delete(this);
                this.setNull();
            }
        }
    }

    public static abstract class AbstractTensor
    extends Pointer
    implements Indexable {
        public AbstractTensor(Pointer p) {
            super(p);
        }

        public abstract int dtype();

        public abstract int dims();

        public abstract long dim_size(int var1);

        public abstract long NumElements();

        public abstract long TotalBytes();

        public abstract BytePointer tensor_data();

        public <B extends Buffer> B createBuffer() {
            return this.createBuffer(0);
        }

        public <B extends Buffer> B createBuffer(int index) {
            BytePointer ptr = this.tensor_data();
            int size = (int)this.TotalBytes();
            switch (this.dtype()) {
                case 1: 
                case 8: {
                    return (B)new FloatPointer((Pointer)ptr).position((long)index).capacity((long)(size / 4)).asBuffer();
                }
                case 2: {
                    return (B)new DoublePointer((Pointer)ptr).position((long)index).capacity((long)(size / 8)).asBuffer();
                }
                case 3: 
                case 13: {
                    return (B)new IntPointer((Pointer)ptr).position((long)index).capacity((long)(size / 4)).asBuffer();
                }
                case 4: 
                case 6: 
                case 10: 
                case 11: 
                case 12: {
                    return (B)ptr.position((long)index).capacity((long)size).asBuffer();
                }
                case 5: 
                case 14: {
                    return (B)new ShortPointer((Pointer)ptr).position((long)index).capacity((long)(size / 2)).asBuffer();
                }
                case 9: {
                    return (B)new LongPointer((Pointer)ptr).position((long)index).capacity((long)(size / 8)).asBuffer();
                }
            }
            assert (false);
            return null;
        }

        public <I extends Indexer> I createIndexer() {
            return this.createIndexer(true);
        }

        public <I extends Indexer> I createIndexer(boolean direct) {
            BytePointer ptr = this.tensor_data();
            int size = (int)this.TotalBytes();
            boolean complex = this.dtype() == 8;
            int dims = complex ? this.dims() + 1 : this.dims();
            long[] sizes = new long[dims];
            long[] strides = new long[dims];
            sizes[dims - 1] = complex ? 2L : (long)((int)this.dim_size(dims - 1));
            strides[dims - 1] = 1L;
            for (int i = dims - 2; i >= 0; --i) {
                sizes[i] = (int)this.dim_size(i);
                strides[i] = sizes[i + 1] * strides[i + 1];
            }
            switch (this.dtype()) {
                case 1: 
                case 8: {
                    return (I)FloatIndexer.create((FloatPointer)new FloatPointer((Pointer)ptr).capacity((long)(size / 4)), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 2: {
                    return (I)DoubleIndexer.create((DoublePointer)new DoublePointer((Pointer)ptr).capacity((long)(size / 8)), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 3: 
                case 13: {
                    return (I)IntIndexer.create((IntPointer)new IntPointer((Pointer)ptr).capacity((long)(size / 4)), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 4: 
                case 10: 
                case 12: {
                    return (I)UByteIndexer.create((BytePointer)ptr.capacity((long)size), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 6: 
                case 11: {
                    return (I)ByteIndexer.create((BytePointer)ptr.capacity((long)size), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 14: {
                    return (I)UShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity((long)(size / 2)), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 5: {
                    return (I)ShortIndexer.create((ShortPointer)new ShortPointer((Pointer)ptr).capacity((long)(size / 2)), (long[])sizes, (long[])strides, (boolean)direct);
                }
                case 9: {
                    return (I)LongIndexer.create((LongPointer)new LongPointer((Pointer)ptr).capacity((long)(size / 8)), (long[])sizes, (long[])strides, (boolean)direct);
                }
            }
            assert (false);
            return null;
        }

        public StringArray createStringArray() {
            if (this.dtype() != 7) {
                return null;
            }
            long size = this.NumElements();
            return (StringArray)new StringArray((Pointer)this.tensor_data()).capacity(size).limit(size);
        }

        static {
            Loader.load();
        }
    }

    @Name(value={"std::string"})
    public static class StringArray
    extends Pointer {
        public StringArray(Pointer p) {
            super(p);
        }

        public StringArray() {
            this.allocate();
        }

        private native void allocate();

        public StringArray(StringArray p) {
            this.allocate(p);
        }

        private native void allocate(@ByRef StringArray var1);

        public StringArray(BytePointer s, long count) {
            this.allocate(s, count);
        }

        private native void allocate(@Cast(value={"char*"}) BytePointer var1, long var2);

        public StringArray(String s) {
            this.allocate(s);
        }

        private native void allocate(String var1);

        @Name(value={"operator="})
        @ByRef
        public native StringArray put(@ByRef StringArray var1);

        @Name(value={"operator="})
        @ByRef
        public native StringArray put(String var1);

        public StringArray position(long position) {
            return (StringArray)super.position(position);
        }

        @Cast(value={"size_t"})
        public native long size();

        public native void resize(@Cast(value={"size_t"}) long var1);

        @Index
        @Cast(value={"char"})
        public native int get(@Cast(value={"size_t"}) long var1);

        public native StringArray put(@Cast(value={"size_t"}) long var1, int var3);

        @Cast(value={"const char*"})
        public native BytePointer data();

        public String toString() {
            long length = this.size();
            byte[] bytes = new byte[length < Integer.MAX_VALUE ? (int)length : Integer.MAX_VALUE];
            this.data().get(bytes);
            return new String(bytes);
        }

        static {
            Loader.load();
        }
    }
}

