// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avutil;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.ffmpeg.global.avutil.*;


/**
 * AVOption
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avutil.class)
public class AVOption extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVOption() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVOption(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVOption(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVOption position(long position) {
        return (AVOption)super.position(position);
    }
    @Override public AVOption getPointer(long i) {
        return new AVOption((Pointer)this).offsetAddress(i);
    }

    public native @Cast("const char*") BytePointer name(); public native AVOption name(BytePointer setter);

    /**
     * short English help text
     * \todo What about other languages?
     */
    public native @Cast("const char*") BytePointer help(); public native AVOption help(BytePointer setter);

    /**
     * Native access only.
     *
     * The offset relative to the context structure where the option
     * value is stored. It should be 0 for named constants.
     */
    public native int offset(); public native AVOption offset(int setter);
    public native @Cast("AVOptionType") int type(); public native AVOption type(int setter);

    /**
     * Native access only, except when documented otherwise.
     * the default value for scalar options
     */
        @Name("default_val.i64") public native @Cast("int64_t") long default_val_i64(); public native AVOption default_val_i64(long setter);
        @Name("default_val.dbl") public native double default_val_dbl(); public native AVOption default_val_dbl(double setter);
        @Name("default_val.str") public native @Cast("const char*") BytePointer default_val_str(); public native AVOption default_val_str(BytePointer setter);
        /* TODO those are unused now */
        @Name("default_val.q") public native @ByRef AVRational default_val_q(); public native AVOption default_val_q(AVRational setter);

        /**
         * Used for AV_OPT_TYPE_FLAG_ARRAY options. May be NULL.
         *
         * Foreign access to some members allowed, as noted in AVOptionArrayDef
         * documentation.
         */
        @Name("default_val.arr") public native @Const AVOptionArrayDef default_val_arr(); public native AVOption default_val_arr(AVOptionArrayDef setter);
    /** minimum valid value for the option */
    public native double min(); public native AVOption min(double setter);
    /** maximum valid value for the option */
    public native double max(); public native AVOption max(double setter);

    /**
     * A combination of AV_OPT_FLAG_*.
     */
    public native int flags(); public native AVOption flags(int setter);

    /**
     * The logical unit to which the option belongs. Non-constant
     * options and corresponding named constants share the same
     * unit. May be NULL.
     */
    public native @Cast("const char*") BytePointer unit(); public native AVOption unit(BytePointer setter);
}
