// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avformat;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

import static org.bytedeco.ffmpeg.global.avformat.*;


/**
 * AVStreamGroupTileGrid holds information on how to combine several
 * independent images on a single canvas for presentation.
 *
 * The output should be a \ref AVStreamGroupTileGrid.background "background"
 * colored \ref AVStreamGroupTileGrid.coded_width "coded_width" x
 * \ref AVStreamGroupTileGrid.coded_height "coded_height" canvas where a
 * \ref AVStreamGroupTileGrid.nb_tiles "nb_tiles" amount of tiles are placed in
 * the order they appear in the \ref AVStreamGroupTileGrid.offsets "offsets"
 * array, at the exact offset described for them. In particular, if two or more
 * tiles overlap, the image with higher index in the
 * \ref AVStreamGroupTileGrid.offsets "offsets" array takes priority.
 * Note that a single image may be used multiple times, i.e. multiple entries
 * in \ref AVStreamGroupTileGrid.offsets "offsets" may have the same value of
 * idx.
 *
 * The following is an example of a simple grid with 3 rows and 4 columns:
 *
 * +---+---+---+---+
 * | 0 | 1 | 2 | 3 |
 * +---+---+---+---+
 * | 4 | 5 | 6 | 7 |
 * +---+---+---+---+
 * | 8 | 9 |10 |11 |
 * +---+---+---+---+
 *
 * Assuming all tiles have a dimension of 512x512, the
 * \ref AVStreamGroupTileGrid.offsets "offset" of the topleft pixel of
 * the first \ref AVStreamGroup.streams "stream" in the group is "0,0", the
 * \ref AVStreamGroupTileGrid.offsets "offset" of the topleft pixel of
 * the second \ref AVStreamGroup.streams "stream" in the group is "512,0", the
 * \ref AVStreamGroupTileGrid.offsets "offset" of the topleft pixel of
 * the fifth \ref AVStreamGroup.streams "stream" in the group is "0,512", the
 * \ref AVStreamGroupTileGrid.offsets "offset", of the topleft pixel of
 * the sixth \ref AVStreamGroup.streams "stream" in the group is "512,512",
 * etc.
 *
 * The following is an example of a canvas with overlaping tiles:
 *
 * +-----------+
 * |   %%%%%   |
 * |***%%3%%{@literal @}\|
 * |**0%%%%%2{@literal @}|
 * |***##1{@literal @}{@literal @}\|
 * |   #####   |
 * +-----------+
 *
 * Assuming a canvas with size 1024x1024 and all tiles with a dimension of
 * 512x512, a possible \ref AVStreamGroupTileGrid.offsets "offset" for the
 * topleft pixel of the first \ref AVStreamGroup.streams "stream" in the group
 * would be 0x256, the \ref AVStreamGroupTileGrid.offsets "offset" for the
 * topleft pixel of the second \ref AVStreamGroup.streams "stream" in the group
 * would be 256x512, the \ref AVStreamGroupTileGrid.offsets "offset" for the
 * topleft pixel of the third \ref AVStreamGroup.streams "stream" in the group
 * would be 512x256, and the \ref AVStreamGroupTileGrid.offsets "offset" for
 * the topleft pixel of the fourth \ref AVStreamGroup.streams "stream" in the
 * group would be 256x0.
 *
 * sizeof(AVStreamGroupTileGrid) is not a part of the ABI and may only be
 * allocated by avformat_stream_group_create().
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avformat.class)
public class AVStreamGroupTileGrid extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVStreamGroupTileGrid() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVStreamGroupTileGrid(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVStreamGroupTileGrid(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVStreamGroupTileGrid position(long position) {
        return (AVStreamGroupTileGrid)super.position(position);
    }
    @Override public AVStreamGroupTileGrid getPointer(long i) {
        return new AVStreamGroupTileGrid((Pointer)this).offsetAddress(i);
    }

    public native @Const AVClass av_class(); public native AVStreamGroupTileGrid av_class(AVClass setter);

    /**
     * Amount of tiles in the grid.
     *
     * Must be > 0.
     */
    public native @Cast("unsigned int") int nb_tiles(); public native AVStreamGroupTileGrid nb_tiles(int setter);

    /**
     * Width of the canvas.
     *
     * Must be > 0.
     */
    public native int coded_width(); public native AVStreamGroupTileGrid coded_width(int setter);
    /**
     * Width of the canvas.
     *
     * Must be > 0.
     */
    public native int coded_height(); public native AVStreamGroupTileGrid coded_height(int setter);

    /**
     * An \ref nb_tiles sized array of offsets in pixels from the topleft edge
     * of the canvas, indicating where each stream should be placed.
     * It must be allocated with the av_malloc() family of functions.
     *
     * - demuxing: set by libavformat, must not be modified by the caller.
     * - muxing: set by the caller before avformat_write_header().
     *
     * Freed by libavformat in avformat_free_context().
     */
        /**
         * Index of the stream in the group this tile references.
         *
         * Must be < \ref AVStreamGroup.nb_streams "nb_streams".
         */
        @Name({"offsets", ".idx"}) public native @Cast("unsigned int") int offsets_idx(int i); public native AVStreamGroupTileGrid offsets_idx(int i, int setter);
        /**
         * Offset in pixels from the left edge of the canvas where the tile
         * should be placed.
         */
        @Name({"offsets", ".horizontal"}) public native int offsets_horizontal(int i); public native AVStreamGroupTileGrid offsets_horizontal(int i, int setter);
        /**
         * Offset in pixels from the top edge of the canvas where the tile
         * should be placed.
         */
        @Name({"offsets", ".vertical"}) public native int offsets_vertical(int i); public native AVStreamGroupTileGrid offsets_vertical(int i, int setter);

    /**
     * The pixel value per channel in RGBA format used if no pixel of any tile
     * is located at a particular pixel location.
     *
     * @see av_image_fill_color().
     * @see av_parse_color().
     */
    public native @Cast("uint8_t") byte background(int i); public native AVStreamGroupTileGrid background(int i, byte setter);
    @MemberGetter public native @Cast("uint8_t*") BytePointer background();

    /**
     * Offset in pixels from the left edge of the canvas where the actual image
     * meant for presentation starts.
     *
     * This field must be >= 0 and < \ref coded_width.
     */
    public native int horizontal_offset(); public native AVStreamGroupTileGrid horizontal_offset(int setter);
    /**
     * Offset in pixels from the top edge of the canvas where the actual image
     * meant for presentation starts.
     *
     * This field must be >= 0 and < \ref coded_height.
     */
    public native int vertical_offset(); public native AVStreamGroupTileGrid vertical_offset(int setter);

    /**
     * Width of the final image for presentation.
     *
     * Must be > 0 and <= (\ref coded_width - \ref horizontal_offset).
     * When it's not equal to (\ref coded_width - \ref horizontal_offset), the
     * result of (\ref coded_width - width - \ref horizontal_offset) is the
     * amount amount of pixels to be cropped from the right edge of the
     * final image before presentation.
     */
    public native int width(); public native AVStreamGroupTileGrid width(int setter);
    /**
     * Height of the final image for presentation.
     *
     * Must be > 0 and <= (\ref coded_height - \ref vertical_offset).
     * When it's not equal to (\ref coded_height - \ref vertical_offset), the
     * result of (\ref coded_height - height - \ref vertical_offset) is the
     * amount amount of pixels to be cropped from the bottom edge of the
     * final image before presentation.
     */
    public native int height(); public native AVStreamGroupTileGrid height(int setter);
}
