// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avformat;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

import static org.bytedeco.ffmpeg.global.avformat.*;


/**
 * AVStreamGroupLCEVC is meant to define the relation between video streams
 * and a data stream containing LCEVC enhancement layer NALUs.
 *
 * No more than one stream of \ref AVCodecParameters.codec_type "codec_type"
 * AVMEDIA_TYPE_DATA shall be present, and it must be of
 * \ref AVCodecParameters.codec_id "codec_id" AV_CODEC_ID_LCEVC.
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avformat.class)
public class AVStreamGroupLCEVC extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVStreamGroupLCEVC() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVStreamGroupLCEVC(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVStreamGroupLCEVC(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVStreamGroupLCEVC position(long position) {
        return (AVStreamGroupLCEVC)super.position(position);
    }
    @Override public AVStreamGroupLCEVC getPointer(long i) {
        return new AVStreamGroupLCEVC((Pointer)this).offsetAddress(i);
    }

    public native @Const AVClass av_class(); public native AVStreamGroupLCEVC av_class(AVClass setter);

    /**
     * Index of the LCEVC data stream in AVStreamGroup.
     */
    public native @Cast("unsigned int") int lcevc_index(); public native AVStreamGroupLCEVC lcevc_index(int setter);
    /**
     * Width of the final stream for presentation.
     */
    public native int width(); public native AVStreamGroupLCEVC width(int setter);
    /**
     * Height of the final image for presentation.
     */
    public native int height(); public native AVStreamGroupLCEVC height(int setter);
}
