// Targeted by JavaCPP version 1.5.11: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avformat;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

import static org.bytedeco.ffmpeg.global.avformat.*;

/**
 * \}
 */

/**
 * \addtogroup lavf_decoding
 * \{
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avformat.class)
public class AVInputFormat extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVInputFormat() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVInputFormat(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVInputFormat(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVInputFormat position(long position) {
        return (AVInputFormat)super.position(position);
    }
    @Override public AVInputFormat getPointer(long i) {
        return new AVInputFormat((Pointer)this).offsetAddress(i);
    }

    /**
     * A comma separated list of short names for the format. New names
     * may be appended with a minor bump.
     */
    public native @Cast("const char*") BytePointer name(); public native AVInputFormat name(BytePointer setter);

    /**
     * Descriptive name for the format, meant to be more human-readable
     * than name. You should use the NULL_IF_CONFIG_SMALL() macro
     * to define it.
     */
    public native @Cast("const char*") BytePointer long_name(); public native AVInputFormat long_name(BytePointer setter);

    /**
     * Can use flags: AVFMT_NOFILE, AVFMT_NEEDNUMBER, AVFMT_SHOW_IDS,
     * AVFMT_NOTIMESTAMPS, AVFMT_GENERIC_INDEX, AVFMT_TS_DISCONT, AVFMT_NOBINSEARCH,
     * AVFMT_NOGENSEARCH, AVFMT_NO_BYTE_SEEK, AVFMT_SEEK_TO_PTS.
     */
    public native int flags(); public native AVInputFormat flags(int setter);

    /**
     * If extensions are defined, then no probe is done. You should
     * usually not use extension format guessing because it is not
     * reliable enough
     */
    public native @Cast("const char*") BytePointer extensions(); public native AVInputFormat extensions(BytePointer setter);

    @MemberGetter public native @Const AVCodecTag codec_tag(int i);
    @MemberGetter public native @Cast("const AVCodecTag*const*") PointerPointer codec_tag();

    /** AVClass for the private context */
    public native @Const AVClass priv_class(); public native AVInputFormat priv_class(AVClass setter);

    /**
     * Comma-separated list of mime types.
     * It is used check for matching mime types while probing.
     * @see av_probe_input_format2
     */
    public native @Cast("const char*") BytePointer mime_type(); public native AVInputFormat mime_type(BytePointer setter);
}
