// Targeted by JavaCPP version 1.5.5: DO NOT EDIT THIS FILE

package org.bytedeco.ffmpeg.avformat;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.ffmpeg.avutil.*;
import static org.bytedeco.ffmpeg.global.avutil.*;
import org.bytedeco.ffmpeg.swresample.*;
import static org.bytedeco.ffmpeg.global.swresample.*;
import org.bytedeco.ffmpeg.avcodec.*;
import static org.bytedeco.ffmpeg.global.avcodec.*;

import static org.bytedeco.ffmpeg.global.avformat.*;

/**
 * \}
 */

/**
 * \addtogroup lavf_decoding
 * \{
 */
@Properties(inherit = org.bytedeco.ffmpeg.presets.avformat.class)
public class AVInputFormat extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AVInputFormat() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AVInputFormat(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AVInputFormat(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AVInputFormat position(long position) {
        return (AVInputFormat)super.position(position);
    }
    @Override public AVInputFormat getPointer(long i) {
        return new AVInputFormat((Pointer)this).position(position + i);
    }

    /**
     * A comma separated list of short names for the format. New names
     * may be appended with a minor bump.
     */
    public native @Cast("const char*") BytePointer name(); public native AVInputFormat name(BytePointer setter);

    /**
     * Descriptive name for the format, meant to be more human-readable
     * than name. You should use the NULL_IF_CONFIG_SMALL() macro
     * to define it.
     */
    public native @Cast("const char*") BytePointer long_name(); public native AVInputFormat long_name(BytePointer setter);

    /**
     * Can use flags: AVFMT_NOFILE, AVFMT_NEEDNUMBER, AVFMT_SHOW_IDS,
     * AVFMT_NOTIMESTAMPS, AVFMT_GENERIC_INDEX, AVFMT_TS_DISCONT, AVFMT_NOBINSEARCH,
     * AVFMT_NOGENSEARCH, AVFMT_NO_BYTE_SEEK, AVFMT_SEEK_TO_PTS.
     */
    public native int flags(); public native AVInputFormat flags(int setter);

    /**
     * If extensions are defined, then no probe is done. You should
     * usually not use extension format guessing because it is not
     * reliable enough
     */
    public native @Cast("const char*") BytePointer extensions(); public native AVInputFormat extensions(BytePointer setter);

    @MemberGetter public native @Const AVCodecTag codec_tag(int i);
    @MemberGetter public native @Cast("const AVCodecTag*const*") PointerPointer codec_tag();

    /** AVClass for the private context */
    public native @Const AVClass priv_class(); public native AVInputFormat priv_class(AVClass setter);

    /**
     * Comma-separated list of mime types.
     * It is used check for matching mime types while probing.
     * @see av_probe_input_format2
     */
    public native @Cast("const char*") BytePointer mime_type(); public native AVInputFormat mime_type(BytePointer setter);

    /*****************************************************************
     * No fields below this line are part of the public API. They
     * may not be used outside of libavformat and can be changed and
     * removed at will.
     * New public fields should be added right above.
     *****************************************************************
     */
    public native AVInputFormat next(); public native AVInputFormat next(AVInputFormat setter);

    /**
     * Raw demuxers store their codec ID here.
     */
    public native int raw_codec_id(); public native AVInputFormat raw_codec_id(int setter);

    /**
     * Size of private data so that it can be allocated in the wrapper.
     */
    public native int priv_data_size(); public native AVInputFormat priv_data_size(int setter);

    /**
     * Tell if a given file has a chance of being parsed as this format.
     * The buffer provided is guaranteed to be AVPROBE_PADDING_SIZE bytes
     * big so you do not have to check for that unless you need more.
     */
    public static class Read_probe_AVProbeData extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_probe_AVProbeData(Pointer p) { super(p); }
        protected Read_probe_AVProbeData() { allocate(); }
        private native void allocate();
        public native int call(@Const AVProbeData arg0);
    }
    public native Read_probe_AVProbeData read_probe(); public native AVInputFormat read_probe(Read_probe_AVProbeData setter);

    /**
     * Read the format header and initialize the AVFormatContext
     * structure. Return 0 if OK. 'avformat_new_stream' should be
     * called to create new streams.
     */
    public static class Read_header_AVFormatContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_header_AVFormatContext(Pointer p) { super(p); }
        protected Read_header_AVFormatContext() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext arg0);
    }
    public native Read_header_AVFormatContext read_header(); public native AVInputFormat read_header(Read_header_AVFormatContext setter);

    /**
     * Read one packet and put it in 'pkt'. pts and flags are also
     * set. 'avformat_new_stream' can be called only if the flag
     * AVFMTCTX_NOHEADER is used and only in the calling thread (not in a
     * background thread).
     * @return 0 on success, < 0 on error.
     *         Upon returning an error, pkt must be unreferenced by the caller.
     */
    public static class Read_packet_AVFormatContext_AVPacket extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_packet_AVFormatContext_AVPacket(Pointer p) { super(p); }
        protected Read_packet_AVFormatContext_AVPacket() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext arg0, AVPacket pkt);
    }
    public native Read_packet_AVFormatContext_AVPacket read_packet(); public native AVInputFormat read_packet(Read_packet_AVFormatContext_AVPacket setter);

    /**
     * Close the stream. The AVFormatContext and AVStreams are not
     * freed by this function
     */
    public static class Read_close_AVFormatContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_close_AVFormatContext(Pointer p) { super(p); }
        protected Read_close_AVFormatContext() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext arg0);
    }
    public native Read_close_AVFormatContext read_close(); public native AVInputFormat read_close(Read_close_AVFormatContext setter);

    /**
     * Seek to a given timestamp relative to the frames in
     * stream component stream_index.
     * @param stream_index Must not be -1.
     * @param flags Selects which direction should be preferred if no exact
     *              match is available.
     * @return >= 0 on success (but not necessarily the new offset)
     */
    public static class Read_seek_AVFormatContext_int_long_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_seek_AVFormatContext_int_long_int(Pointer p) { super(p); }
        protected Read_seek_AVFormatContext_int_long_int() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext arg0,
                         int stream_index, @Cast("int64_t") long timestamp, int flags);
    }
    public native Read_seek_AVFormatContext_int_long_int read_seek(); public native AVInputFormat read_seek(Read_seek_AVFormatContext_int_long_int setter);

    /**
     * Get the next timestamp in stream[stream_index].time_base units.
     * @return the timestamp or AV_NOPTS_VALUE if an error occurred
     */
    public static class Read_timestamp_AVFormatContext_int_LongPointer_long extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_timestamp_AVFormatContext_int_LongPointer_long(Pointer p) { super(p); }
        protected Read_timestamp_AVFormatContext_int_LongPointer_long() { allocate(); }
        private native void allocate();
        public native @Cast("int64_t") long call(AVFormatContext s, int stream_index,
                                  @Cast("int64_t*") LongPointer pos, @Cast("int64_t") long pos_limit);
    }
    public native Read_timestamp_AVFormatContext_int_LongPointer_long read_timestamp(); public native AVInputFormat read_timestamp(Read_timestamp_AVFormatContext_int_LongPointer_long setter);

    /**
     * Start/resume playing - only meaningful if using a network-based format
     * (RTSP).
     */
    public static class Read_play_AVFormatContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_play_AVFormatContext(Pointer p) { super(p); }
        protected Read_play_AVFormatContext() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext arg0);
    }
    public native Read_play_AVFormatContext read_play(); public native AVInputFormat read_play(Read_play_AVFormatContext setter);

    /**
     * Pause playing - only meaningful if using a network-based format
     * (RTSP).
     */
    public static class Read_pause_AVFormatContext extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_pause_AVFormatContext(Pointer p) { super(p); }
        protected Read_pause_AVFormatContext() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext arg0);
    }
    public native Read_pause_AVFormatContext read_pause(); public native AVInputFormat read_pause(Read_pause_AVFormatContext setter);

    /**
     * Seek to timestamp ts.
     * Seeking will be done so that the point from which all active streams
     * can be presented successfully will be closest to ts and within min/max_ts.
     * Active streams are all streams that have AVStream.discard < AVDISCARD_ALL.
     */
    public static class Read_seek2_AVFormatContext_int_long_long_long_int extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Read_seek2_AVFormatContext_int_long_long_long_int(Pointer p) { super(p); }
        protected Read_seek2_AVFormatContext_int_long_long_long_int() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext s, int stream_index, @Cast("int64_t") long min_ts, @Cast("int64_t") long ts, @Cast("int64_t") long max_ts, int flags);
    }
    public native Read_seek2_AVFormatContext_int_long_long_long_int read_seek2(); public native AVInputFormat read_seek2(Read_seek2_AVFormatContext_int_long_long_long_int setter);

    /**
     * Returns device list with it properties.
     * @see avdevice_list_devices() for more details.
     */
    public static class Get_device_list_AVFormatContext_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Get_device_list_AVFormatContext_Pointer(Pointer p) { super(p); }
        protected Get_device_list_AVFormatContext_Pointer() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext s, @Cast("AVDeviceInfoList*") Pointer device_list);
    }
    public native Get_device_list_AVFormatContext_Pointer get_device_list(); public native AVInputFormat get_device_list(Get_device_list_AVFormatContext_Pointer setter);

    /**
     * Initialize device capabilities submodule.
     * @see avdevice_capabilities_create() for more details.
     */
    public static class Create_device_capabilities_AVFormatContext_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Create_device_capabilities_AVFormatContext_Pointer(Pointer p) { super(p); }
        protected Create_device_capabilities_AVFormatContext_Pointer() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext s, @Cast("AVDeviceCapabilitiesQuery*") Pointer caps);
    }
    public native Create_device_capabilities_AVFormatContext_Pointer create_device_capabilities(); public native AVInputFormat create_device_capabilities(Create_device_capabilities_AVFormatContext_Pointer setter);

    /**
     * Free device capabilities submodule.
     * @see avdevice_capabilities_free() for more details.
     */
    public static class Free_device_capabilities_AVFormatContext_Pointer extends FunctionPointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public    Free_device_capabilities_AVFormatContext_Pointer(Pointer p) { super(p); }
        protected Free_device_capabilities_AVFormatContext_Pointer() { allocate(); }
        private native void allocate();
        public native int call(AVFormatContext s, @Cast("AVDeviceCapabilitiesQuery*") Pointer caps);
    }
    public native Free_device_capabilities_AVFormatContext_Pointer free_device_capabilities(); public native AVInputFormat free_device_capabilities(Free_device_capabilities_AVFormatContext_Pointer setter);
}
