/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.ffmpeg.avformat;

import org.bytedeco.ffmpeg.avcodec.AVCodecContext;
import org.bytedeco.ffmpeg.avcodec.AVCodecParameters;
import org.bytedeco.ffmpeg.avcodec.AVCodecParserContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.avcodec.AVPacketSideData;
import org.bytedeco.ffmpeg.avformat.AVIndexEntry;
import org.bytedeco.ffmpeg.avformat.AVPacketList;
import org.bytedeco.ffmpeg.avformat.AVProbeData;
import org.bytedeco.ffmpeg.avformat.AVStreamInternal;
import org.bytedeco.ffmpeg.avutil.AVDictionary;
import org.bytedeco.ffmpeg.avutil.AVRational;
import org.bytedeco.ffmpeg.presets.avformat;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Properties;

@Properties(inherit={avformat.class})
public class AVStream
extends Pointer {
    public static final int AVSTREAM_EVENT_FLAG_METADATA_UPDATED = 1;
    public static final int MAX_STD_TIMEBASES = 399;
    public static final int MAX_REORDER_DELAY = 16;

    public AVStream() {
        super((Pointer)null);
        this.allocate();
    }

    public AVStream(long size) {
        super((Pointer)null);
        this.allocateArray(size);
    }

    public AVStream(Pointer p) {
        super(p);
    }

    private native void allocate();

    private native void allocateArray(long var1);

    public AVStream position(long position) {
        return (AVStream)super.position(position);
    }

    public AVStream getPointer(long i) {
        return new AVStream(this).position(this.position + i);
    }

    public native int index();

    public native AVStream index(int var1);

    public native int id();

    public native AVStream id(int var1);

    @Deprecated
    public native AVCodecContext codec();

    public native AVStream codec(AVCodecContext var1);

    public native Pointer priv_data();

    public native AVStream priv_data(Pointer var1);

    @ByRef
    public native AVRational time_base();

    public native AVStream time_base(AVRational var1);

    @Cast(value={"int64_t"})
    public native long start_time();

    public native AVStream start_time(long var1);

    @Cast(value={"int64_t"})
    public native long duration();

    public native AVStream duration(long var1);

    @Cast(value={"int64_t"})
    public native long nb_frames();

    public native AVStream nb_frames(long var1);

    public native int disposition();

    public native AVStream disposition(int var1);

    @Cast(value={"AVDiscard"})
    public native int discard();

    public native AVStream discard(int var1);

    @ByRef
    public native AVRational sample_aspect_ratio();

    public native AVStream sample_aspect_ratio(AVRational var1);

    public native AVDictionary metadata();

    public native AVStream metadata(AVDictionary var1);

    @ByRef
    public native AVRational avg_frame_rate();

    public native AVStream avg_frame_rate(AVRational var1);

    @ByRef
    public native AVPacket attached_pic();

    public native AVStream attached_pic(AVPacket var1);

    public native AVPacketSideData side_data();

    public native AVStream side_data(AVPacketSideData var1);

    public native int nb_side_data();

    public native AVStream nb_side_data(int var1);

    public native int event_flags();

    public native AVStream event_flags(int var1);

    @ByRef
    public native AVRational r_frame_rate();

    public native AVStream r_frame_rate(AVRational var1);

    @Cast(value={"char*"})
    @Deprecated
    public native BytePointer recommended_encoder_configuration();

    public native AVStream recommended_encoder_configuration(BytePointer var1);

    public native AVCodecParameters codecpar();

    public native AVStream codecpar(AVCodecParameters var1);

    @Name(value={"info", ".last_dts"})
    @Cast(value={"int64_t"})
    public native long info_last_dts(int var1);

    public native AVStream info_last_dts(int var1, long var2);

    @Name(value={"info", ".duration_gcd"})
    @Cast(value={"int64_t"})
    public native long info_duration_gcd(int var1);

    public native AVStream info_duration_gcd(int var1, long var2);

    @Name(value={"info", ".duration_count"})
    public native int info_duration_count(int var1);

    public native AVStream info_duration_count(int var1, int var2);

    @Name(value={"info", ".rfps_duration_sum"})
    @Cast(value={"int64_t"})
    public native long info_rfps_duration_sum(int var1);

    public native AVStream info_rfps_duration_sum(int var1, long var2);

    @Name(value={"info", ".duration_error"})
    @MemberGetter
    @Cast(value={"double*"})
    public native DoublePointer info_duration_error(int var1);

    @Name(value={"info", ".codec_info_duration"})
    @Cast(value={"int64_t"})
    public native long info_codec_info_duration(int var1);

    public native AVStream info_codec_info_duration(int var1, long var2);

    @Name(value={"info", ".codec_info_duration_fields"})
    @Cast(value={"int64_t"})
    public native long info_codec_info_duration_fields(int var1);

    public native AVStream info_codec_info_duration_fields(int var1, long var2);

    @Name(value={"info", ".frame_delay_evidence"})
    public native int info_frame_delay_evidence(int var1);

    public native AVStream info_frame_delay_evidence(int var1, int var2);

    @Name(value={"info", ".found_decoder"})
    public native int info_found_decoder(int var1);

    public native AVStream info_found_decoder(int var1, int var2);

    @Name(value={"info", ".last_duration"})
    @Cast(value={"int64_t"})
    public native long info_last_duration(int var1);

    public native AVStream info_last_duration(int var1, long var2);

    @Name(value={"info", ".fps_first_dts"})
    @Cast(value={"int64_t"})
    public native long info_fps_first_dts(int var1);

    public native AVStream info_fps_first_dts(int var1, long var2);

    @Name(value={"info", ".fps_first_dts_idx"})
    public native int info_fps_first_dts_idx(int var1);

    public native AVStream info_fps_first_dts_idx(int var1, int var2);

    @Name(value={"info", ".fps_last_dts"})
    @Cast(value={"int64_t"})
    public native long info_fps_last_dts(int var1);

    public native AVStream info_fps_last_dts(int var1, long var2);

    @Name(value={"info", ".fps_last_dts_idx"})
    public native int info_fps_last_dts_idx(int var1);

    public native AVStream info_fps_last_dts_idx(int var1, int var2);

    public native int pts_wrap_bits();

    public native AVStream pts_wrap_bits(int var1);

    @Cast(value={"int64_t"})
    public native long first_dts();

    public native AVStream first_dts(long var1);

    @Cast(value={"int64_t"})
    public native long cur_dts();

    public native AVStream cur_dts(long var1);

    @Cast(value={"int64_t"})
    public native long last_IP_pts();

    public native AVStream last_IP_pts(long var1);

    public native int last_IP_duration();

    public native AVStream last_IP_duration(int var1);

    public native int probe_packets();

    public native AVStream probe_packets(int var1);

    public native int codec_info_nb_frames();

    public native AVStream codec_info_nb_frames(int var1);

    @Cast(value={"AVStreamParseType"})
    public native int need_parsing();

    public native AVStream need_parsing(int var1);

    public native AVCodecParserContext parser();

    public native AVStream parser(AVCodecParserContext var1);

    public native AVPacketList last_in_packet_buffer();

    public native AVStream last_in_packet_buffer(AVPacketList var1);

    @ByRef
    public native AVProbeData probe_data();

    public native AVStream probe_data(AVProbeData var1);

    @Cast(value={"int64_t"})
    public native long pts_buffer(int var1);

    public native AVStream pts_buffer(int var1, long var2);

    @MemberGetter
    @Cast(value={"int64_t*"})
    public native LongPointer pts_buffer();

    public native AVIndexEntry index_entries();

    public native AVStream index_entries(AVIndexEntry var1);

    public native int nb_index_entries();

    public native AVStream nb_index_entries(int var1);

    @Cast(value={"unsigned int"})
    public native int index_entries_allocated_size();

    public native AVStream index_entries_allocated_size(int var1);

    public native int stream_identifier();

    public native AVStream stream_identifier(int var1);

    public native int program_num();

    public native AVStream program_num(int var1);

    public native int pmt_version();

    public native AVStream pmt_version(int var1);

    public native int pmt_stream_idx();

    public native AVStream pmt_stream_idx(int var1);

    @Cast(value={"int64_t"})
    public native long interleaver_chunk_size();

    public native AVStream interleaver_chunk_size(long var1);

    @Cast(value={"int64_t"})
    public native long interleaver_chunk_duration();

    public native AVStream interleaver_chunk_duration(long var1);

    public native int request_probe();

    public native AVStream request_probe(int var1);

    public native int skip_to_keyframe();

    public native AVStream skip_to_keyframe(int var1);

    public native int skip_samples();

    public native AVStream skip_samples(int var1);

    @Cast(value={"int64_t"})
    public native long start_skip_samples();

    public native AVStream start_skip_samples(long var1);

    @Cast(value={"int64_t"})
    public native long first_discard_sample();

    public native AVStream first_discard_sample(long var1);

    @Cast(value={"int64_t"})
    public native long last_discard_sample();

    public native AVStream last_discard_sample(long var1);

    public native int nb_decoded_frames();

    public native AVStream nb_decoded_frames(int var1);

    @Cast(value={"int64_t"})
    public native long mux_ts_offset();

    public native AVStream mux_ts_offset(long var1);

    @Cast(value={"int64_t"})
    public native long pts_wrap_reference();

    public native AVStream pts_wrap_reference(long var1);

    public native int pts_wrap_behavior();

    public native AVStream pts_wrap_behavior(int var1);

    public native int update_initial_durations_done();

    public native AVStream update_initial_durations_done(int var1);

    @Cast(value={"int64_t"})
    public native long pts_reorder_error(int var1);

    public native AVStream pts_reorder_error(int var1, long var2);

    @MemberGetter
    @Cast(value={"int64_t*"})
    public native LongPointer pts_reorder_error();

    @Cast(value={"uint8_t"})
    public native byte pts_reorder_error_count(int var1);

    public native AVStream pts_reorder_error_count(int var1, byte var2);

    @MemberGetter
    @Cast(value={"uint8_t*"})
    public native BytePointer pts_reorder_error_count();

    @Cast(value={"int64_t"})
    public native long last_dts_for_order_check();

    public native AVStream last_dts_for_order_check(long var1);

    @Cast(value={"uint8_t"})
    public native byte dts_ordered();

    public native AVStream dts_ordered(byte var1);

    @Cast(value={"uint8_t"})
    public native byte dts_misordered();

    public native AVStream dts_misordered(byte var1);

    public native int inject_global_side_data();

    public native AVStream inject_global_side_data(int var1);

    @ByRef
    public native AVRational display_aspect_ratio();

    public native AVStream display_aspect_ratio(AVRational var1);

    public native AVStreamInternal internal();

    public native AVStream internal(AVStreamInternal var1);

    static {
        Loader.load();
    }
}

