/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text;

import java.io.IOException;
import java.util.HashMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.html.text.HtmlNumber;
import org.butterfaces.component.partrenderer.RenderUtils;
import org.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.NumberRenderer")
public class NumberRenderer
extends AbstractHtmlTagRenderer<HtmlNumber> {
    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component, "butter-component-number");
    }

    @Override
    protected void encodeEnd(HtmlNumber numberComponent, ResponseWriter writer) throws IOException {
        if (!numberComponent.isReadonly()) {
            HashMap<String, String> options = new HashMap<String, String>();
            if (StringUtils.isNotEmpty(numberComponent.getMin())) {
                options.put("min", numberComponent.getMin());
            }
            if (StringUtils.isNotEmpty(numberComponent.getMax())) {
                options.put("max", numberComponent.getMax());
            }
            if (StringUtils.isNotEmpty(numberComponent.getStep())) {
                options.put("step", numberComponent.getStep());
            }
            if (numberComponent.isDisabled()) {
                options.put("disabled", numberComponent.isDisabled() + "");
            }
            RenderUtils.renderJQueryPluginCall(numberComponent.getClientId(), "butterNumberSpinner(" + RenderUtils.createOptionsStringForJQueryPluginCall(options) + ")", writer, (UIComponent)numberComponent);
        }
    }
}

