/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text;

import java.io.IOException;
import java.util.Optional;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.html.text.HtmlCalendar;
import org.butterfaces.component.partrenderer.InnerComponentWrapperPartRenderer;
import org.butterfaces.component.partrenderer.OuterComponentWrapperPartRenderer;
import org.butterfaces.component.partrenderer.RenderUtils;
import org.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.CalendarRenderer")
public class CalendarRenderer
extends AbstractHtmlTagRenderer<HtmlCalendar> {
    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlCalendar calendar = (HtmlCalendar)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!calendar.isReadonly()) {
            super.encodeSuperEnd(context, component);
            if (calendar.isPickDate() || calendar.isPickTime()) {
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)"input-group-append cursor-pointer", null);
                writer.writeAttribute("data-toggle", (Object)"datetimepicker", null);
                writer.startElement("span", component);
                if (!calendar.isPickDate()) {
                    writer.writeAttribute("class", (Object)"input-group-text glyphicon glyphicon-time", null);
                } else {
                    writer.writeAttribute("class", (Object)"input-group-text glyphicon glyphicon-calendar", null);
                }
                writer.endElement("span");
                writer.endElement("div");
            }
        }
        new InnerComponentWrapperPartRenderer().renderInnerWrapperEnd((UIComponent)calendar, writer);
        this.renderTooltipIfNecessary(context, (UIComponent)calendar);
        if (!calendar.isReadonly() && (calendar.isPickDate() || calendar.isPickTime())) {
            writer.startElement("script", (UIComponent)calendar);
            writer.writeText((Object)RenderUtils.createJQueryPluginCall(component.getClientId(), null, this.createJQueryPluginCall(calendar), "var elementId = ButterFaces.Guid.newGuid();\n"), null);
            Optional<String> ajaxChangeEventFix = this.createAjaxChangeEventFix(calendar);
            if (ajaxChangeEventFix.isPresent()) {
                writer.writeText((Object)ajaxChangeEventFix.get(), null);
            }
            writer.endElement("script");
        }
        new OuterComponentWrapperPartRenderer().renderComponentEnd(writer);
    }

    private Optional<String> createAjaxChangeEventFix(HtmlCalendar calendar) {
        Optional<String> ajaxEventFunction = this.createAjaxEventFunction((UIComponentBase)calendar, "change");
        if (ajaxEventFunction.isPresent()) {
            String jqueryAjaxCall = RenderUtils.createJQueryBySelector(calendar.getClientId() + ":inner", null) + ".parent().on('change.datetimepicker', function(e) {\nif (typeof e.oldDate !== 'undefined') {\n" + ajaxEventFunction.get() + ";\n}\n});";
            return Optional.of(jqueryAjaxCall);
        }
        return Optional.empty();
    }

    String createJQueryPluginCall(HtmlCalendar calendar) {
        StringBuilder jQueryPluginCall = new StringBuilder();
        jQueryPluginCall.append("find('.input-group')");
        jQueryPluginCall.append(".attr('id', elementId)");
        jQueryPluginCall.append(".attr('data-target-input', 'nearest')");
        jQueryPluginCall.append(".find('input')");
        jQueryPluginCall.append(".attr('data-target', '#' + elementId)");
        jQueryPluginCall.append(".addClass('datetimepicker-input')");
        jQueryPluginCall.append(".siblings('.input-group-append')");
        jQueryPluginCall.append(".attr('data-target', '#' + elementId)");
        jQueryPluginCall.append(".parent()");
        jQueryPluginCall.append(".datetimepicker({");
        if (StringUtils.isNotEmpty(calendar.getFormat())) {
            jQueryPluginCall.append("format: '").append(calendar.getFormat()).append("',");
        } else if (calendar.isPickDate() && !calendar.isPickTime()) {
            jQueryPluginCall.append("format: 'L',");
        } else if (!calendar.isPickDate() && calendar.isPickTime()) {
            jQueryPluginCall.append("format: 'LT',");
        }
        if (StringUtils.isNotEmpty(calendar.getLocale())) {
            jQueryPluginCall.append("locale: '" + calendar.getLocale() + "',");
        }
        if (calendar.getViewMode() != null) {
            jQueryPluginCall.append("viewMode: '" + calendar.getViewMode().getValue() + "',");
        }
        if (calendar.isSideBySide()) {
            jQueryPluginCall.append("sideBySide: true,");
        }
        String calendarDate = StringUtils.getNotNullValue(calendar.getIconDate(), "glyphicon glyphicon-calendar");
        String calendarTime = StringUtils.getNotNullValue(calendar.getIconTime(), "glyphicon glyphicon-time");
        String calendarUp = StringUtils.getNotNullValue(calendar.getIconUp(), "glyphicon glyphicon-chevron-up");
        String calendarDown = StringUtils.getNotNullValue(calendar.getIconDown(), "glyphicon glyphicon-chevron-down");
        jQueryPluginCall.append("icons: {");
        jQueryPluginCall.append("time: '" + calendarTime + "',");
        jQueryPluginCall.append("date: '" + calendarDate + "',");
        jQueryPluginCall.append("up: '" + calendarUp + "',");
        jQueryPluginCall.append("down: '" + calendarDown + "'");
        jQueryPluginCall.append("}");
        jQueryPluginCall.append("})");
        return jQueryPluginCall.toString();
    }
}

