///<reference path="../type-definition/jsf-ajax/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Ajax = /** @class */ (function () {
        function Ajax() {
        }
        Ajax.sendRequest = function (clientId, event, renderIds, /*optional string */ params, disableRenderIds) {
            jsf.ajax.request(clientId, event, {
                "javax.faces.behavior.event": event,
                render: renderIds.join(", "),
                params: params,
                "butterfaces.params": params,
                onevent: (function (data) {
                    // console.log(data);
                    if (disableRenderIds) {
                        ButterFaces.Ajax.disableElementsOnRequest(data, renderIds);
                    }
                })
            });
        };
        Ajax.disableElementsOnRequest = function (data, ids) {
            var status = data.status;
            // console.log(data);
            // console.log(ids);
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToDisable = $(document.getElementById(ids[i]));
                        if ($elementToDisable.length !== 0) {
                            // console.log('disable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).show();
                            // console.log('disablee ' + ids[i]);
                        }
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    for (var i = 0; i < ids.length; i++) {
                        var $elementToEmable = $(document.getElementById(ids[i]));
                        if ($elementToEmable.length !== 0) {
                            // console.log('enable ' + ids[i]);
                            new ButterFaces.Overlay(0, false, document.getElementById(ids[i])).hide();
                            // console.log('enabled ' + ids[i]);
                        }
                    }
                    break;
            }
        };
        return Ajax;
    }());
    ButterFaces.Ajax = Ajax;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * jQuery-Plugin "Expanded TextAreas" for expandable text areas. It is used for the JSF-Component "b:textarea".
 * Works with at least jQuery 1.7.
 *
 * How to use:
 * jQuery("#someTextAreaSelector").butterExpandable();
 */
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterExpandable"] = function () {
        return this.each(function (index, element) {
            var rootElement = $(element);
            if (rootElement.find("textarea").length > 0) {
                new ButterFaces.TextareaExpandable(rootElement);
            }
            else {
                new ButterFaces.DivExpandable(rootElement);
            }
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var EXPAND_HEIGHT = 250; //in px
    var EXPAND_WIDTH = 500; //in px
    var ANIMATION_DURATION = 200; //in ms
    var REPOSITION_INTERVAL = 500; //in ms
    var EASING = "swing";
    var KEYCODE_ESCAPE = 27;
    var AbstractExpandable = /** @class */ (function () {
        function AbstractExpandable(rootElement) {
            this.rootElement = rootElement;
        }
        AbstractExpandable.prototype.expandElement = function (event) {
            var _this = this;
            if (this.isExpansionEventIgnored(event)) {
                return;
            }
            this.initialHeight = this.originalElement.outerHeight();
            this.initialWidth = this.originalElement.outerWidth();
            this.initialOffset = this.originalElement.offset();
            //create a ghost element that be animated on gets the focus
            this.ghostElement = this.createGhostElement();
            this.transferValueToGhostElement();
            this.ghostElement.css("width", this.initialWidth)
                .css("height", this.initialHeight)
                .css("position", "absolute")
                .css("top", this.initialOffset.top)
                .css("left", this.initialOffset.left)
                .css("z-index", 2000)
                .css("box-shadow", "5px 5px 5px 0 #999")
                .addClass("butter-component-expandable-ghost")
                .appendTo($("body"))
                .animate({
                height: EXPAND_HEIGHT,
                width: this.initialWidth > EXPAND_WIDTH ? this.initialWidth : EXPAND_WIDTH
            }, ANIMATION_DURATION, EASING, function () {
                $(document)
                    .on("click.expandable", function (event) {
                    _this.handleMouseClick(event);
                })
                    .on("keydown.expandable", function (event) {
                    _this.handleEscapeKey(event);
                });
                $(window).on("resize.expandable", function () {
                    _this.repositionGhostElement();
                });
                //keep track of the orginal element"s position
                _this.positionTriggerInterval = window.setInterval(function () { return _this.repositionGhostElement; }, REPOSITION_INTERVAL);
            });
            //make original invisible
            this.originalElement
                .css("visibility", "hidden")
                .siblings()
                .css("visibility", "hidden");
            this.onGhostElementCreated();
        };
        /**
         * Collapses the ghost element and sets the value if not isCancelled
         * @param isCancelled
         */
        AbstractExpandable.prototype.collapseElement = function (cancelled) {
            // "cancelled" can be an event object
            var isCancelled = typeof cancelled === "boolean" && cancelled;
            $(document)
                .off("click.expandable")
                .off("keydown.expandable");
            //make original visible again
            this.originalElement
                .css("visibility", "visible")
                .siblings()
                .css("visibility", "visible");
            var self = this;
            this.ghostElement.animate({
                height: self.initialHeight,
                width: self.initialWidth
            }, ANIMATION_DURATION, EASING, function () {
                //on animation complete
                self.onGhostElementCollapsed(isCancelled);
                //delete the ghost element
                self.ghostElement.remove();
                self.ghostElement = null;
                //delete position trigger timeout and resize listener
                window.clearInterval(self.positionTriggerInterval);
                $(window).off("resize.expandable");
            });
        };
        AbstractExpandable.prototype.handleMouseClick = function (event) {
            // collapse ghost element if user clicks beside it
            if (!$(event.target).is(".butter-component-expandable-ghost")) {
                this.collapseElement(false);
            }
        };
        AbstractExpandable.prototype.handleEscapeKey = function (event) {
            if (event.which === KEYCODE_ESCAPE) {
                this.collapseElement(true);
            }
        };
        AbstractExpandable.prototype.repositionGhostElement = function () {
            //keep track of window resizing and reposition the ghost element
            if (this.ghostElement !== undefined && this.ghostElement != null) {
                this.initialOffset = this.originalElement.offset();
                this.ghostElement
                    .css("top", this.initialOffset.top)
                    .css("left", this.initialOffset.left);
            }
        };
        return AbstractExpandable;
    }());
    var DivExpandable = /** @class */ (function (_super) {
        __extends(DivExpandable, _super);
        function DivExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.originalElement = _this.rootElement.find(".butter-component-value-readonly");
            _this.rearrangeOriginalElementStructure();
            return _this;
        }
        DivExpandable.prototype.rearrangeOriginalElementStructure = function () {
            var _this = this;
            var _label = this.rootElement.find(".butter-component-label");
            this.originalElement
                .addClass("butter-component-expandable-original")
                .click(function (event) {
                _this.expandElement(event);
            })
                .detach();
            var _container = $("<div>")
                .addClass("butter-component-expandable-readonly-container")
                .insertAfter(_label);
            var _icon = $("<span>").addClass("input-group-text glyphicon glyphicon-resize-full");
            this.originalElement.appendTo(_container);
            $("<div>")
                .addClass("butter-component-expandable-readonly-icon")
                .append(_icon)
                .appendTo(_container);
        };
        DivExpandable.prototype.createGhostElement = function () {
            return $("<div>");
        };
        DivExpandable.prototype.isExpansionEventIgnored = function (event) {
            return false;
        };
        DivExpandable.prototype.onGhostElementCreated = function () {
            // do nothing
        };
        DivExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            // do nothing
        };
        DivExpandable.prototype.transferValueToGhostElement = function () {
            $("<div>")
                .html(this.originalElement.html())
                .addClass("butter-component-expandable-ghost-readonlyContent")
                .appendTo(this.ghostElement);
        };
        return DivExpandable;
    }(AbstractExpandable));
    ButterFaces.DivExpandable = DivExpandable;
    var TextareaExpandable = /** @class */ (function (_super) {
        __extends(TextareaExpandable, _super);
        function TextareaExpandable(rootElement) {
            var _this = _super.call(this, rootElement) || this;
            _this.blockFocusEventOnOriginal = false;
            _this.blockBlurEventOnOriginal = false;
            _this.originalElement = _this.rootElement.find("textarea");
            _this.originalElement.addClass("butter-component-expandable-original");
            _this.originalElement.focus(function (event) {
                _this.expandElement(event);
            });
            _this.originalElement.blur(function (event) {
                _this.handleBlurEvent(event);
            });
            _this.addInputGroupAddon();
            return _this;
        }
        TextareaExpandable.prototype.addInputGroupAddon = function () {
            this.originalElement
                .addClass("form-control")
                .parent()
                .addClass("input-group");
            $("<span class=\"input-group-append\"><span class=\"input-group-text glyphicon glyphicon-resize-full\"></span></span>")
                .insertAfter(this.originalElement);
        };
        TextareaExpandable.prototype.handleBlurEvent = function (event) {
            if (this.blockBlurEventOnOriginal) {
                // prevent blur event bubbling, so it will not be triggered in jsf
                event.preventDefault();
            }
        };
        TextareaExpandable.prototype.createGhostElement = function () {
            return $("<textarea>");
        };
        TextareaExpandable.prototype.isExpansionEventIgnored = function (event) {
            this.blockBlurEventOnOriginal = true;
            if (this.blockFocusEventOnOriginal) {
                event.preventDefault();
                return true;
            }
            else {
                return false;
            }
        };
        TextareaExpandable.prototype.onGhostElementCreated = function () {
            var _this = this;
            this.ghostElement
                .blur(function (event) {
                _this.collapseElement(event);
            })
                .focus();
            this.moveCaretToEnd(this.ghostElement);
        };
        TextareaExpandable.prototype.onGhostElementCollapsed = function (isCancelled) {
            var _this = this;
            if (!isCancelled) {
                //transfer value back from ghost to original
                this.originalElement.val(this.ghostElement.val());
                // trigger blur and keyup event on original textarea and don"t block
                // it for jsf
                this.blockBlurEventOnOriginal = false;
                this.blockFocusEventOnOriginal = true;
                // defer the events a little bit, look at
                // (http://stackoverflow.com/questions/8380759/why-isnt-this-textarea-focusing-with-focus#8380785)
                window.setTimeout(function () {
                    _this.originalElement.trigger("keyup");
                    _this.originalElement.trigger("change");
                    _this.originalElement.trigger("blur");
                    _this.blockFocusEventOnOriginal = false;
                }, 50);
            }
            else {
                this.blockBlurEventOnOriginal = true;
                this.blockFocusEventOnOriginal = false;
            }
        };
        TextareaExpandable.prototype.transferValueToGhostElement = function () {
            this.ghostElement.val(this.originalElement.val());
        };
        TextareaExpandable.prototype.moveCaretToEnd = function (element) {
            if (typeof element.selectionStart === "number") {
                element.selectionStart = element.selectionEnd = element.value.length;
            }
            else if (typeof element.createTextRange !== "undefined") {
                var range = element.createTextRange();
                range.collapse(false);
                range.select();
            }
            else {
                var strLength = this.ghostElement.val().length * 2;
                this.ghostElement.get(0).setSelectionRange(strLength, strLength);
            }
        };
        return TextareaExpandable;
    }(AbstractExpandable));
    ButterFaces.TextareaExpandable = TextareaExpandable;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var Guid = /** @class */ (function () {
        function Guid() {
        }
        Guid.newGuid = function () {
            var d = new Date().getTime();
            if (typeof performance !== "undefined" && typeof performance.now === "function") {
                d += performance.now(); //use high-precision timer if available
            }
            return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g, function (c) {
                var r = (d + Math.random() * 16) % 16 | 0;
                d = Math.floor(d / 16);
                return (c === "x" ? r : (r & 0x3 | 0x8)).toString(16);
            });
        };
        return Guid;
    }());
    ButterFaces.Guid = Guid;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var CommandLink = /** @class */ (function () {
        function CommandLink() {
        }
        CommandLink.disableOnClick = function (data, showDots, linkText, linkProcessingText, linkGlyphicon, linkProcessingGlyphicon, hideGlyphicon, disableRenderRegionsIds) {
            var status = data.type === "error" ? "error" : data.status;
            // console.log(data.source.id);
            var $commandLink = $(document.getElementById(data.source.id));
            switch (status) {
                case "begin": // Before the ajax request is sent.
                    // console.log('ajax request begin');
                    $commandLink.addClass("disabled");
                    var $glyphicon = $commandLink.find(".butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphicon.hide();
                    }
                    if (linkProcessingGlyphicon.length > 0) {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-glyphicon butter-component-processing-spinner");
                        $glyphicon.addClass(linkProcessingGlyphicon);
                        if (linkProcessingText.length > 0 && linkGlyphicon.length === 0) {
                            // glyphicon only appears on ajax request
                            $glyphicon.addClass("butter-component-glyphicon-width-margin");
                        }
                    }
                    else {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-spinner tiny butter-component-processing-spinner");
                    }
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").startDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "inline-block");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkProcessingText);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Disable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).show();
                    }
                    break;
                case "complete": // After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                case "error": // After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    $commandLink.removeClass("disabled");
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").stopDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "none");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkText ? linkText : "");
                    }
                    var $glyphiconError = $commandLink.find(".butter-component-processing-spinner");
                    $glyphiconError.removeAttr("class");
                    $glyphiconError.addClass("butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphiconError.show();
                    }
                    if (linkGlyphicon.length > 0) {
                        $glyphiconError.addClass(linkGlyphicon);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Enable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).hide();
                    }
                    break;
            }
        };
        /**
         * Submit given form.
         * @param formId the target form id to submit
         * @param params a list of params to be added to form as hidden input fields
         * @param target the target of the form submission
         */
        CommandLink.submitForm = function (formId, params, target) {
            var form = document.getElementById(formId);
            ButterFaces.CommandLink.addParametersAsHiddenFieldsToForm(form, params);
            var oldFormTarget = ButterFaces.CommandLink.setFormTarget(form, target);
            if (form.onsubmit) {
                var result = form.onsubmit();
                if (ButterFaces.ObjectStatics.isNullOrUndefined(result) || result) {
                    form.submit();
                }
            }
            else {
                form.submit();
            }
            form.target = oldFormTarget;
            ButterFaces.CommandLink.removeHiddenFieldsFromForm(form);
        };
        CommandLink.addParametersAsHiddenFieldsToForm = function (form, params) {
            var bfHiddenInputFields = [];
            form.bfHiddenInputFields = bfHiddenInputFields;
            var i = 0;
            for (var k in params) {
                if (params.hasOwnProperty(k)) {
                    var p = document.createElement("input");
                    p.type = "hidden";
                    p.name = k;
                    p.value = params[k];
                    form.appendChild(p);
                    bfHiddenInputFields[i++] = p;
                }
            }
        };
        CommandLink.removeHiddenFieldsFromForm = function (form) {
            var bfHiddenInputFields = form.bfHiddenInputFields;
            if (bfHiddenInputFields !== null) {
                for (var i = 0; i < bfHiddenInputFields.length; i++) {
                    form.removeChild(bfHiddenInputFields[i]);
                }
            }
        };
        /**
         * Updates form target (if exists) and returns previous form target
         * @param form the torm to add the new target to
         * @param target the target to add (if not null)
         * @return the previous form target
         */
        CommandLink.setFormTarget = function (form, target) {
            var previousTarget = form.target;
            if (target) {
                form.target = target;
            }
            return previousTarget;
        };
        return CommandLink;
    }());
    ButterFaces.CommandLink = CommandLink;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-string.ts"/>
///<reference path="butterfaces-util-object.ts"/>
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterMaxLength"] = function (options) {
        return this.each(function (index, element) {
            new ButterFaces.MaxLengthIndicator($(element), options);
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var ERROR_STYLE_CLASS = "has-error";
    var INVALID_STYLE_CLASS = "is-invalid";
    var MaxLengthIndicator = /** @class */ (function () {
        function MaxLengthIndicator(rootElement, options) {
            this.rootElement = rootElement;
            this.options = options;
            this.valueElement = this.rootElement.find("textarea");
            this.maxLengthElement = $("<div>").addClass("butter-component-maxlength-counter");
            this.maxLengthElement.insertAfter(this.valueElement);
            this.initializeComponent();
        }
        MaxLengthIndicator.prototype.initializeComponent = function () {
            void 0;
            this.hasInitialValidationError = this.rootElement.hasClass(ERROR_STYLE_CLASS);
            void 0;
            var that = this;
            this.valueElement.on("focus blur keyup cut paste", function () {
                that.checkValue();
            });
            // initial check
            this.checkValue();
        };
        MaxLengthIndicator.prototype.checkValue = function () {
            var value = this.valueElement.val();
            if (!ButterFaces.ObjectStatics.isNullOrUndefined(value)) {
                void 0;
                var freeLetterCount = this.options.maxLength - value.length;
                var formatted = ButterFaces.String.format(this.options.maxLengthText, [freeLetterCount, this.options.maxLength]);
                this.maxLengthElement.text(formatted);
                if (!this.hasInitialValidationError) {
                    if (freeLetterCount < 0) {
                        this.rootElement.addClass(ERROR_STYLE_CLASS);
                        this.valueElement.addClass(INVALID_STYLE_CLASS);
                    }
                    else {
                        this.rootElement.removeClass(ERROR_STYLE_CLASS);
                        this.valueElement.removeClass(INVALID_STYLE_CLASS);
                    }
                }
            }
        };
        return MaxLengthIndicator;
    }());
    ButterFaces.MaxLengthIndicator = MaxLengthIndicator;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    $.fn.multilinePlaceholder = function () {
        return this.each(function () {
            var $originalElement = $(this);
            var $textarea = $originalElement.find("textarea");
            var placeholder = $textarea.attr("placeholder");
            var multilinePlaceholder = placeholder.replace(/\\n/g, "\n");
            $textarea.attr("placeholder", multilinePlaceholder);
        });
    };
}(jQuery));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-guid.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Overlay = /** @class */ (function () {
        function Overlay(delay, isTransparentBlockingOverlayActive, selector) {
            if (delay === void 0) { delay = 500; }
            if (isTransparentBlockingOverlayActive === void 0) { isTransparentBlockingOverlayActive = true; }
            if (selector === void 0) { selector = "body"; }
            this.isHiding = true;
            this.delay = delay;
            this.isTransparentBlockingOverlayActive = isTransparentBlockingOverlayActive;
            this.selector = selector;
            void 0;
        }
        Overlay.prototype.show = function () {
            var _this = this;
            var $elementsToDisable = $(this.selector);
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                _this.isHiding = false;
                if (!ButterFaces.ObjectStatics.isNullOrUndefined($elementToDisable.attr("data-overlay-uuid"))) {
                    if (ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid")).length > 0) {
                        void 0;
                        return;
                    }
                    else {
                        $elementToDisable.removeAttr("data-overlay-uuid");
                    }
                }
                void 0;
                var uuid = ButterFaces.Guid.newGuid();
                var $overlay = $("<div class='butter-component-overlay' data-overlay-uuid='" + uuid + "'><div class='" + _this.calcOverlaySpinnerClass($elementToDisable) + "'></div></div>");
                $elementToDisable.attr("data-overlay-uuid", uuid);
                if (_this.selector === "body") {
                    $overlay.addClass("overlay-body");
                }
                else {
                    // TODO if blockpage is true set it to max size
                    $overlay.offset($elementToDisable.offset())
                        .width($elementToDisable.outerWidth())
                        .height($elementToDisable.outerHeight())
                        .addClass("overlay-body-child")
                        .css({ "position": "absolute" }); // IE overrides css position so set it here
                }
                $("body").append($overlay);
                if (_this.isTransparentBlockingOverlayActive) {
                    void 0;
                    $overlay.show();
                }
                window.setTimeout(function () {
                    if (!_this.isHiding && !_this.isTransparentBlockingOverlayActive) {
                        void 0;
                        $overlay.show();
                    }
                    if (!_this.isHiding) {
                        void 0;
                        $overlay
                            .stop(true)
                            .animate({
                            opacity: 1
                        }, 300, function () {
                            void 0;
                        });
                    }
                }, _this.delay);
            });
        };
        Overlay.prototype.hide = function () {
            void 0;
            var $elementsToDisable = $(this.selector);
            this.isHiding = true;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                var overlayUuid = $elementToDisable.attr("data-overlay-uuid");
                if (!ButterFaces.ObjectStatics.isNullOrUndefined(overlayUuid) && ButterFaces.Overlay.findOverlay(overlayUuid).length > 0) {
                    var $overlay = ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid"));
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.prototype.calcOverlaySpinnerClass = function (element) {
            if (element.outerHeight() < 55) {
                return "butter-component-spinner tiny";
            }
            if (element.outerHeight() < 105) {
                return "butter-component-spinner small";
            }
            return "butter-component-spinner";
        };
        Overlay.hideAll = function () {
            void 0;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            ButterFaces.Overlay.fadeOutAttachtedOverlays();
        };
        Overlay.fadeOutDetachtedOverlays = function () {
            // remove unbinded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                if ($("[data-overlay-uuid=" + uuidToCheck + "]").length === 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.fadeOutAttachtedOverlays = function () {
            // remove binded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                var elements = $("[data-overlay-uuid=" + uuidToCheck + "]");
                if (elements.length > 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                    elements.each(function (index, element) {
                        var $element = $(element);
                        $element.removeAttr("data-overlay-uuid");
                    });
                }
            });
        };
        Overlay.fadeOutOverlay = function ($overlay) {
            $overlay
                .stop(true)
                .animate({
                opacity: 0
            }, 300, function () {
                $overlay.remove();
                void 0;
            });
        };
        Overlay.findOverlay = function (uuid) {
            return $("body .butter-component-overlay[data-overlay-uuid='" + uuid + "']");
        };
        return Overlay;
    }());
    ButterFaces.Overlay = Overlay;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var RadioBox = /** @class */ (function () {
        function RadioBox() {
        }
        RadioBox.addStyleClassClickEvent = function (radioBoxId) {
            var radioBox = document.getElementById(radioBoxId);
            radioBox.addEventListener("change", function (event) {
                void 0;
                [].forEach.call(document.querySelectorAll(".radio"), function (el) {
                    void 0;
                    el.classList.remove("butter-radio-item-selected");
                });
                void 0;
                event.target.parentNode.classList.add("butter-radio-item-selected");
            });
        };
        return RadioBox;
    }());
    ButterFaces.RadioBox = RadioBox;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-ajax.ts"/>
(function ($) {
    $.fn.selectTableRow = function (data) {
        return this.each(function () {
            var $originalElement = $(this);
            void 0;
            void 0;
            $originalElement.find("tr").removeClass("butter-table-row-selected");
            var listItems = $originalElement.find("tr[rowindex=" + data.rowIndex + "]");
            $(listItems[listItems.length - 1]).addClass("butter-table-row-selected");
        });
    };
}(jQuery));
(function ($) {
    $.fn.sortTableRow = function (renderIds, disableRenderIds, columnNumber) {
        return this.each(function () {
            var $table = $(this);
            // let rows = $table.find("tbody > tr").length;
            // let columns = $table.find("thead th").length;
            ButterFaces.Ajax.sendRequest($table.attr("id"), "sort_" + columnNumber, renderIds, columnNumber, disableRenderIds);
        });
    };
}(jQuery));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Tooltip = /** @class */ (function () {
        function Tooltip(popoverMaxWidthByBootstrap, popoverMaxHeightByButterFaces) {
            if (popoverMaxWidthByBootstrap === void 0) { popoverMaxWidthByBootstrap = 276; }
            if (popoverMaxHeightByButterFaces === void 0) { popoverMaxHeightByButterFaces = 110; }
            this.popoverMaxWidthByBootstrap = popoverMaxWidthByBootstrap;
            this.popoverMaxHeightByButterFaces = popoverMaxHeightByButterFaces;
            void 0;
        }
        Tooltip.prototype.calculateTooltipPosition = function (popover, source) {
            var offsetBottom = $(window).height() - $(source).offset().top - $(source).outerHeight();
            var offsetRight = $(window).width() - $(source).offset().left - $(source).outerWidth();
            void 0;
            void 0;
            if (offsetBottom < this.popoverMaxHeightByButterFaces) {
                if (offsetRight < this.popoverMaxWidthByBootstrap) {
                    void 0;
                    if ($(source).offset().left < this.popoverMaxWidthByBootstrap) {
                        void 0;
                        return "top";
                    }
                    void 0;
                    return "left";
                }
                void 0;
                return "right";
            }
            void 0;
            return "bottom";
        };
        return Tooltip;
    }());
    ButterFaces.Tooltip = Tooltip;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var TreeBox = /** @class */ (function () {
        function TreeBox() {
        }
        TreeBox.removeTrivialTreeDropDown = function (treeBoxId) {
            this.removeTrivialTreeDropDownById(treeBoxId);
            this.removeUnAssociatedTrivialTreeDropDowns();
        };
        TreeBox.removeUnAssociatedTrivialTreeDropDowns = function () {
            var dropdowns = document.querySelectorAll(".tr-dropdown[data-tree-box-id]");
            Array.prototype.slice.call(dropdowns, 0).forEach(function (dropdown) {
                var dropdownId = dropdown.getAttribute("data-tree-box-id");
                if (document.querySelectorAll(".butter-component-treebox[data-tree-box-id=" + dropdownId + "]").length === 0) {
                    dropdown.parentNode.removeChild(dropdown);
                }
            });
        };
        TreeBox.removeTrivialTreeDropDownById = function (treeBoxId) {
            // in jQuery: $(".tr-dropdown[data-tree-box-id=" + treeBoxId + "]").remove();
            // plain javascript:
            var dropdowns = document.querySelectorAll(".tr-dropdown[data-tree-box-id=" + treeBoxId + "]");
            Array.prototype.slice.call(dropdowns, 0).forEach(function (dropdown) {
                dropdown.parentNode.removeChild(dropdown);
            });
        };
        return TreeBox;
    }());
    ButterFaces.TreeBox = TreeBox;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/trivial-components/dist/js/bundle/trivial-components-global.d.ts"/>
///<reference path="../../node_modules/@types/mustache/index.d.ts"/>
var ButterFaces;
(function (ButterFaces) {
    function createTrivialTagComponent($input, options) {
        return new TrivialComponents.TrivialTagComboBox($input, {
            autoComplete: options.autoComplete,
            allowFreeText: true,
            showTrigger: options.showTrigger,
            distinct: options.distinct,
            editingMode: options.editingMode,
            matchingOptions: {
                matchingMode: "contains",
                ignoreCase: true,
                maxLevenshteinDistance: 0
            },
            maxSelectedEntries: options.maxSelectedEntries,
            selectedEntries: options.selectedEntries,
            freeTextSeparators: options.freeTextSeparators,
            entries: options.entries,
            valueFunction: function (entries) {
                return entries
                    .map(function (entry) { return entry.id != null ? entry.id : entry.title; })
                    .join(",");
            },
            freeTextEntryFactory: function (freeText) {
                return { title: escapeHtml(freeText) };
            },
            entryRenderingFunction: function (entry) { return "<div>" + entry.title + "</div>"; },
        });
        function escapeHtml(source) {
            /* tslint:disable */
            var entityMap = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': "&quot;",
                "'": "&#39;",
                "/": "&#x2F;"
            };
            /* tslint:enable */
            return source.replace(/[&<>"'\/]/g, function (s) { return entityMap[s]; });
        }
    }
    ButterFaces.createTrivialTagComponent = createTrivialTagComponent;
    function createTrivialTreeComponent($input, options) {
        return new TrivialComponents.TrivialTree($input, {
            searchBarMode: options.searchBarMode,
            selectedEntryId: options.selectedEntryId,
            performanceOptimizationSettings: options.performanceOptimizationSettings,
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComponent = createTrivialTreeComponent;
    function createTrivialComboBox($input, options) {
        return new TrivialComponents.TrivialComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry) {
                return Mustache.render(options.template, entry);
            },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.template, entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries
        });
    }
    ButterFaces.createTrivialComboBox = createTrivialComboBox;
    function createTrivialTreeComboBox($input, options) {
        return new TrivialComponents.TrivialTreeComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.templates[0], entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComboBox = createTrivialTreeComboBox;
})(ButterFaces || (ButterFaces = {}));

var ButterFaces;
(function (ButterFaces) {
    var ObjectStatics = /** @class */ (function () {
        function ObjectStatics() {
        }
        ObjectStatics.isNullOrUndefined = function (value) {
            return typeof value === "undefined" || value === null;
        };
        return ObjectStatics;
    }());
    ButterFaces.ObjectStatics = ObjectStatics;
})(ButterFaces || (ButterFaces = {}));

///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var String = /** @class */ (function () {
        function String() {
        }
        String.format = function (format, params) {
            return format.replace(/{(\d+)}/g, function (match, num) {
                return ButterFaces.ObjectStatics.isNullOrUndefined(params[num]) ? match : params[num];
            });
        };
        return String;
    }());
    ButterFaces.String = String;
})(ButterFaces || (ButterFaces = {}));

///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-overlay.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var WaitingPanel = /** @class */ (function () {
        function WaitingPanel(overlay) {
            this.overlay = overlay;
        }
        WaitingPanel.prototype.processAjaxUpdate = function () {
            var _this = this;
            var ajaxRequestsRunning = 0;
            return function (_a) {
                var status = _a.status;
                void 0;
                if (status === "begin") {
                    ajaxRequestsRunning++;
                }
                else if (status === "success") {
                    ajaxRequestsRunning--;
                }
                if (ajaxRequestsRunning > 0) {
                    void 0;
                    _this.overlay.show();
                }
                else {
                    void 0;
                    _this.overlay.hide();
                }
            };
        };
        WaitingPanel.prototype.processOnError = function (data) {
            if (data) {
                void 0;
                ButterFaces.Overlay.hideAll();
            }
        };
        return WaitingPanel;
    }());
    ButterFaces.WaitingPanel = WaitingPanel;
})(ButterFaces || (ButterFaces = {}));
(function ($) {
    // extend jQuery --------------------------------------------------------------------
    var eventRegistered = false;
    var overlay;
    $.fn.waitingPanel = function (_a) {
        var waitingPanelDelay = _a.waitingPanelDelay, blockpage = _a.blockpage;
        return this.each(function () {
            // I found no way to remove event listener from jsf js.
            // I tried to register a callback once and change it on render waiting panel but after this
            // no waiting panel appears anymore.
            // Actually on each rendering of this component a new callback is put on event listener collection.
            if (!eventRegistered) {
                // console.log("waitingPanel - register: " + _elementId);
                overlay = new ButterFaces.Overlay(waitingPanelDelay, blockpage);
                var waitingPanel = new ButterFaces.WaitingPanel(overlay);
                jsf.ajax.addOnEvent(waitingPanel.processAjaxUpdate());
                jsf.ajax.addOnError(waitingPanel.processOnError);
                eventRegistered = true;
            }
            overlay.delay = waitingPanelDelay;
            overlay.isTransparentBlockingOverlayActive = blockpage;
        });
    };
}(jQuery));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
