/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.iterable;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.burningwave.core.function.ThrowingBiConsumer;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelperImpl;
import org.burningwave.core.iterable.IterationConfigImpl;
import org.burningwave.core.iterable.Properties;

public interface IterableObjectHelper {
    public static IterableObjectHelper create(Properties config) {
        IterableObjectHelperImpl iterableObjectHelper = new IterableObjectHelperImpl(config);
        iterableObjectHelper.listenTo(config);
        return iterableObjectHelper;
    }

    public Predicate<Object> getDefaultMinimumCollectionSizeForParallelIterationPredicate();

    public String getDefaultValuesSeparator();

    public <K, V> void processChangeNotification(Properties var1, Properties.Event var2, K var3, V var4, V var5);

    public <K, V> void deepClear(Map<K, V> var1);

    public <K, V, E extends Throwable> void deepClear(Map<K, V> var1, ThrowingBiConsumer<K, V, E> var2) throws E;

    public <V> void deepClear(Collection<V> var1);

    public <V, E extends Throwable> void deepClear(Collection<V> var1, ThrowingConsumer<V, E> var2) throws E;

    public <T> Collection<T> merge(Supplier<Collection<T>> var1, Supplier<Collection<T>> var2, Supplier<Collection<T>> var3);

    public <T> T getRandom(Collection<T> var1);

    public <T> Stream<T> retrieveStream(Object var1);

    public long getSize(Object var1);

    public <T> T resolveValue(ResolveConfig.ForNamedKey var1);

    public <K, T> T resolveValue(ResolveConfig.ForAllKeysThat<K> var1);

    public String resolveStringValue(ResolveConfig.ForNamedKey var1);

    public <K> String resolveStringValue(ResolveConfig.ForAllKeysThat<K> var1);

    public <T> Collection<T> resolveValues(ResolveConfig.ForNamedKey var1);

    public <K, V> Map<K, V> resolveValues(ResolveConfig.ForAllKeysThat<K> var1);

    public Collection<String> resolveStringValues(ResolveConfig.ForNamedKey var1);

    public <K> Map<K, Collection<String>> resolveStringValues(ResolveConfig.ForAllKeysThat<K> var1);

    public Collection<String> getAllPlaceHolders(Map<?, ?> var1);

    public Collection<String> getAllPlaceHolders(Map<?, ?> var1, Predicate<String> var2);

    public Collection<String> getAllPlaceHolders(Map<?, ?> var1, String var2);

    public <I, D, O> Collection<O> iterateAndGet(IterationConfig.WithOutputOfCollection<I, D, O> var1);

    public <I, D, K, O> Map<K, O> iterateAndGet(IterationConfig.WithOutputOfMap<I, D, K, O> var1);

    public <I, D> void iterate(IterationConfig<I, D, ?> var1);

    public boolean containsValue(Map<?, ?> var1, String var2, Object var3);

    public <K, V> void refresh(Map<K, V> var1, Map<K, V> var2);

    public boolean containsValue(Map<?, ?> var1, String var2, Object var3, Map<?, ?> var4);

    public String toPrettyString(Map<?, ?> var1, String var2, int var3);

    public <K, V> String toString(Map<K, V> var1, int var2);

    default public void terminateIteration() {
        throw TerminateIteration.NOTIFICATION;
    }

    default public boolean isIterationTerminatedNotification(Throwable exc) {
        return exc instanceof TerminateIteration;
    }

    public <K, V> String toString(Map<K, V> var1, Function<K, String> var2, Function<V, String> var3, int var4);

    public static class TerminateIteration
    extends RuntimeException {
        private static final long serialVersionUID = 4182825598193659018L;
        public static final TerminateIteration NOTIFICATION = new TerminateIteration();

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class ResolveConfig<T, K> {
        Map<?, ?> map;
        K filter;
        String valuesSeparator;
        String defaultValueSeparator;
        boolean deleteUnresolvedPlaceHolder;
        Map<?, ?> defaultValues;

        private ResolveConfig(K filter) {
            this.filter = filter;
        }

        public static ForNamedKey forNamedKey(Object key) {
            return new ForNamedKey(key);
        }

        public static <K> ForAllKeysThat<K> forAllKeysThat(Predicate<K> filter) {
            return new ForAllKeysThat(filter);
        }

        public T on(Map<?, ?> map) {
            this.map = map;
            return (T)this;
        }

        public T withDefaultValues(Map<?, ?> defaultValues) {
            this.defaultValues = defaultValues;
            return (T)this;
        }

        public T withValuesSeparator(String valuesSeparator) {
            this.valuesSeparator = valuesSeparator;
            return (T)this;
        }

        public T withDefaultValueSeparator(String defaultValueSeparator) {
            this.defaultValueSeparator = defaultValueSeparator;
            return (T)this;
        }

        public T deleteUnresolvedPlaceHolder(boolean flag) {
            this.deleteUnresolvedPlaceHolder = flag;
            return (T)this;
        }

        public static class ForNamedKey
        extends ResolveConfig<ForNamedKey, Object> {
            private ForNamedKey(Object filter) {
                super(filter);
            }
        }

        public static class ForAllKeysThat<K>
        extends ResolveConfig<ForAllKeysThat<K>, Predicate<K>> {
            private ForAllKeysThat(Predicate<K> filter) {
                super(filter);
            }
        }
    }

    public static interface IterationConfig<I, D, C extends IterationConfig<I, D, C>> {
        public static <J, I, C extends IterationConfig<Map.Entry<J, I>, Collection<I>, C>> C of(Map<J, I> input) {
            return (C)new IterationConfigImpl(input != null ? input.entrySet() : null);
        }

        public static <I, C extends IterationConfig<I, Collection<I>, C>> C of(Collection<I> input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<I, I[], C>> C of(I[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Integer, int[], C>> C ofInts(int[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Long, long[], C>> C ofLongs(long[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Float, float[], C>> C ofFloats(float[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Double, double[], C>> C ofDoubles(double[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Boolean, boolean[], C>> C ofBooleans(boolean[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Byte, byte[], C>> C ofBytes(byte[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <I, C extends IterationConfig<Character, char[], C>> C ofChars(char[] input) {
            return (C)new IterationConfigImpl(input);
        }

        public static <J, I, C extends IterationConfig<Map.Entry<J, I>, Collection<I>, C>> C ofNullable(Map<J, I> input) {
            return (C)new IterationConfigImpl(input != null ? input.entrySet() : IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<I, Collection<I>, C>> C ofNullable(Collection<I> input) {
            return (C)new IterationConfigImpl(input != null ? input : IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<I, I[], C>> C ofNullable(I[] input) {
            return (C)new IterationConfigImpl(input != null ? input : IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Integer, int[], C>> C ofNullableInts(int[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (int[])IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Long, long[], C>> C ofNullableLongs(long[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (long[])IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Float, float[], C>> C ofNullableFloats(float[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (float[])IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Double, double[], C>> C ofNullableDoubles(double[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (double[])IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Boolean, boolean[], C>> C ofNullableBooleans(boolean[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (boolean[])IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Byte, byte[], C>> C ofNullableBytes(byte[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (byte[])IterationConfigImpl.NO_ITEMS);
        }

        public static <I, C extends IterationConfig<Character, char[], C>> C ofNullableChars(char[] input) {
            return (C)new IterationConfigImpl(input != null ? input : (char[])IterationConfigImpl.NO_ITEMS);
        }

        public C withAction(Consumer<I> var1);

        public <O> WithOutputOfCollection<I, D, O> withOutput(Collection<O> var1);

        public <K, O> WithOutputOfMap<I, D, K, O> withOutput(Map<K, O> var1);

        public C parallelIf(Predicate<D> var1);

        public C withPriority(Integer var1);

        public static class WithOutputOfCollection<I, D, O>
        extends IterationConfigImpl.WithOutput<I, D, WithOutputOfCollection<I, D, O>> {
            WithOutputOfCollection(IterationConfigImpl<I, D> configuration) {
                super(configuration);
            }

            public WithOutputOfCollection<I, D, O> withAction(BiConsumer<I, Consumer<Consumer<Collection<O>>>> action) {
                this.wrappedConfiguration.withAction(action);
                return this;
            }
        }

        public static class WithOutputOfMap<I, D, K, O>
        extends IterationConfigImpl.WithOutput<I, D, WithOutputOfMap<I, D, K, O>> {
            WithOutputOfMap(IterationConfigImpl<I, D> configuration) {
                super(configuration);
            }

            public WithOutputOfMap<I, D, K, O> withAction(BiConsumer<I, Consumer<Consumer<Map<K, O>>>> action) {
                this.wrappedConfiguration.withAction(action);
                return this;
            }
        }
    }

    public static class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues.put("iterable-object-helper.default-values-separator", ";");
            defaultValues.put("iterable-object-helper.parallel-iteration.applicability.max-runtime-thread-count-threshold", "autodetect");
            defaultValues.put("iterable-object-helper.parallel-iteration.applicability.default-minimum-collection-size", 2);
            defaultValues.put("iterable-object-helper.parallel-iteration.applicability.output-collection-enabled-types", ConcurrentHashMap.class.getName() + "$CollectionView;" + CopyOnWriteArrayList.class.getName() + ";" + CopyOnWriteArraySet.class.getName() + ";" + BlockingQueue.class.getName() + ";" + ConcurrentSkipListSet.class.getName() + ";" + ConcurrentSkipListMap.class.getName() + "$EntrySet;" + ConcurrentSkipListMap.class.getName() + "$KeySet;" + ConcurrentSkipListMap.class.getName() + "$Values;");
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static class Key {
            public static final String DEFAULT_VALUES_SEPERATOR = "iterable-object-helper.default-values-separator";
            public static final String PARELLEL_ITERATION_APPLICABILITY_MAX_RUNTIME_THREAD_COUNT_THRESHOLD = "iterable-object-helper.parallel-iteration.applicability.max-runtime-thread-count-threshold";
            public static final String PARELLEL_ITERATION_APPLICABILITY_DEFAULT_MINIMUM_COLLECTION_SIZE = "iterable-object-helper.parallel-iteration.applicability.default-minimum-collection-size";
            public static final String PARELLEL_ITERATION_APPLICABILITY_OUTPUT_COLLECTION_ENABLED_TYPES = "iterable-object-helper.parallel-iteration.applicability.output-collection-enabled-types";
        }
    }
}

