/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.burningwave.core.Closeable;
import org.burningwave.core.Identifiable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.Synchronizer;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.iterable.IterableObjectHelper;

public abstract class Thread
extends java.lang.Thread
implements ManagedLogger {
    ThrowingConsumer<Thread, ? extends Throwable> originalExecutable;
    ThrowingConsumer<Thread, ? extends Throwable> executable;
    boolean looper;
    boolean looping;
    private long number;
    boolean alive;
    Supplier supplier;

    private Thread(Supplier threadSupplier, long number) {
        super(threadSupplier.name + " - Executor " + number);
        this.supplier = threadSupplier;
        this.number = number;
        this.setIndexedName();
        this.setDaemon(threadSupplier.daemon);
    }

    public void setIndexedName() {
        this.setIndexedName(null);
    }

    public void setIndexedName(String prefix) {
        this.setName(Optional.ofNullable(prefix).orElseGet(() -> this.supplier.name + " - Executor") + " " + this.number);
    }

    public Thread setExecutable(ThrowingConsumer<Thread, ? extends Throwable> executable) {
        return this.setExecutable(executable, false);
    }

    public Thread setExecutable(ThrowingConsumer<Thread, ? extends Throwable> executable, boolean isLooper) {
        this.originalExecutable = executable;
        this.looper = isLooper;
        return this;
    }

    public boolean isDetached() {
        return this instanceof Detached;
    }

    public boolean isPoolable() {
        return this instanceof Poolable;
    }

    @Override
    public synchronized void start() {
        this.executable = !this.looper ? this.originalExecutable : thread -> {
            this.looping = true;
            while (this.looping) {
                this.originalExecutable.accept(this);
            }
        };
        if (this.alive) {
            this.notifyAll();
        } else {
            this.alive = true;
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLooping() {
        this.looping = false;
        Thread thread = this;
        synchronized (thread) {
            this.notifyAll();
        }
    }

    public boolean isLooping() {
        return this.looping;
    }

    public synchronized void waitFor(long millis) {
        try {
            this.wait(millis);
        }
        catch (InterruptedException exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), exc);
        }
    }

    void shutDown() {
        this.shutDown(false);
    }

    void shutDown(boolean waitForFinish) {
        this.alive = false;
        this.stopLooping();
        if (waitForFinish && Thread.currentThread() != this) {
            try {
                this.join();
            }
            catch (InterruptedException exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
            }
        }
    }

    public static class Supplier
    implements Identifiable {
        private static long threadNumberSupplier;
        private String name;
        private volatile int threadCount;
        private volatile int poolableThreadCount;
        private int maxPoolableThreadCount;
        private int inititialMaxThreadCount;
        private int maxThreadCount;
        private int maxDetachedThreadCountIncreasingStep;
        private long poolableThreadRequestTimeout;
        private long elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount;
        private Collection<Thread> runningThreads;
        private Thread[] poolableSleepingThreads;
        private Thread poolableSleepingThreadCollectionNotifier;
        private long timeOfLastIncreaseOfMaxDetachedThreadCount;
        private boolean daemon;
        private Predicate<Thread> addForwardPoolableSleepingThreadFunction = this::addForwardPoolableSleepingThread;
        private Predicate<Thread> addReversePoolableSleepingThreadFunction = this::addReversePoolableSleepingThread;
        private Predicate<Thread> addPoolableSleepingThreadFunction = this.addForwardPoolableSleepingThreadFunction;
        private java.util.function.Supplier<Thread> getForwardPoolableThreadFunction;
        private java.util.function.Supplier<Thread> getReversePoolableThreadFunction;
        private java.util.function.Supplier<Thread> getPoolableThreadFunction;
        private String addPoolableSleepingThreadOperationId = this.getOperationId("addPoolableSleepingThread");

        Supplier(String name, Properties config) {
            int maxDetachedThreadCount;
            this.getForwardPoolableThreadFunction = this::getForwardPoolableThread;
            this.getReversePoolableThreadFunction = this::getReversePoolableThread;
            this.getPoolableThreadFunction = this.getForwardPoolableThreadFunction;
            this.name = name;
            this.daemon = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.default-daemon-flag-value").on(config)));
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            int multiplier = 3;
            try {
                this.maxPoolableThreadCount = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-poolable-thread-count").on(config)));
            }
            catch (Throwable exc) {
                this.maxPoolableThreadCount = availableProcessors * multiplier;
            }
            if (this.maxPoolableThreadCount < 0) {
                throw new IllegalArgumentException("maxPoolableThreadCount must be greater than or equal to zero");
            }
            try {
                maxDetachedThreadCount = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-detached-thread-count").on(config)));
            }
            catch (Throwable exc) {
                maxDetachedThreadCount = availableProcessors * multiplier;
            }
            if (maxDetachedThreadCount < 0) {
                maxDetachedThreadCount = Integer.MAX_VALUE - this.maxPoolableThreadCount;
            }
            this.runningThreads = ConcurrentHashMap.newKeySet();
            this.poolableSleepingThreads = new Thread[this.maxPoolableThreadCount];
            this.inititialMaxThreadCount = this.maxThreadCount = this.maxPoolableThreadCount + maxDetachedThreadCount;
            this.poolableThreadRequestTimeout = StaticComponentContainer.Objects.toLong(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.poolable-thread-request-timeout").on(config)));
            this.elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount = StaticComponentContainer.Objects.toLong(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-detached-thread-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value").on(config)));
            try {
                this.maxDetachedThreadCountIncreasingStep = StaticComponentContainer.Objects.toInt(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("thread-supplier.max-detached-thread-count.increasing-step").on(config)));
            }
            catch (Throwable exc) {
                this.maxDetachedThreadCountIncreasingStep = availableProcessors;
            }
            if (this.maxDetachedThreadCountIncreasingStep < 1) {
                this.poolableThreadRequestTimeout = 0L;
                config.put("thread-supplier.poolable-thread-request-timeout", (Object)this.poolableThreadRequestTimeout);
            }
            this.timeOfLastIncreaseOfMaxDetachedThreadCount = Long.MAX_VALUE;
        }

        public static Supplier create(String name, Properties config, boolean undestroyable) {
            if (undestroyable) {
                return new Supplier(name, config){
                    StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                    @Override
                    public void shutDownAll() {
                        if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                            super.shutDownAll();
                        }
                    }
                };
            }
            return new Supplier(name, config);
        }

        public Thread getOrCreate(String name) {
            Thread thread = this.getOrCreate();
            thread.setName(name);
            return thread;
        }

        public final Thread getOrCreate() {
            return this.getOrCreate(1);
        }

        public final Thread getOrCreate(int requestCount) {
            return this.getOrCreate(requestCount, requestCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Thread getOrCreate(int initialValue, int requestCount) {
            Thread[] threadArray;
            Thread thread = this.getPoolableThreadFunction.get();
            if (thread != null) {
                return thread;
            }
            if (requestCount > 0 && this.poolableThreadCount >= this.maxPoolableThreadCount && this.threadCount >= this.maxThreadCount) {
                threadArray = this.poolableSleepingThreads;
                synchronized (this.poolableSleepingThreads) {
                    try {
                        thread = this.getPoolableThreadFunction.get();
                        if (thread != null) {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return thread;
                        }
                        if (this.poolableThreadCount >= this.maxPoolableThreadCount && this.threadCount >= this.maxThreadCount) {
                            long startWaitTime = System.currentTimeMillis();
                            this.poolableSleepingThreads.wait(this.poolableThreadRequestTimeout);
                            if (this.maxDetachedThreadCountIncreasingStep < 1) {
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                return this.getOrCreate(initialValue, requestCount);
                            }
                            long endWaitTime = System.currentTimeMillis();
                            long waitElapsedTime = endWaitTime - startWaitTime;
                            if (waitElapsedTime < this.poolableThreadRequestTimeout) {
                                if (this.inititialMaxThreadCount < this.maxThreadCount && System.currentTimeMillis() - this.timeOfLastIncreaseOfMaxDetachedThreadCount > this.elapsedTimeThresholdFromLastIncreaseForGradualDecreasingOfMaxDetachedThreadsCount) {
                                    this.maxThreadCount -= this.maxDetachedThreadCountIncreasingStep / 2;
                                    StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), "{}: decreasing maxThreadCount to {}", java.lang.Thread.currentThread(), this.maxThreadCount);
                                    this.timeOfLastIncreaseOfMaxDetachedThreadCount = Long.MAX_VALUE;
                                }
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                return this.getOrCreate(initialValue, requestCount);
                            }
                            this.timeOfLastIncreaseOfMaxDetachedThreadCount = System.currentTimeMillis();
                            this.maxThreadCount += this.maxDetachedThreadCountIncreasingStep;
                            StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), "{} waited for {}ms: maxThreadCount will be temporarily increased to {} to avoid performance degradation", java.lang.Thread.currentThread(), waitElapsedTime, this.maxThreadCount);
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return this.getOrCreate(initialValue, --requestCount);
                        }
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(() -> Thread.class.getName(), exc);
                    }
                }
            }
            if (this.poolableThreadCount >= this.maxPoolableThreadCount) {
                if (this.threadCount < this.maxThreadCount) {
                    return this.createDetachedThread();
                }
                return this.getOrCreate(initialValue, initialValue);
            }
            {
                threadArray = this.poolableSleepingThreads;
                synchronized (this.poolableSleepingThreads) {
                    if (this.poolableThreadCount >= this.maxPoolableThreadCount) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return this.getOrCreate(initialValue, requestCount);
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.createPoolableThread();
                }
            }
        }

        Thread createPoolableThread() {
            ++this.poolableThreadCount;
            ++this.threadCount;
            return new Poolable(this, ++threadNumberSupplier);
        }

        Thread createDetachedThread() {
            ++this.threadCount;
            return new Detached(this, ++threadNumberSupplier);
        }

        private boolean addForwardPoolableSleepingThread(Thread thread) {
            this.addPoolableSleepingThreadFunction = this.addReversePoolableSleepingThreadFunction;
            for (int i = 0; i < this.poolableSleepingThreads.length; ++i) {
                if (this.poolableSleepingThreads[i] != null || !this.addPoolableSleepingThread(thread, i)) continue;
                return true;
            }
            return false;
        }

        private boolean addReversePoolableSleepingThread(Thread thread) {
            this.addPoolableSleepingThreadFunction = this.addForwardPoolableSleepingThreadFunction;
            for (int i = this.poolableSleepingThreads.length - 1; i >= 0; --i) {
                if (this.poolableSleepingThreads[i] != null || !this.addPoolableSleepingThread(thread, i)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean addPoolableSleepingThread(Thread thread, int currentIndex) {
            try (Synchronizer.Mutex mutex = StaticComponentContainer.Synchronizer.getMutex(this.getOperationId(this.addPoolableSleepingThreadOperationId + "[" + currentIndex + "]"));){
                Synchronizer.Mutex mutex2 = mutex;
                synchronized (mutex2) {
                    if (this.poolableSleepingThreads[currentIndex] == null) {
                        this.poolableSleepingThreads[currentIndex] = thread;
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Thread getForwardPoolableThread() {
            this.getPoolableThreadFunction = this.getReversePoolableThreadFunction;
            for (int i = 0; i < this.poolableSleepingThreads.length; ++i) {
                Thread thread = this.poolableSleepingThreads[i];
                if (thread == null) continue;
                Thread thread2 = thread;
                synchronized (thread2) {
                    if (this.poolableSleepingThreads[i] == thread) {
                        this.poolableSleepingThreads[i] = null;
                        return thread;
                    }
                    continue;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Thread getReversePoolableThread() {
            this.getPoolableThreadFunction = this.getForwardPoolableThreadFunction;
            for (int i = this.poolableSleepingThreads.length - 1; i >= 0; --i) {
                Thread thread = this.poolableSleepingThreads[i];
                if (thread == null) continue;
                Thread thread2 = thread;
                synchronized (thread2) {
                    if (this.poolableSleepingThreads[i] == thread) {
                        this.poolableSleepingThreads[i] = null;
                        return thread;
                    }
                    continue;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean removePoolableSleepingThread(Thread thread) {
            for (int i = 0; i < this.poolableSleepingThreads.length; ++i) {
                if (this.poolableSleepingThreads[i] != thread) continue;
                Thread thread2 = thread;
                synchronized (thread2) {
                    if (this.poolableSleepingThreads[i] == thread) {
                        this.poolableSleepingThreads[i] = null;
                        return true;
                    }
                    continue;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyToPoolableSleepingThreadCollectionWaiter() {
            try {
                Thread thread = this.poolableSleepingThreadCollectionNotifier;
                synchronized (thread) {
                    this.poolableSleepingThreadCollectionNotifier.notify();
                }
            }
            catch (NullPointerException exception) {
                StaticComponentContainer.Synchronizer.execute(this.getOperationId("createPoolableSleepingThreadCollectionNotifier"), () -> {
                    if (this.poolableSleepingThreadCollectionNotifier == null) {
                        Thread poolableSleepingThreadCollectionNotifier = this.createDetachedThread().setExecutable(thread -> {
                            try {
                                Thread[] threadArray = thread;
                                synchronized (thread) {
                                    thread.wait();
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    threadArray = this.poolableSleepingThreads;
                                    synchronized (this.poolableSleepingThreads) {
                                        this.poolableSleepingThreads.notifyAll();
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        return;
                                    }
                                }
                            }
                            catch (Throwable exc) {
                                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                            }
                        }, true);
                        poolableSleepingThreadCollectionNotifier.setName(this.name + " - Notifier");
                        poolableSleepingThreadCollectionNotifier.setPriority(10);
                        poolableSleepingThreadCollectionNotifier.setDaemon(this.daemon);
                        poolableSleepingThreadCollectionNotifier.start();
                        this.poolableSleepingThreadCollectionNotifier = poolableSleepingThreadCollectionNotifier;
                    }
                });
                this.notifyToPoolableSleepingThreadCollectionWaiter();
            }
        }

        public void shutDownAllPoolableSleeping() {
            for (Thread thread : this.poolableSleepingThreads) {
                if (thread == null) continue;
                thread.shutDown();
            }
        }

        public void shutDownAll() {
            this.shutDownAllPoolableSleeping();
            Iterator<Thread> itr = this.runningThreads.iterator();
            while (itr.hasNext()) {
                itr.next().shutDown();
            }
            StaticComponentContainer.Synchronizer.execute(this.getOperationId("createPoolableSleepingThreadCollectionNotifier"), () -> {
                Thread poolableSleepingThreadCollectionNotifier = this.poolableSleepingThreadCollectionNotifier;
                this.poolableSleepingThreadCollectionNotifier = null;
                Thread thread = poolableSleepingThreadCollectionNotifier;
                synchronized (thread) {
                    poolableSleepingThreadCollectionNotifier.notify();
                }
                poolableSleepingThreadCollectionNotifier.shutDown();
            });
        }

        public int getPoolableThreadCount() {
            return this.poolableThreadCount;
        }

        public int getDetachedThreadCount() {
            return this.threadCount - this.poolableThreadCount;
        }

        public int getThreadCount() {
            return this.threadCount;
        }

        public int getPoolableSleepingThreadCount() {
            int count = 0;
            for (Thread thread : this.poolableSleepingThreads) {
                if (thread == null) continue;
                ++count;
            }
            return count;
        }

        public int getRunningThreadCount() {
            return this.runningThreads.size();
        }

        public int getInititialMaxThreadCount() {
            return this.inititialMaxThreadCount;
        }

        public int getMaxDetachedThreadCountIncreasingStep() {
            return this.maxDetachedThreadCountIncreasingStep;
        }

        public int getCountOfThreadsThatCanBeSupplied() {
            if (this.maxDetachedThreadCountIncreasingStep > 0) {
                return Integer.MAX_VALUE - this.runningThreads.size();
            }
            return this.maxThreadCount - this.runningThreads.size();
        }

        public void printStatus() {
            int threadCount = this.threadCount;
            int runningThreadCount = this.runningThreads.size();
            int poolableThreadCount = this.poolableThreadCount;
            int poolableSleepingThreadCount = this.getPoolableSleepingThreadCount();
            int detachedThreadCount = threadCount - poolableThreadCount;
            StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "\n\tThread count: {}\tRunning threads: {}\n\tPoolable threads: {}\n\tPoolable running threads: {}\n\tPoolable sleeping threads: {}\n\tDetached threads: {}\n", threadCount, runningThreadCount, poolableThreadCount, poolableThreadCount - poolableSleepingThreadCount, poolableSleepingThreadCount, detachedThreadCount);
        }

        public static class Configuration {
            public static final Map<String, Object> DEFAULT_VALUES;

            static {
                HashMap<String, Object> defaultValues = new HashMap<String, Object>();
                defaultValues.put("thread-supplier.max-poolable-thread-count", "autodetect");
                defaultValues.put("thread-supplier.max-detached-thread-count", "${thread-supplier.max-poolable-thread-count}");
                defaultValues.put("thread-supplier.poolable-thread-request-timeout", 6000);
                defaultValues.put("thread-supplier.default-daemon-flag-value", true);
                defaultValues.put("thread-supplier.max-detached-thread-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value", 30000);
                defaultValues.put("thread-supplier.max-detached-thread-count.increasing-step", "autodetect");
                DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
            }

            public static class Key {
                public static final String MAX_POOLABLE_THREAD_COUNT = "thread-supplier.max-poolable-thread-count";
                public static final String MAX_DETACHED_THREAD_COUNT = "thread-supplier.max-detached-thread-count";
                public static final String DEFAULT_DAEMON_FLAG_VALUE = "thread-supplier.default-daemon-flag-value";
                public static final String POOLABLE_THREAD_REQUEST_TIMEOUT = "thread-supplier.poolable-thread-request-timeout";
                public static final String MAX_DETACHED_THREAD_COUNT_ELAPSED_TIME_THRESHOLD_FROM_LAST_INCREASE_FOR_GRADUAL_DECREASING_TO_INITIAL_VALUE = "thread-supplier.max-detached-thread-count.elapsed-time-threshold-from-last-increase-for-gradual-decreasing-to-initial-value";
                public static final String MAX_DETACHED_THREAD_COUNT_INCREASING_STEP = "thread-supplier.max-detached-thread-count.increasing-step";
            }
        }
    }

    private static class Detached
    extends Thread {
        private Detached(Supplier supplier, long number) {
            super(supplier, number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.supplier.runningThreads.add(this);
                this.executable.accept(this);
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), exc);
            }
            Detached detached = this;
            synchronized (detached) {
                if (this.supplier.runningThreads.remove(this)) {
                    --this.supplier.threadCount;
                }
            }
            this.supplier.notifyToPoolableSleepingThreadCollectionWaiter();
            detached = this;
            synchronized (detached) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            this.shutDown();
            Detached detached = this;
            synchronized (detached) {
                if (this.supplier.runningThreads.remove(this)) {
                    --this.supplier.threadCount;
                }
            }
            try {
                super.interrupt();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
            }
            this.supplier.notifyToPoolableSleepingThreadCollectionWaiter();
            detached = this;
            synchronized (detached) {
                this.notifyAll();
            }
        }
    }

    private static class Poolable
    extends Thread {
        private Poolable(Supplier supplier, long number) {
            super(supplier, number);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Poolable poolable;
            while (this.alive) {
                poolable = this;
                synchronized (poolable) {
                    this.supplier.runningThreads.add(this);
                }
                try {
                    this.executable.accept(this);
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), exc);
                }
                try {
                    this.supplier.runningThreads.remove(this);
                    this.executable = null;
                    this.originalExecutable = null;
                    if (!this.alive) continue;
                    this.setIndexedName();
                    Poolable exc = this;
                    synchronized (exc) {
                        if (!this.supplier.addPoolableSleepingThreadFunction.test(this)) {
                            StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Could not add thread {} to poolable sleeping container: it will be shutted down", StaticComponentContainer.Objects.getId(this));
                            this.shutDown();
                            continue;
                        }
                        this.supplier.notifyToPoolableSleepingThreadCollectionWaiter();
                        this.wait();
                    }
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                    this.shutDown();
                }
            }
            this.removePermanently();
            this.supplier.notifyToPoolableSleepingThreadCollectionWaiter();
            poolable = this;
            synchronized (poolable) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interrupt() {
            this.shutDown();
            this.removePermanently();
            try {
                super.interrupt();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, "Exception occurred", exc);
            }
            this.supplier.notifyToPoolableSleepingThreadCollectionWaiter();
            Poolable poolable = this;
            synchronized (poolable) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removePermanently() {
            Poolable poolable = this;
            synchronized (poolable) {
                if (this.supplier.runningThreads.remove(this)) {
                    --this.supplier.threadCount;
                    --this.supplier.poolableThreadCount;
                }
            }
            if (this.supplier.removePoolableSleepingThread(this)) {
                --this.supplier.threadCount;
                --this.supplier.poolableThreadCount;
            }
        }
    }

    public static class Holder
    implements Closeable,
    ManagedLogger {
        private Supplier threadSupplier;
        private Map<String, Thread> threads;

        private Holder() {
            this(StaticComponentContainer.ThreadSupplier);
        }

        private Holder(Supplier threadSupplier) {
            this.threadSupplier = threadSupplier;
            this.threads = new ConcurrentHashMap<String, Thread>();
        }

        public static Holder create(Supplier supplier, boolean undestroyable) {
            if (undestroyable) {
                return new Holder(supplier){
                    StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                    @Override
                    public void close() {
                        if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                            super.close();
                        }
                    }
                };
            }
            return new Holder(supplier);
        }

        public String startLooping(boolean isDaemon, int priority, Consumer<Thread> executable) {
            return this.start(null, true, isDaemon, priority, executable).getName();
        }

        public String start(boolean isDaemon, int priority, Consumer<Thread> executable) {
            return this.start(null, false, isDaemon, priority, executable).getName();
        }

        public void startLooping(String threadName, boolean isDaemon, int priority, Consumer<Thread> executable) {
            this.start(threadName, true, isDaemon, priority, executable);
        }

        public void start(String threadName, boolean isDaemon, int priority, Consumer<Thread> executable) {
            this.start(threadName, false, isDaemon, priority, executable);
        }

        private Thread start(String threadName, boolean isLooper, boolean isDaemon, int priority, Consumer<Thread> executable) {
            return StaticComponentContainer.Synchronizer.execute(threadName, () -> {
                Thread thr = this.threads.get(threadName);
                if (thr != null) {
                    this.stop(threadName);
                }
                thr = this.threadSupplier.createDetachedThread().setExecutable(thread -> {
                    try {
                        executable.accept((Thread)thread);
                    }
                    catch (Throwable exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                    }
                }, isLooper);
                if (threadName != null) {
                    thr.setName(threadName);
                }
                thr.setPriority(priority);
                thr.setDaemon(isDaemon);
                this.threads.put(threadName, thr);
                thr.start();
                return thr;
            });
        }

        public void stop(String threadName) {
            this.stop(threadName, false);
        }

        public void stop(String threadName, boolean waitThreadToFinish) {
            StaticComponentContainer.Synchronizer.execute(threadName, () -> {
                Thread thr = this.threads.get(threadName);
                if (thr == null) {
                    return;
                }
                this.threads.remove(threadName);
                thr.shutDown(waitThreadToFinish);
                thr = null;
            });
        }

        public void join(String threadName) {
            Thread thr = this.threads.get(threadName);
            if (thr != null) {
                try {
                    thr.join();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                }
            }
        }

        public boolean isAlive(String threadName) {
            Thread thr = this.threads.get(threadName);
            if (thr != null) {
                return thr.alive;
            }
            return false;
        }

        @Override
        public void close() {
            this.threads.forEach((threadName, thread) -> {
                thread.shutDown();
                this.threads.remove(threadName);
            });
            this.threads = null;
            this.threadSupplier = null;
        }
    }
}

