/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.burningwave.core.Closeable;
import org.burningwave.core.Identifiable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.concurrent.TaskStateException;
import org.burningwave.core.concurrent.Thread;
import org.burningwave.core.function.ThrowingBiPredicate;
import org.burningwave.core.function.ThrowingConsumer;
import org.burningwave.core.function.ThrowingFunction;
import org.burningwave.core.iterable.IterableObjectHelper;

public class QueuedTasksExecutor
implements Closeable,
ManagedLogger {
    private static final Map<String, TaskAbst<?, ?>> runOnlyOnceTasksToBeExecuted = new ConcurrentHashMap();
    Thread.Supplier threadSupplier;
    String name;
    java.lang.Thread tasksLauncher;
    List<TaskAbst<?, ?>> tasksQueue;
    Set<TaskAbst<?, ?>> tasksInExecution;
    Boolean supended;
    volatile int defaultPriority;
    long executedTasksCount;
    volatile long executorsIndex;
    boolean isDaemon;
    Boolean terminated;
    Runnable initializer = () -> {
        this.threadSupplier = threadSupplier;
        this.tasksQueue = new CopyOnWriteArrayList();
        this.tasksInExecution = ConcurrentHashMap.newKeySet();
        this.resumeCallerMutex = new Object();
        this.executingFinishedWaiterMutex = new Object();
        this.suspensionCallerMutex = new Object();
        this.executableCollectionFillerMutex = new Object();
        this.terminatingMutex = new Object();
        this.name = name;
        this.defaultPriority = defaultPriority;
        this.isDaemon = isDaemon;
        this.init0();
    };
    boolean taskCreationTrackingEnabled;
    Object resumeCallerMutex;
    Object executingFinishedWaiterMutex;
    Object suspensionCallerMutex;
    Object executableCollectionFillerMutex;
    Object terminatingMutex;

    QueuedTasksExecutor(String name, Thread.Supplier threadSupplier, int defaultPriority, boolean isDaemon) {
        this.init();
    }

    void init() {
        this.initializer.run();
    }

    void init0() {
        this.supended = Boolean.FALSE;
        this.terminated = Boolean.FALSE;
        this.executedTasksCount = 0L;
        this.tasksLauncher = this.threadSupplier.createDetachedThread().setExecutable(thread -> {
            Object object;
            while (!this.terminated.booleanValue()) {
                TaskAbst<?, ?> task;
                if (this.checkAndNotifySuspension()) continue;
                if (!this.tasksQueue.isEmpty()) {
                    Iterator<TaskAbst<?, ?>> taskIterator = this.tasksQueue.iterator();
                    while (taskIterator.hasNext() && !this.checkAndNotifySuspension() && !this.terminated.booleanValue()) {
                        TaskAbst<?, ?> taskAbst = task = taskIterator.next();
                        synchronized (taskAbst) {
                            if (!this.tasksQueue.remove(task)) {
                                continue;
                            }
                        }
                        ((TaskAbst)task.setExecutor(this.threadSupplier.getOrCreate())).start();
                    }
                    continue;
                }
                object = this.executableCollectionFillerMutex;
                synchronized (object) {
                    if (this.tasksQueue.isEmpty()) {
                        try {
                            task = this.executingFinishedWaiterMutex;
                            synchronized (task) {
                                this.executingFinishedWaiterMutex.notifyAll();
                            }
                            if (!this.supended.booleanValue()) {
                                this.executableCollectionFillerMutex.wait();
                            }
                        }
                        catch (InterruptedException exc) {
                            StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                        }
                    }
                }
            }
            object = this.terminatingMutex;
            synchronized (object) {
                this.tasksLauncher = null;
                this.terminatingMutex.notifyAll();
            }
        });
        this.tasksLauncher.setName(this.name + " launcher");
        this.tasksLauncher.setPriority(this.defaultPriority);
        this.tasksLauncher.setDaemon(this.isDaemon);
        this.tasksLauncher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAndNotifySuspension() {
        if (this.supended.booleanValue()) {
            Object object = this.resumeCallerMutex;
            synchronized (object) {
                Object object2 = this.suspensionCallerMutex;
                synchronized (object2) {
                    this.suspensionCallerMutex.notifyAll();
                }
                try {
                    this.resumeCallerMutex.wait();
                    return true;
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                }
            }
        }
        return false;
    }

    public static QueuedTasksExecutor create(String executorName, Thread.Supplier threadSupplier, int initialPriority) {
        return QueuedTasksExecutor.create(executorName, threadSupplier, initialPriority, false, false);
    }

    public static QueuedTasksExecutor create(String executorName, Thread.Supplier threadSupplier, int initialPriority, boolean daemon, boolean undestroyable) {
        if (undestroyable) {
            return new QueuedTasksExecutor(executorName, threadSupplier, initialPriority, daemon){
                StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                @Override
                public boolean shutDown(boolean waitForTasksTermination) {
                    if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                        return super.shutDown(waitForTasksTermination);
                    }
                    return false;
                }
            };
        }
        return new QueuedTasksExecutor(executorName, threadSupplier, initialPriority, daemon);
    }

    public QueuedTasksExecutor setTasksCreationTrackingFlag(boolean flag) {
        this.taskCreationTrackingEnabled = flag;
        return this;
    }

    public <T> ProducerTask<T> createProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable) {
        Function<ThrowingFunction<ProducerTask<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>>, ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, Throwable>, ProducerTask<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>>> taskCreator = this.getProducerTaskSupplier();
        ProducerTask<T> task = taskCreator.apply(executable);
        task.priority = this.defaultPriority;
        return task;
    }

    <T> Function<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, ProducerTask<T>> getProducerTaskSupplier() {
        return executable -> new ProducerTask<T>((ThrowingFunction)executable, this.taskCreationTrackingEnabled){

            @Override
            QueuedTasksExecutor getQueuedTasksExecutor() {
                return QueuedTasksExecutor.this;
            }

            @Override
            QueuedTasksExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                return QueuedTasksExecutor.this;
            }
        };
    }

    public Task createTask(ThrowingConsumer<Task, ? extends Throwable> executable) {
        Task task = this.getTaskSupplier().apply(executable);
        task.priority = this.defaultPriority;
        return task;
    }

    <T> Function<ThrowingConsumer<Task, ? extends Throwable>, Task> getTaskSupplier() {
        return executable -> new Task((ThrowingConsumer)executable, this.taskCreationTrackingEnabled){

            @Override
            QueuedTasksExecutor getQueuedTasksExecutor() {
                return QueuedTasksExecutor.this;
            }

            @Override
            QueuedTasksExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                return QueuedTasksExecutor.this;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E, T extends TaskAbst<E, T>> T addToQueue(T task, boolean skipCheck) {
        Object[] canBeExecutedBag = null;
        if (skipCheck || ((Boolean)(canBeExecutedBag = this.canBeExecuted(task))[1]).booleanValue()) {
            try {
                this.tasksQueue.add(task);
                Object object = this.executableCollectionFillerMutex;
                synchronized (object) {
                    this.executableCollectionFillerMutex.notifyAll();
                }
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
            }
        }
        return (T)(canBeExecutedBag != null ? (TaskAbst)canBeExecutedBag[0] : task);
    }

    <E, T extends TaskAbst<E, T>> Object[] canBeExecuted(T task) {
        Object[] bag = new Object[]{task, true};
        if (task.runOnlyOnce) {
            bag[1] = task.hasBeenExecutedChecker.get() == false && Optional.ofNullable(runOnlyOnceTasksToBeExecuted.putIfAbsent(task.id, task)).map(taskk -> {
                bag[0] = taskk;
                return false;
            }).orElseGet(() -> true) != false;
        }
        return bag;
    }

    public <E, T extends TaskAbst<E, T>> QueuedTasksExecutor waitFor(T task) {
        return this.waitFor(task, java.lang.Thread.currentThread().getPriority(), false);
    }

    public <E, T extends TaskAbst<E, T>> QueuedTasksExecutor waitFor(T task, boolean ignoreDeadLocked) {
        return this.waitFor(task, java.lang.Thread.currentThread().getPriority(), ignoreDeadLocked);
    }

    public <E, T extends TaskAbst<E, T>> QueuedTasksExecutor waitFor(T task, int priority, boolean ignoreDeadLocked) {
        this.changePriorityToAllTaskBeforeAndWaitThem(task, priority, ignoreDeadLocked);
        task.waitForFinish(ignoreDeadLocked);
        return this;
    }

    public QueuedTasksExecutor waitForTasksEnding() {
        return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E, T extends TaskAbst<E, T>> boolean abort(T task) {
        Object object = task;
        synchronized (object) {
            if (!task.isSubmitted()) {
                task.aborted = true;
                task.clear();
            }
        }
        if (!task.isStarted()) {
            if (task.runOnlyOnce) {
                for (TaskAbst taskAbst : this.tasksQueue) {
                    if (!task.id.equals(taskAbst.id)) continue;
                    TaskAbst taskAbst2 = taskAbst;
                    synchronized (taskAbst2) {
                        if (this.tasksQueue.remove(taskAbst) && !taskAbst.isStarted()) {
                            taskAbst.aborted = true;
                            task.aborted = true;
                            taskAbst.clear();
                            task.clear();
                            taskAbst.notifyAll();
                            T t = task;
                            synchronized (t) {
                                task.notifyAll();
                            }
                            runOnlyOnceTasksToBeExecuted.remove(taskAbst.id);
                            return task.aborted;
                        }
                    }
                }
                return task.aborted;
            }
            object = task;
            synchronized (object) {
                task.aborted = this.tasksQueue.remove(task);
                if (task.aborted) {
                    task.notifyAll();
                    task.clear();
                    return task.aborted;
                }
            }
        }
        return task.aborted;
    }

    public QueuedTasksExecutor waitForTasksEnding(int priority, boolean waitForNewAddedTasks, boolean ignoreDeadLocked) {
        this.waitForTasksEnding(priority, ignoreDeadLocked);
        if (waitForNewAddedTasks) {
            while (!this.tasksInExecution.isEmpty() || !this.tasksQueue.isEmpty()) {
                this.waitForTasksEnding(priority, ignoreDeadLocked);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedTasksExecutor waitForTasksEnding(int priority, boolean ignoreDeadLocked) {
        this.tasksLauncher.setPriority(priority);
        this.tasksQueue.stream().forEach(executable -> executable.changePriority(priority));
        if (!this.tasksQueue.isEmpty()) {
            Object object = this.executingFinishedWaiterMutex;
            synchronized (object) {
                if (!this.tasksQueue.isEmpty()) {
                    try {
                        this.executingFinishedWaiterMutex.wait();
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                    }
                }
            }
        }
        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
        this.tasksLauncher.setPriority(this.defaultPriority);
        return this;
    }

    public QueuedTasksExecutor changePriority(int priority) {
        this.defaultPriority = priority;
        this.tasksLauncher.setPriority(priority);
        this.tasksQueue.stream().forEach(executable -> executable.changePriority(priority));
        return this;
    }

    public QueuedTasksExecutor suspend(boolean immediately, boolean ignoreDeadLocked) {
        return this.suspend0(immediately, java.lang.Thread.currentThread().getPriority(), ignoreDeadLocked);
    }

    public QueuedTasksExecutor suspend(boolean immediately, int priority, boolean ignoreDeadLocked) {
        return this.suspend0(immediately, priority, ignoreDeadLocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QueuedTasksExecutor suspend0(boolean immediately, int priority, boolean ignoreDeadLocked) {
        this.tasksLauncher.setPriority(priority);
        if (immediately) {
            Object object = this.suspensionCallerMutex;
            synchronized (object) {
                this.supended = Boolean.TRUE;
                this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
                try {
                    Object object2 = this.executableCollectionFillerMutex;
                    synchronized (object2) {
                        if (this.tasksLauncher.getState().equals((Object)Thread.State.WAITING)) {
                            this.executableCollectionFillerMutex.notifyAll();
                        }
                    }
                    this.suspensionCallerMutex.wait();
                }
                catch (InterruptedException exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                }
            }
        }
        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
        Task supendingTask = this.createSuspendingTask(priority);
        this.changePriorityToAllTaskBeforeAndWaitThem((Task)supendingTask.addToQueue(), priority, ignoreDeadLocked);
        supendingTask.waitForFinish(ignoreDeadLocked);
        this.tasksLauncher.setPriority(this.defaultPriority);
        return this;
    }

    Task createSuspendingTask(int priority) {
        return (Task)((Task)this.createTask(task -> {
            this.supended = Boolean.TRUE;
        }).runOnlyOnce(this.getOperationId("suspend"), () -> this.supended)).changePriority(priority);
    }

    void waitForTasksInExecutionEnding(int priority, boolean ignoreDeadLocked) {
        this.tasksInExecution.stream().forEach(task -> {
            Thread taskExecutor = task.executor;
            if (taskExecutor != null) {
                taskExecutor.setPriority(priority);
            }
            task.waitForFinish(ignoreDeadLocked);
        });
    }

    <E, T extends TaskAbst<E, T>> void changePriorityToAllTaskBeforeAndWaitThem(T task, int priority, boolean ignoreDeadLocked) {
        int taskIndex = this.tasksQueue.indexOf(task);
        if (taskIndex != -1) {
            Iterator<TaskAbst<?, ?>> taskIterator = this.tasksQueue.iterator();
            int idx = 0;
            while (taskIterator.hasNext()) {
                TaskAbst<?, ?> currentIterated = taskIterator.next();
                if (idx < taskIndex) {
                    if (currentIterated == task) break;
                    task.changePriority(priority);
                }
                ++idx;
            }
        }
        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedTasksExecutor resumeFromSuspension() {
        Object object = this.resumeCallerMutex;
        synchronized (object) {
            try {
                this.supended = Boolean.FALSE;
                this.resumeCallerMutex.notifyAll();
            }
            catch (Throwable exc) {
                StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown(boolean waitForTasksTermination) {
        List<TaskAbst<?, ?>> executables = this.tasksQueue;
        if (waitForTasksTermination) {
            this.suspend(false, true);
        } else {
            this.suspend(true, true);
        }
        this.terminated = Boolean.TRUE;
        this.logStatus();
        executables.clear();
        this.tasksInExecution.clear();
        this.resumeFromSuspension();
        if (this.tasksLauncher != null) {
            Object object = this.terminatingMutex;
            synchronized (object) {
                if (this.tasksLauncher != null) {
                    try {
                        this.terminatingMutex.wait();
                    }
                    catch (InterruptedException exc) {
                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                    }
                }
            }
        }
        this.closeResources();
        return true;
    }

    public void logStatus() {
        ArrayList tasks = new ArrayList(this.tasksQueue);
        tasks.addAll(this.tasksInExecution);
        this.logStatus(this.executedTasksCount, tasks);
    }

    private void logStatus(Long executedTasksCount, Collection<TaskAbst<?, ?>> executables) {
        Collection executablesLog = executables.stream().map(task -> {
            Object executable = task.executable;
            if (executable != null) {
                return "\t" + executable;
            }
            return null;
        }).filter(threadInfo -> threadInfo != null).collect(Collectors.toList());
        StringBuffer log = new StringBuffer(this.tasksLauncher.getName() + " - launched tasks: ").append(executedTasksCount).append(", not launched tasks: ").append(executablesLog.size());
        if (executablesLog.size() > 0) {
            log.append(":\n\t").append(String.join((CharSequence)"\n\t", executablesLog));
        }
        StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, log.toString());
    }

    public String getInfoAsString() {
        StringBuffer log = new StringBuffer("");
        Collection<TaskAbst<?, ?>> tasksQueue = this.tasksQueue;
        if (!tasksQueue.isEmpty()) {
            log.append("\n\n");
            log.append(StaticComponentContainer.Strings.compile("{} - Tasks to be executed:", this.tasksLauncher));
            for (TaskAbst<?, ?> task : tasksQueue) {
                log.append("\n" + task.getInfoAsString());
            }
        }
        if (!(tasksQueue = this.tasksInExecution).isEmpty()) {
            log.append("\n\n");
            log.append(StaticComponentContainer.Strings.compile("{} - Tasks in execution:", this.tasksLauncher));
            for (TaskAbst<?, ?> task : tasksQueue) {
                log.append("\n" + task.getInfoAsString());
            }
        }
        return log.toString();
    }

    public void logInfo() {
        String message = this.getInfoAsString();
        if (!message.isEmpty()) {
            StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, message);
        }
    }

    @Override
    public void close() {
        this.shutDown(true);
    }

    void closeResources() {
        this.threadSupplier = null;
        this.tasksQueue = null;
        this.tasksInExecution = null;
        this.initializer = null;
        this.terminated = null;
        this.supended = null;
        this.resumeCallerMutex = null;
        this.executingFinishedWaiterMutex = null;
        this.suspensionCallerMutex = null;
        this.executableCollectionFillerMutex = null;
        StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "All resources of '{}' have been closed", this.name);
        this.name = null;
    }

    public static abstract class ProducerTask<T>
    extends TaskAbst<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, ProducerTask<T>> {
        private T result;

        ProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable, boolean creationTracking) {
            super(executable, creationTracking);
        }

        @Override
        void execute0() throws Throwable {
            this.result = ((ThrowingFunction)this.executable).apply(this);
        }

        public T join() {
            return this.join(false);
        }

        public T join(boolean ignoreDeadLocked) {
            this.waitForFinish(ignoreDeadLocked);
            return this.result;
        }

        public T get() {
            return this.result;
        }
    }

    public static abstract class Task
    extends TaskAbst<ThrowingConsumer<Task, ? extends Throwable>, Task> {
        Task(ThrowingConsumer<Task, ? extends Throwable> executable, boolean creationTracking) {
            super(executable, creationTracking);
        }

        @Override
        void execute0() throws Throwable {
            ((ThrowingConsumer)this.executable).accept(this);
        }
    }

    public static abstract class TaskAbst<E, T extends TaskAbst<E, T>>
    implements ManagedLogger {
        String name;
        StackTraceElement[] stackTraceOnCreation;
        List<StackTraceElement> creatorInfos;
        Supplier<Boolean> hasBeenExecutedChecker;
        volatile boolean probablyDeadLocked;
        volatile boolean runOnlyOnce;
        volatile String id;
        volatile int priority;
        volatile Long startTime;
        volatile boolean submitted;
        volatile boolean aborted;
        volatile boolean finished;
        volatile boolean queueConsumerUnlockingRequested;
        E executable;
        Thread executor;
        Throwable exc;
        ThrowingBiPredicate<T, Throwable, Throwable> exceptionHandler;
        QueuedTasksExecutor queuedTasksExecutor;

        public TaskAbst(E executable, boolean creationTracking) {
            this.executable = executable;
            if (creationTracking) {
                this.stackTraceOnCreation = java.lang.Thread.currentThread().getStackTrace();
            }
        }

        T start() {
            this.executor.start();
            return (T)this;
        }

        public List<StackTraceElement> getCreatorInfos() {
            if (this.creatorInfos == null) {
                if (this.stackTraceOnCreation != null) {
                    this.creatorInfos = Collections.unmodifiableList(StaticComponentContainer.Methods.retrieveExternalCallersInfo(this.stackTraceOnCreation, (clientMethodSTE, currentIteratedSTE) -> !currentIteratedSTE.getClassName().startsWith(QueuedTasksExecutor.class.getName()), -1));
                } else {
                    StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Tasks creation tracking was disabled when {} was created", this);
                }
            }
            return this.creatorInfos;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public T setName(String name) {
            this.name = name;
            return (T)this;
        }

        public T setExceptionHandler(ThrowingBiPredicate<T, Throwable, Throwable> exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
            return (T)this;
        }

        public boolean isStarted() {
            return this.startTime != null;
        }

        public boolean hasFinished() {
            return this.finished;
        }

        public T runOnlyOnce(String id, Supplier<Boolean> hasBeenExecutedChecker) {
            if (this.isSubmitted()) {
                StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is submitted"), new Object[0]);
            }
            this.runOnlyOnce = true;
            this.id = id;
            this.hasBeenExecutedChecker = hasBeenExecutedChecker;
            return (T)this;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public boolean isSubmitted() {
            return this.submitted;
        }

        public boolean isProbablyDeadLocked() {
            return this.probablyDeadLocked;
        }

        synchronized void markAsProbablyDeadLocked() {
            this.probablyDeadLocked = true;
        }

        public T waitForStarting() {
            return this.waitForStarting(false, 0L);
        }

        public T waitForStarting(long timeout) {
            return this.waitForStarting(false, timeout);
        }

        public T waitForStarting(boolean ignoreDeadLocked) {
            return this.waitForStarting(ignoreDeadLocked, 0L);
        }

        public T waitForStarting(boolean ignoreDeadLocked, long timeout) {
            if (timeout <= 0L) {
                while (this.waitForStarting0(ignoreDeadLocked, 0L)) {
                }
                return (T)this;
            }
            long timeAtStartWaiting = System.currentTimeMillis();
            while (this.waitForStarting0(ignoreDeadLocked, timeout) && System.currentTimeMillis() - timeAtStartWaiting < timeout) {
            }
            return (T)this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForStarting0(boolean ignoreDeadLocked, long timeout) {
            java.lang.Thread currentThread = java.lang.Thread.currentThread();
            if (currentThread == this.executor) {
                return false;
            }
            if (this.isSubmitted()) {
                if (!this.isStarted()) {
                    TaskAbst taskAbst = this;
                    synchronized (taskAbst) {
                        if (!this.isStarted()) {
                            try {
                                if (this.probablyDeadLocked) {
                                    if (ignoreDeadLocked) {
                                        return false;
                                    }
                                    StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "could be dead locked"), new Object[0]);
                                }
                                if (this.isAborted()) {
                                    StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is aborted"), new Object[0]);
                                }
                                this.wait(timeout);
                                return true;
                            }
                            catch (InterruptedException exc) {
                                StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
                            }
                        }
                    }
                }
            } else {
                StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is not submitted"), new Object[0]);
            }
            return false;
        }

        public T waitForFinish() {
            return this.waitForFinish(false);
        }

        public T waitForFinish(long timeout) {
            return this.waitForFinish(false, timeout);
        }

        public T waitForFinish(boolean ignoreDeadLocked) {
            return this.waitForFinish(ignoreDeadLocked, 0L);
        }

        public T waitForFinish(boolean ignoreDeadLocked, long timeout) {
            if (timeout <= 0L) {
                while (this.waitForFinish0(ignoreDeadLocked, 0L)) {
                }
                return (T)this;
            }
            long timeAtStartWaiting = System.currentTimeMillis();
            while (this.waitForFinish0(ignoreDeadLocked, timeout) && System.currentTimeMillis() - timeAtStartWaiting < timeout) {
            }
            return (T)this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForFinish0(boolean ignoreDeadLocked, long timeout) {
            java.lang.Thread currentThread = java.lang.Thread.currentThread();
            if (currentThread == this.executor) {
                return false;
            }
            if (this.isSubmitted()) {
                if (!this.hasFinished()) {
                    TaskAbst taskAbst = this;
                    synchronized (taskAbst) {
                        if (!this.hasFinished()) {
                            try {
                                if (this.probablyDeadLocked) {
                                    if (ignoreDeadLocked) {
                                        return false;
                                    }
                                    StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "could be dead locked"), new Object[0]);
                                }
                                if (this.isAborted()) {
                                    StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is aborted"), new Object[0]);
                                }
                                this.wait(timeout);
                                return true;
                            }
                            catch (InterruptedException exc) {
                                StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
                            }
                        }
                    }
                }
            } else {
                StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is not submitted"), new Object[0]);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            try {
                try {
                    TaskAbst taskAbst = this;
                    synchronized (taskAbst) {
                        if (this.aborted) {
                            this.notifyAll();
                            this.clear();
                            return;
                        }
                    }
                    this.preparingToExecute();
                    taskAbst = this;
                    synchronized (taskAbst) {
                        this.notifyAll();
                    }
                }
                catch (Throwable exc) {
                    this.exc = exc;
                    this.startTime = null;
                    if (this.exceptionHandler == null || !this.exceptionHandler.test(this, exc)) {
                        throw exc;
                    }
                    this.forceAbort();
                    return;
                }
            }
            catch (Throwable exc) {
                this.logException(exc);
                this.forceAbort();
                return;
            }
            try {
                try {
                    this.execute0();
                }
                catch (Throwable exc) {
                    this.exc = exc;
                    if (this.exceptionHandler == null || !this.exceptionHandler.test(this, exc)) {
                        throw exc;
                    }
                }
            }
            catch (Throwable exc) {
                this.logException(exc);
            }
            finally {
                this.markAsFinished();
            }
        }

        private synchronized void forceAbort() {
            this.aborted = true;
            this.notifyAll();
            this.clear();
        }

        String getInfoAsString() {
            if (this.getCreatorInfos() != null) {
                Thread executor = this.executor;
                return StaticComponentContainer.Strings.compile("\n\tTask hash code: {}\n\tTask status: {} {} \n\tcreated by: {}", this.hashCode(), StaticComponentContainer.Strings.compile("\n\t\tpriority: {}\n\t\tstarted: {}\n\t\taborted: {}\n\t\tfinished: {}", this.priority, this.isStarted(), this.isAborted(), this.hasFinished()), executor != null ? "\n\t" + executor + StaticComponentContainer.Strings.from(executor.getStackTrace(), 2) : "", StaticComponentContainer.Strings.from(this.getCreatorInfos(), 2));
            }
            return "";
        }

        public void logInfo() {
            if (this.getCreatorInfos() != null) {
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, this.getInfoAsString());
            }
        }

        public void logException() {
            this.logException(this.exc);
        }

        private void logException(Throwable exc) {
            StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, StaticComponentContainer.Strings.compile("Exception occurred while executing {}: \n{}: {}{}{}", this, exc.toString(), exc.getMessage(), StaticComponentContainer.Strings.from(exc.getStackTrace()), this.getCreatorInfos() != null ? "\nthat was created:" + StaticComponentContainer.Strings.from(this.getCreatorInfos()) : ""));
        }

        void clear() {
            this.remove();
            this.executable = null;
            this.executor = null;
            this.queuedTasksExecutor = null;
        }

        private void remove() {
            QueuedTasksExecutor queuedTasksExecutor = this.getQueuedTasksExecutor();
            queuedTasksExecutor.tasksInExecution.remove(this);
            if (this.runOnlyOnce) {
                runOnlyOnceTasksToBeExecuted.remove(this.id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markAsFinished() {
            try {
                this.finished = true;
                QueuedTasksExecutor queuedTasksExecutor = this.getQueuedTasksExecutor();
                queuedTasksExecutor.tasksInExecution.remove(this);
                ++queuedTasksExecutor.executedTasksCount;
            }
            finally {
                TaskAbst taskAbst = this;
                synchronized (taskAbst) {
                    this.notifyAll();
                }
                if (this.runOnlyOnce) {
                    runOnlyOnceTasksToBeExecuted.remove(this.id);
                }
            }
        }

        abstract void execute0() throws Throwable;

        T setExecutor(Thread thread) {
            this.executor = thread.setExecutable(thr -> this.execute());
            this.executor.setPriority(this.priority);
            QueuedTasksExecutor queuedTasksExecutor = this.getQueuedTasksExecutor();
            if (this.name != null) {
                this.executor.setName(queuedTasksExecutor.name + " - " + this.name);
            } else {
                this.executor.setIndexedName(queuedTasksExecutor.name + " executor");
            }
            return (T)this;
        }

        public T changePriority(int priority) {
            this.priority = priority;
            if (this.executor != null) {
                this.executor.setPriority(this.priority);
            }
            return (T)this;
        }

        public T setPriorityToCurrentThreadPriority() {
            return this.changePriority(java.lang.Thread.currentThread().getPriority());
        }

        public int getPriority() {
            return this.priority;
        }

        public Throwable getException() {
            return this.exc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T submit() {
            if (this.aborted) {
                StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is aborted"), new Object[0]);
            }
            if (!this.submitted) {
                TaskAbst taskAbst = this;
                synchronized (taskAbst) {
                    if (!this.submitted) {
                        this.submitted = true;
                    } else {
                        StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is already submitted"), new Object[0]);
                    }
                }
            } else {
                StaticComponentContainer.Driver.throwException((Object)new TaskStateException(this, "is already submitted"), new Object[0]);
            }
            return this.addToQueue();
        }

        T addToQueue() {
            return (T)this.getQueuedTasksExecutor().addToQueue(this, false);
        }

        void preparingToExecute() {
            this.queuedTasksExecutor = this.getQueuedTasksExecutor();
            this.startTime = System.currentTimeMillis();
            this.queuedTasksExecutor.tasksInExecution.add(this);
        }

        public T abortOrWaitForFinish() {
            return this.abortOrWaitForFinish(false);
        }

        public T abortOrWaitForFinish(boolean ignoreDeadLocked) {
            if (!((TaskAbst)this.abort()).isAborted() && this.isStarted()) {
                this.waitForFinish(ignoreDeadLocked);
            }
            return (T)this;
        }

        public T abort() {
            this.getQueuedTasksExecutor().abort(this);
            return (T)this;
        }

        abstract QueuedTasksExecutor getQueuedTasksExecutor();

        abstract QueuedTasksExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread var1);
    }

    public static class Group
    implements Identifiable {
        String name;
        Map<Integer, QueuedTasksExecutor> queuedTasksExecutors;
        TasksMonitorer allTasksMonitorer;
        Consumer<Group> initializator = queuedTasksExecutorGroup -> {
            String name = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("name").on(configuration));
            Thread.Supplier mainThreadSupplier = (Thread.Supplier)configuration.get("thread-supplier");
            Boolean isDaemon = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("daemon").on(configuration)));
            queuedTasksExecutorGroup.name = name;
            HashMap<Integer, QueuedTasksExecutor> queuedTasksExecutors = new HashMap<Integer, QueuedTasksExecutor>();
            for (int i = 0; i < 10; ++i) {
                Object priorityAsObject = StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queue-task-executor[" + i + "].priority").on(configuration));
                if (priorityAsObject == null) continue;
                int priority = StaticComponentContainer.Objects.toInt(priorityAsObject);
                if (priority < 1 || priority > 10) {
                    throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Value of '{}' is not correct: it must be between {} and {}", "queue-task-executor[" + i + "].priority", 1, 10));
                }
                String queuedTasksExecutorName = StaticComponentContainer.IterableObjectHelper.resolveStringValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queue-task-executor[" + i + "].name").on(configuration));
                Thread.Supplier queuedTasksExecutorThreadSupplier = (Thread.Supplier)StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queue-task-executor[" + i + "].thread-supplier").on(configuration));
                if (queuedTasksExecutorThreadSupplier == null) {
                    queuedTasksExecutorThreadSupplier = mainThreadSupplier;
                }
                Object isQueuedTasksExecutorDaemonAsObject = StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey("queue-task-executor[" + i + "].daemon").on(configuration));
                Boolean isQueuedTasksExecutorDaemon = isDaemon;
                if (isQueuedTasksExecutorDaemonAsObject != null) {
                    isQueuedTasksExecutorDaemon = StaticComponentContainer.Objects.toBoolean(isQueuedTasksExecutorDaemonAsObject);
                }
                queuedTasksExecutors.put(priority, this.createQueuedTasksExecutor(name + " - " + queuedTasksExecutorName, queuedTasksExecutorThreadSupplier, priority, isQueuedTasksExecutorDaemon));
            }
            this.definedPriorites = new Integer[queuedTasksExecutors.size()];
            this.definedPriorites = queuedTasksExecutors.keySet().toArray(this.definedPriorites);
            this.queuedTasksExecutors = queuedTasksExecutors;
        };
        Integer[] definedPriorites;

        Group(Map<String, Object> configuration) {
        }

        public Group setTasksCreationTrackingFlag(boolean flag) {
            if (this.initializator == null) {
                this.setTasksCreationTrackingFlag(this, flag);
            } else {
                this.initializator = this.initializator.andThen(queuedTasksExecutorGroup -> this.setTasksCreationTrackingFlag((Group)queuedTasksExecutorGroup, flag));
            }
            return this;
        }

        private void setTasksCreationTrackingFlag(Group queuedTasksExecutorGroup, boolean flag) {
            for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : queuedTasksExecutorGroup.queuedTasksExecutors.entrySet()) {
                queuedTasksExecutorBox.getValue().setTasksCreationTrackingFlag(flag);
            }
        }

        public Group startAllTasksMonitoring(TasksMonitorer.Config config) {
            if (this.initializator == null) {
                this.startAllTasksMonitoring(this, config);
            } else {
                this.initializator = this.initializator.andThen(queuedTasksExecutorGroup -> this.startAllTasksMonitoring(this, config));
            }
            return this;
        }

        void startAllTasksMonitoring(Group queuedTasksExecutorGroup, TasksMonitorer.Config config) {
            TasksMonitorer allTasksMonitorer = queuedTasksExecutorGroup.allTasksMonitorer;
            if (allTasksMonitorer != null) {
                allTasksMonitorer.close();
            }
            queuedTasksExecutorGroup.allTasksMonitorer = new TasksMonitorer(queuedTasksExecutorGroup, config).start();
        }

        public static Group create(String keyPrefix, Map<String, Object> configuration) {
            configuration = StaticComponentContainer.IterableObjectHelper.resolveValues((IterableObjectHelper.ResolveConfig.ForAllKeysThat)IterableObjectHelper.ResolveConfig.forAllKeysThat(key -> key.startsWith(keyPrefix + ".")).on(configuration));
            HashMap<String, Object> finalConfiguration = new HashMap<String, Object>();
            boolean undestroyableFromExternal = StaticComponentContainer.Objects.toBoolean(StaticComponentContainer.IterableObjectHelper.resolveValue((IterableObjectHelper.ResolveConfig.ForNamedKey)IterableObjectHelper.ResolveConfig.forNamedKey(keyPrefix + ".undestroyable-from-external").on(configuration)));
            for (Map.Entry<String, Object> entry : configuration.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof Collection && ((Collection)value).size() == 1) {
                    value = ((Collection)value).iterator().next();
                }
                finalConfiguration.put(entry.getKey().replace(keyPrefix + ".", ""), value);
            }
            if (!undestroyableFromExternal) {
                return new Group(finalConfiguration);
            }
            return new Group(finalConfiguration){
                StackTraceElement[] stackTraceOnCreation = Thread.currentThread().getStackTrace();

                @Override
                public boolean shutDown(boolean waitForTasksTermination) {
                    if (StaticComponentContainer.Methods.retrieveExternalCallerInfo().getClassName().equals(StaticComponentContainer.Methods.retrieveExternalCallerInfo(this.stackTraceOnCreation).getClassName())) {
                        return super.shutDown(waitForTasksTermination);
                    }
                    return false;
                }
            };
        }

        public <T> ProducerTask<T> createProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable) {
            return this.createProducerTask(executable, java.lang.Thread.currentThread().getPriority());
        }

        public <T> ProducerTask<T> createProducerTask(ThrowingFunction<ProducerTask<T>, T, ? extends Throwable> executable, int priority) {
            return this.getByPriority(priority).createProducerTask(executable);
        }

        QueuedTasksExecutor getByPriority(int priority) {
            QueuedTasksExecutor queuedTasksExecutor = null;
            try {
                queuedTasksExecutor = this.queuedTasksExecutors.get(priority);
            }
            catch (NullPointerException exc) {
                if (this.queuedTasksExecutors == null && this.initializator != null) {
                    StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                        if (this.initializator != null) {
                            this.initializator.accept(this);
                            this.initializator = null;
                        }
                    });
                }
                queuedTasksExecutor = this.queuedTasksExecutors.get(priority);
            }
            if (queuedTasksExecutor == null) {
                queuedTasksExecutor = this.queuedTasksExecutors.get(this.checkAndCorrectPriority(priority));
            }
            return queuedTasksExecutor;
        }

        int checkAndCorrectPriority(int priority) {
            if (this.queuedTasksExecutors.get(priority) != null) {
                return priority;
            }
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException(StaticComponentContainer.Strings.compile("Priority value must be between {} and {}", 1, 10));
            }
            Integer currentMaxPriorityHandled = this.definedPriorites[this.definedPriorites.length - 1];
            if (priority > currentMaxPriorityHandled) {
                return currentMaxPriorityHandled;
            }
            for (Integer definedPriorite : this.definedPriorites) {
                if (priority >= definedPriorite) continue;
                return definedPriorite;
            }
            return this.definedPriorites[this.definedPriorites.length - 1];
        }

        public Task createTask(ThrowingConsumer<Task, ? extends Throwable> executable) {
            return this.createTask(executable, java.lang.Thread.currentThread().getPriority());
        }

        public Task createTask(ThrowingConsumer<Task, ? extends Throwable> executable, int priority) {
            return this.getByPriority(priority).createTask(executable);
        }

        QueuedTasksExecutor createQueuedTasksExecutor(String executorName, Thread.Supplier threadSupplier, int priority, boolean isDaemon) {
            return new QueuedTasksExecutor(executorName, threadSupplier, priority, isDaemon){

                @Override
                <T> Function<ThrowingFunction<ProducerTask<T>, T, ? extends Throwable>, ProducerTask<T>> getProducerTaskSupplier() {
                    return executable -> new ProducerTask<T>((ThrowingFunction)executable, this.taskCreationTrackingEnabled){

                        @Override
                        QueuedTasksExecutor getQueuedTasksExecutor() {
                            return this.queuedTasksExecutor != null ? this.queuedTasksExecutor : this.getByPriority(this.priority);
                        }

                        @Override
                        public ProducerTask<T> changePriority(int priority) {
                            this.changePriority(this, priority);
                            return this;
                        }

                        @Override
                        QueuedTasksExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                            return this.getByPriority(thread.getPriority());
                        }
                    };
                }

                @Override
                <T> Function<ThrowingConsumer<Task, ? extends Throwable>, Task> getTaskSupplier() {
                    return executable -> new Task((ThrowingConsumer)executable, this.taskCreationTrackingEnabled){

                        @Override
                        QueuedTasksExecutor getQueuedTasksExecutor() {
                            return this.queuedTasksExecutor != null ? this.queuedTasksExecutor : this.getByPriority(this.priority);
                        }

                        @Override
                        public Task changePriority(int priority) {
                            this.changePriority(this, priority);
                            return this;
                        }

                        @Override
                        QueuedTasksExecutor retrieveQueuedTasksExecutorOf(java.lang.Thread thread) {
                            return this.getByPriority(thread.getPriority());
                        }
                    };
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public QueuedTasksExecutor waitForTasksEnding(int priority, boolean ignoreDeadLocked) {
                    if (priority == this.defaultPriority) {
                        if (!this.tasksQueue.isEmpty()) {
                            Object object = this.executingFinishedWaiterMutex;
                            synchronized (object) {
                                if (!this.tasksQueue.isEmpty()) {
                                    try {
                                        this.executingFinishedWaiterMutex.wait();
                                    }
                                    catch (InterruptedException exc) {
                                        StaticComponentContainer.ManagedLoggersRepository.logError(this.getClass()::getName, exc);
                                    }
                                }
                            }
                        }
                        this.tasksInExecution.stream().forEach(task -> task.waitForFinish(ignoreDeadLocked));
                    } else {
                        this.tasksQueue.stream().forEach(executable -> executable.changePriority(priority));
                        this.waitForTasksInExecutionEnding(priority, ignoreDeadLocked);
                    }
                    return this;
                }

                @Override
                public <E, T extends TaskAbst<E, T>> QueuedTasksExecutor waitFor(T task, int priority, boolean ignoreDeadLocked) {
                    task.waitForFinish(ignoreDeadLocked);
                    return this;
                }

                @Override
                Task createSuspendingTask(int priority) {
                    return this.createTask(task -> {
                        this.supended = Boolean.TRUE;
                    });
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <E, T extends TaskAbst<E, T>> Group changePriority(T task, int priority) {
            int oldPriority = task.priority;
            int newPriority = this.checkAndCorrectPriority(priority);
            if (oldPriority != priority) {
                T t = task;
                synchronized (t) {
                    if (this.getByPriority((int)oldPriority).tasksQueue.remove(task)) {
                        task.priority = newPriority;
                        QueuedTasksExecutor queuedTasksExecutor = this.getByPriority(newPriority);
                        task.queuedTasksExecutor = null;
                        task.executor = null;
                        queuedTasksExecutor.addToQueue(task, true);
                    }
                }
            }
            return this;
        }

        public boolean isClosed() {
            return this.queuedTasksExecutors == null;
        }

        public Group waitForTasksEnding() {
            return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), false, false);
        }

        public Group waitForTasksEnding(boolean ignoreDeadLocked) {
            return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), false, ignoreDeadLocked);
        }

        public Group waitForTasksEnding(boolean waitForNewAddedTasks, boolean ignoreDeadLocked) {
            return this.waitForTasksEnding(java.lang.Thread.currentThread().getPriority(), waitForNewAddedTasks, ignoreDeadLocked);
        }

        public Group waitForTasksEnding(int priority, boolean waitForNewAddedTasks, boolean ignoreDeadLocked) {
            StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                QueuedTasksExecutor queuedTasksExecutor;
                if (this.initializator != null) {
                    return;
                }
                QueuedTasksExecutor lastToBeWaitedFor = this.getByPriority(priority);
                for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                    queuedTasksExecutor = queuedTasksExecutorBox.getValue();
                    if (queuedTasksExecutor == lastToBeWaitedFor) continue;
                    queuedTasksExecutor.waitForTasksEnding(priority, waitForNewAddedTasks, ignoreDeadLocked);
                }
                lastToBeWaitedFor.waitForTasksEnding(priority, waitForNewAddedTasks);
                for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                    queuedTasksExecutor = queuedTasksExecutorBox.getValue();
                    if (!waitForNewAddedTasks || queuedTasksExecutor.tasksQueue.isEmpty() && queuedTasksExecutor.tasksInExecution.isEmpty()) continue;
                    this.waitForTasksEnding(priority, waitForNewAddedTasks, ignoreDeadLocked);
                    break;
                }
            });
            return this;
        }

        public <E, T extends TaskAbst<E, T>> Group waitFor(T task, boolean ignoreDeadLocked) {
            return this.waitFor(task, java.lang.Thread.currentThread().getPriority(), ignoreDeadLocked);
        }

        public <E, T extends TaskAbst<E, T>> Group waitFor(T task, int priority, boolean ignoreDeadLocked) {
            if (task.getPriority() != priority) {
                task.changePriority(priority);
            }
            task.waitForFinish(ignoreDeadLocked);
            return this;
        }

        public Group logInfo() {
            String loggableMessage = this.getInfoAsString();
            loggableMessage = this.getInfoAsString();
            if (!loggableMessage.isEmpty()) {
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, loggableMessage);
            }
            return this;
        }

        public String getInfoAsString() {
            StringBuffer loggableMessage = new StringBuffer("");
            for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                loggableMessage.append(queuedTasksExecutorBox.getValue().getInfoAsString());
            }
            return loggableMessage.toString();
        }

        public <E, T extends TaskAbst<E, T>> boolean abort(T task) {
            for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                if (!queuedTasksExecutorBox.getValue().abort(task)) continue;
                return true;
            }
            return false;
        }

        public Collection<TaskAbst<?, ?>> getAllTasksInExecution() {
            HashSet tasksInExecution = new HashSet();
            for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                tasksInExecution.addAll(queuedTasksExecutorBox.getValue().tasksInExecution);
            }
            return tasksInExecution;
        }

        public Group startAllTasksMonitoring() {
            TasksMonitorer allTasksMonitorer = this.allTasksMonitorer;
            if (allTasksMonitorer != null) {
                allTasksMonitorer.start();
                return this;
            }
            return (Group)StaticComponentContainer.Driver.throwException((Object)"All tasks monitorer has not been configured", new Object[0]);
        }

        public Group stopAllTasksMonitoring() {
            TasksMonitorer allTasksMonitorer = this.allTasksMonitorer;
            if (allTasksMonitorer != null) {
                allTasksMonitorer.stop();
            }
            return this;
        }

        public boolean shutDown(boolean waitForTasksTermination) {
            StaticComponentContainer.Synchronizer.execute(this.getOperationId("initialization"), () -> {
                if (this.initializator != null) {
                    this.initializator = null;
                    return;
                }
                QueuedTasksExecutor lastToBeWaitedFor = this.getByPriority(java.lang.Thread.currentThread().getPriority());
                for (Map.Entry<Integer, QueuedTasksExecutor> queuedTasksExecutorBox : this.queuedTasksExecutors.entrySet()) {
                    QueuedTasksExecutor queuedTasksExecutor = queuedTasksExecutorBox.getValue();
                    if (queuedTasksExecutor == lastToBeWaitedFor) continue;
                    queuedTasksExecutor.shutDown(waitForTasksTermination);
                }
                lastToBeWaitedFor.shutDown(waitForTasksTermination);
                this.allTasksMonitorer.close(waitForTasksTermination);
                this.allTasksMonitorer = null;
                this.queuedTasksExecutors.clear();
                this.queuedTasksExecutors = null;
            });
            return true;
        }

        public static class TasksMonitorer
        implements Closeable,
        ManagedLogger {
            Map<TaskAbst<?, ?>, StackTraceElement[]> waitingTasksAndLastStackTrace = new HashMap();
            Group queuedTasksExecutorGroup;
            Config config;

            TasksMonitorer(Group queuedTasksExecutorGroup, Config config) {
                this.queuedTasksExecutorGroup = queuedTasksExecutorGroup;
                this.config = config;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void checkAndHandleProbableDeadLockedTasks(long minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked, boolean markAsProbableDeadLocked, boolean killProbableDeadLockedTasks) {
                Iterator<Map.Entry<TaskAbst<?, ?>, StackTraceElement[]>> tasksAndStackTracesIterator = this.waitingTasksAndLastStackTrace.entrySet().iterator();
                while (tasksAndStackTracesIterator.hasNext()) {
                    TaskAbst<?, ?> task = tasksAndStackTracesIterator.next().getKey();
                    if (!task.hasFinished() && !task.isAborted()) continue;
                    tasksAndStackTracesIterator.remove();
                }
                long currentTime = System.currentTimeMillis();
                for (TaskAbst<?, ?> task : this.queuedTasksExecutorGroup.getAllTasksInExecution()) {
                    Thread taskThread;
                    if (currentTime - task.startTime <= minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked || (taskThread = task.executor) == null || !taskThread.getState().equals((Object)Thread.State.BLOCKED) && !taskThread.getState().equals((Object)Thread.State.WAITING) && !taskThread.getState().equals((Object)Thread.State.TIMED_WAITING)) continue;
                    StackTraceElement[] previousRegisteredStackTrace = this.waitingTasksAndLastStackTrace.get(task);
                    StackTraceElement[] currentStackTrace = taskThread.getStackTrace();
                    if (previousRegisteredStackTrace != null) {
                        if (this.areStrackTracesEquals(previousRegisteredStackTrace, currentStackTrace)) {
                            if (task.hasFinished() || task.isAborted()) continue;
                            if (markAsProbableDeadLocked) {
                                task.markAsProbablyDeadLocked();
                                taskThread.setName("PROBABLE DEAD-LOCKED THREAD -> " + taskThread.getName());
                            }
                            if (markAsProbableDeadLocked || killProbableDeadLockedTasks) {
                                ((TaskAbst)task).remove();
                            }
                            if (killProbableDeadLockedTasks && task.hasFinished()) {
                                task.aborted = true;
                                taskThread.interrupt();
                            }
                            if (markAsProbableDeadLocked || killProbableDeadLockedTasks) {
                                TaskAbst<?, ?> taskAbst = task;
                                synchronized (taskAbst) {
                                    task.notifyAll();
                                }
                            }
                            StaticComponentContainer.ManagedLoggersRepository.logWarn(() -> this.getClass().getName(), "Possible deadlock detected for task:{}\n\t{}", task.getInfoAsString(), StaticComponentContainer.Synchronizer.getAllThreadsInfoAsString(true));
                            StaticComponentContainer.Synchronizer.logAllThreadsState(true);
                            continue;
                        }
                        this.waitingTasksAndLastStackTrace.put(task, currentStackTrace);
                        continue;
                    }
                    this.waitingTasksAndLastStackTrace.put(task, currentStackTrace);
                }
            }

            private boolean areStrackTracesEquals(StackTraceElement[] stackTraceOne, StackTraceElement[] stackTraceTwo) {
                if (stackTraceOne.length == stackTraceTwo.length) {
                    for (int i = 0; i < stackTraceOne.length; ++i) {
                        if (stackTraceOne[i].toString().equals(stackTraceTwo[i].toString())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }

            private String getName() {
                return Optional.ofNullable(this.queuedTasksExecutorGroup.name).map(nm -> nm + " - ").orElseGet(() -> "") + "All tasks monitorer";
            }

            public TasksMonitorer start() {
                StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), "Starting {}", this.getName());
                StaticComponentContainer.ThreadHolder.startLooping(this.getName(), true, 1, thread -> {
                    thread.waitFor(this.config.getInterval());
                    if (thread.isLooping()) {
                        if (this.config.isAllTasksLoggerEnabled()) {
                            this.queuedTasksExecutorGroup.logInfo();
                        }
                        try {
                            this.checkAndHandleProbableDeadLockedTasks(this.config.getMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked(), this.config.isMarkAsProablyDeadLockedEnabled(), this.config.isKillProablyDeadLockedTasksEnabled());
                        }
                        catch (Throwable exc) {
                            StaticComponentContainer.ManagedLoggersRepository.logError(() -> this.getClass().getName(), "Exception occurred while checking dead locked tasks", exc);
                        }
                    }
                });
                return this;
            }

            public void stop() {
                this.stop(false);
            }

            public void stop(boolean waitThreadToFinish) {
                StaticComponentContainer.ManagedLoggersRepository.logInfo(() -> this.getClass().getName(), "Starting {}", this.getName());
                StaticComponentContainer.ThreadHolder.stop(this.getName());
            }

            @Override
            public void close() {
                this.close(false);
            }

            public void close(boolean waitForTasksTermination) {
                this.stop(waitForTasksTermination);
                this.queuedTasksExecutorGroup = null;
                this.waitingTasksAndLastStackTrace.clear();
                this.waitingTasksAndLastStackTrace = null;
            }

            public static class Config {
                private long interval;
                private long minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked;
                private boolean markAsProbableDeadLocked;
                private boolean killProbableDeadLockedTasks;
                private boolean allTasksLoggerEnabled;

                public long getInterval() {
                    return this.interval;
                }

                public Config setInterval(long interval) {
                    this.interval = interval;
                    return this;
                }

                public long getMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked() {
                    return this.minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked;
                }

                public Config setMinimumElapsedTimeToConsiderATaskAsProbablyDeadLocked(long minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked) {
                    this.minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked = minimumElapsedTimeToConsiderATaskAsProbablyDeadLocked;
                    return this;
                }

                public boolean isMarkAsProablyDeadLockedEnabled() {
                    return this.markAsProbableDeadLocked;
                }

                public Config setMarkAsProbableDeadLocked(boolean markAsProablyDeadLocked) {
                    this.markAsProbableDeadLocked = markAsProablyDeadLocked;
                    return this;
                }

                public boolean isKillProablyDeadLockedTasksEnabled() {
                    return this.killProbableDeadLockedTasks;
                }

                public Config setKillProbableDeadLockedTasks(boolean killProablyDeadLockedTasks) {
                    this.killProbableDeadLockedTasks = killProablyDeadLockedTasks;
                    return this;
                }

                public boolean isAllTasksLoggerEnabled() {
                    return this.allTasksLoggerEnabled;
                }

                public Config setAllTasksLoggerEnabled(boolean allTasksLoggerEnabled) {
                    this.allTasksLoggerEnabled = allTasksLoggerEnabled;
                    return this;
                }
            }
        }
    }
}

