/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.burningwave.core.Closeable;
import org.burningwave.core.ManagedLogger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.io.FileSystemItem;

public class SearchConfig
implements Closeable,
ManagedLogger {
    Function<ClassLoader, Map.Entry<ClassLoader, Collection<FileSystemItem>>> pathsSupplier = classLoader -> new AbstractMap.SimpleEntry((ClassLoader)classLoader, ConcurrentHashMap.newKeySet());
    Function<FileSystemItem, FileSystemItem.Find> findFunctionSupplier;
    Predicate<FileSystemItem> refreshPathIf;
    Boolean fileFiltersExtenallySet;
    Function<FileSystemItem, FileSystemItem.Criteria> fileFilterSupplier;
    Function<FileSystemItem, FileSystemItem.Criteria> additionalFileFilterSupplier;
    ClassCriteria classCriteria;
    Supplier<Collection<FileSystemItem>> pathsRetriever;
    SearchContext<?> searchContext;
    boolean useDefaultPathScannerClassLoader;
    boolean useDefaultPathScannerClassLoaderAsParent;
    ClassLoader parentClassLoaderForPathScannerClassLoader;
    PathScannerClassLoader pathScannerClassLoader;
    Predicate<Collection<?>> minimumCollectionSizeForParallelIterationPredicate;
    boolean waitForSearchEnding;
    Integer priority;
    boolean optimizePaths;

    SearchConfig() {
        this.useDefaultPathScannerClassLoader(true);
        this.waitForSearchEnding = true;
        this.classCriteria = ClassCriteria.create();
        this.findFunctionSupplier = fileSystemItem -> FileSystemItem.Find.IN_ALL_CHILDREN;
    }

    public static SearchConfig create() {
        return new SearchConfig();
    }

    @SafeVarargs
    public static SearchConfig forPaths(Collection<String> ... pathsColl) {
        return new SearchConfig().addPaths(pathsColl);
    }

    @SafeVarargs
    public static SearchConfig forFileSystemItems(Collection<FileSystemItem> ... pathsColl) {
        return new SearchConfig().addFileSystemItems(pathsColl);
    }

    @SafeVarargs
    public static SearchConfig forPaths(String ... paths) {
        return SearchConfig.forPaths(Stream.of(paths).collect(Collectors.toCollection(HashSet::new)));
    }

    @SafeVarargs
    public static SearchConfig forResources(String ... paths) {
        return SearchConfig.forResources(null, paths);
    }

    @SafeVarargs
    public static SearchConfig forResources(ClassLoader classLoader, String ... paths) {
        return SearchConfig.forResources(classLoader, Arrays.asList(paths));
    }

    @SafeVarargs
    public static SearchConfig forResources(Collection<String> ... pathCollections) {
        return SearchConfig.forResources(null, pathCollections);
    }

    @SafeVarargs
    public static SearchConfig forResources(ClassLoader classLoader, Collection<String> ... pathCollections) {
        return new SearchConfig().addResources(classLoader, pathCollections);
    }

    public static SearchConfig byCriteria(ClassCriteria classCriteria) {
        return SearchConfig.forPaths(new HashSet()).by(classCriteria);
    }

    public SearchConfig by(ClassCriteria classCriteria) {
        this.classCriteria = classCriteria;
        return this;
    }

    <I, C extends SearchContext<I>> C init(ClassPathScanner.Abst<I, C, ?> classPathScanner) {
        if (this.fileFilterSupplier == null) {
            this.fileFiltersExtenallySet = this.additionalFileFilterSupplier != null;
            this.fileFilterSupplier = fileSystemItem -> FileSystemItem.Criteria.forClassTypeFiles(classPathScanner.config.resolveStringValue(classPathScanner.getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties()));
        } else {
            this.fileFiltersExtenallySet = Boolean.TRUE;
        }
        PathScannerClassLoader pathScannerClassLoader = this.pathScannerClassLoader;
        PathScannerClassLoader defaultPathScannerClassLoader = classPathScanner.getDefaultPathScannerClassLoader(this);
        if (pathScannerClassLoader == null) {
            if (this.useDefaultPathScannerClassLoaderAsParent) {
                this.parentClassLoaderForPathScannerClassLoader = defaultPathScannerClassLoader;
            }
            pathScannerClassLoader = this.useDefaultPathScannerClassLoader ? defaultPathScannerClassLoader : PathScannerClassLoader.create(this.parentClassLoaderForPathScannerClassLoader, classPathScanner.pathHelper, null);
        }
        SearchContext context = (SearchContext)classPathScanner.contextSupplier.apply(SearchContext.InitContext.create(defaultPathScannerClassLoader, pathScannerClassLoader, this));
        if (this.classCriteria != null) {
            this.classCriteria.init(context.pathScannerClassLoader);
        }
        PathScannerClassLoader finalPathScannerClassLoader = pathScannerClassLoader;
        this.pathsRetriever = () -> {
            Collection<FileSystemItem> pathsToBeScanned = this.pathsSupplier.apply(finalPathScannerClassLoader).getValue();
            if (pathsToBeScanned.isEmpty()) {
                StaticComponentContainer.ManagedLoggersRepository.logInfo(this.getClass()::getName, "The input paths are not present: the search will be performed on the default configured paths");
                pathsToBeScanned.addAll(classPathScanner.pathHelper.getPaths(ClassPathScanner.Configuration.Key.DEFAULT_SEARCH_CONFIG_PATHS).stream().map(FileSystemItem::ofPath).collect(Collectors.toSet()));
            }
            if (this.optimizePaths && this.findFunctionSupplier != FileSystemItem.Find.FunctionSupplier.OF_IN_CHILDREN && !this.fileFiltersExtenallySet.booleanValue()) {
                if (this.findFunctionSupplier != FileSystemItem.Find.FunctionSupplier.OF_IN_ALL_CHILDREN && this.findFunctionSupplier != FileSystemItem.Find.FunctionSupplier.OF_RECURSIVE_IN_CHILDREN) {
                    throw new IllegalArgumentException("Could not optimize paths with custom find function supplier");
                }
                classPathScanner.pathHelper.optimizeFileSystemItems(pathsToBeScanned);
            }
            return pathsToBeScanned;
        };
        if (this.refreshPathIf == null) {
            this.refreshPathIf = fileSystemItem -> false;
        }
        this.searchContext = context;
        defaultPathScannerClassLoader.unregister(this, true);
        return (C)context;
    }

    @SafeVarargs
    public final SearchConfig addPaths(Collection<String> ... pathColls) {
        for (Collection<String> pathColl : pathColls) {
            this.pathsSupplier = this.pathsSupplier.andThen(classLoaderAndPaths -> {
                for (String absolutePath : pathColl) {
                    try {
                        ((Collection)classLoaderAndPaths.getValue()).add(FileSystemItem.ofPath(absolutePath));
                    }
                    catch (Throwable exc) {
                        throw new IllegalArgumentException("One or more of the input paths are incorrect", exc);
                    }
                }
                return classLoaderAndPaths;
            });
        }
        return this;
    }

    public SearchConfig addPaths(String ... paths) {
        return this.addPaths(Arrays.asList(paths));
    }

    @SafeVarargs
    public final SearchConfig addFileSystemItems(Collection<FileSystemItem> ... pathColls) {
        for (Collection<FileSystemItem> pathColl : pathColls) {
            this.pathsSupplier = this.pathsSupplier.andThen(classLoaderAndPaths -> {
                for (FileSystemItem absolutePath : pathColl) {
                    ((Collection)classLoaderAndPaths.getValue()).add(absolutePath);
                }
                return classLoaderAndPaths;
            });
        }
        return this;
    }

    @SafeVarargs
    public final SearchConfig addFileSystemItems(FileSystemItem ... paths) {
        return this.addFileSystemItems(Arrays.asList(paths));
    }

    @SafeVarargs
    public final SearchConfig addResources(ClassLoader classLoader, Collection<String> ... pathColls) {
        for (Collection<String> pathColl : pathColls) {
            this.pathsSupplier = this.pathsSupplier.andThen(classLoaderAndPaths -> {
                Collection<FileSystemItem> resources = StaticComponentContainer.Resources.getAsFileSystemItems(classLoader != null ? classLoader : (ClassLoader)classLoaderAndPaths.getKey(), pathColl);
                if (resources.isEmpty()) {
                    throw new IllegalArgumentException("One or more of the input resources are incorrect");
                }
                ((Collection)classLoaderAndPaths.getValue()).addAll(resources);
                return classLoaderAndPaths;
            });
        }
        return this;
    }

    @SafeVarargs
    public final SearchConfig addResources(ClassLoader classLoader, String ... paths) {
        return this.addResources(classLoader, Arrays.asList(paths));
    }

    @SafeVarargs
    public final SearchConfig addResources(String ... paths) {
        return this.addResources(Arrays.asList(paths));
    }

    @SafeVarargs
    public final SearchConfig addResources(Collection<String> ... pathCollections) {
        return this.addResources((ClassLoader)null, pathCollections);
    }

    public SearchConfig withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public SearchConfig waitForSearchEnding(boolean waitForSearchEnding) {
        this.waitForSearchEnding = waitForSearchEnding;
        return this;
    }

    public SearchConfig checkForAddedClassesForAllPathThat(Predicate<FileSystemItem> refreshIf) {
        this.refreshPathIf = this.refreshPathIf == null ? refreshIf : this.refreshPathIf.or(refreshIf);
        return this;
    }

    public SearchConfig checkForAddedClasses() {
        this.refreshPathIf = FileSystemItem2 -> true;
        return this;
    }

    public SearchConfig optimizePaths(boolean flag) {
        this.optimizePaths = flag;
        return this;
    }

    public SearchConfig setFindFunction(Function<FileSystemItem, FileSystemItem.Find> findInFunction) {
        this.findFunctionSupplier = findInFunction;
        return this;
    }

    public SearchConfig findInChildren() {
        this.findFunctionSupplier = FileSystemItem.Find.FunctionSupplier.OF_IN_CHILDREN;
        return this;
    }

    public SearchConfig findRecursiveInChildren() {
        this.findFunctionSupplier = FileSystemItem.Find.FunctionSupplier.OF_RECURSIVE_IN_CHILDREN;
        return this;
    }

    public SearchConfig findInAllChildren() {
        this.findFunctionSupplier = FileSystemItem.Find.FunctionSupplier.OF_IN_ALL_CHILDREN;
        return this;
    }

    public SearchConfig findFirstInAllChildren() {
        this.findFunctionSupplier = FileSystemItem.Find.FunctionSupplier.OF_FIRST_IN_ALL_CHILDREN;
        return this;
    }

    public SearchConfig findFirstInChildren() {
        this.findFunctionSupplier = FileSystemItem.Find.FunctionSupplier.OF_FIRST_IN_CHILDREN;
        return this;
    }

    public SearchConfig setFileFilter(Function<FileSystemItem, FileSystemItem.Criteria> filterSupplier) {
        this.fileFilterSupplier = filterSupplier;
        return this;
    }

    public SearchConfig setFileFilter(FileSystemItem.Criteria filter) {
        this.fileFilterSupplier = fileSystemItem -> filter;
        return this;
    }

    public SearchConfig addFileFilter(Function<FileSystemItem, FileSystemItem.Criteria> filterSupplier) {
        if (this.additionalFileFilterSupplier == null) {
            this.additionalFileFilterSupplier = filterSupplier;
            return this;
        }
        Function<FileSystemItem, FileSystemItem.Criteria> previousAdditionalFileFilterSupplier = this.additionalFileFilterSupplier;
        this.additionalFileFilterSupplier = fileSystemItem -> ((FileSystemItem.Criteria)previousAdditionalFileFilterSupplier.apply((FileSystemItem)fileSystemItem)).and((FileSystemItem.Criteria)filterSupplier.apply((FileSystemItem)fileSystemItem));
        return this;
    }

    public SearchConfig addFileFilter(FileSystemItem.Criteria filter) {
        if (this.additionalFileFilterSupplier == null) {
            this.additionalFileFilterSupplier = fileSystemItem -> filter;
            return this;
        }
        Function<FileSystemItem, FileSystemItem.Criteria> previousAdditionalFileFilterSupplier = this.additionalFileFilterSupplier;
        this.additionalFileFilterSupplier = fileSystemItem -> ((FileSystemItem.Criteria)previousAdditionalFileFilterSupplier.apply((FileSystemItem)fileSystemItem)).and(filter);
        return this;
    }

    public SearchConfig setMinimumCollectionSizeForParallelIteration(int value) {
        this.minimumCollectionSizeForParallelIterationPredicate = collection -> collection.size() >= value;
        return this;
    }

    public SearchConfig useClassLoader(PathScannerClassLoader classLoader) {
        if (classLoader == null) {
            StaticComponentContainer.Driver.throwException((Object)"Class loader could not be null", new Object[0]);
        }
        this.useDefaultPathScannerClassLoader = false;
        this.useDefaultPathScannerClassLoaderAsParent = false;
        this.parentClassLoaderForPathScannerClassLoader = null;
        this.pathScannerClassLoader = classLoader;
        return this;
    }

    public SearchConfig useDefaultPathScannerClassLoader(boolean value) {
        this.useDefaultPathScannerClassLoader = value;
        this.useDefaultPathScannerClassLoaderAsParent = !this.useDefaultPathScannerClassLoader;
        this.parentClassLoaderForPathScannerClassLoader = null;
        this.pathScannerClassLoader = null;
        return this;
    }

    public SearchConfig useAsParentClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            StaticComponentContainer.Driver.throwException((Object)"Parent class loader could not be null", new Object[0]);
        }
        this.useDefaultPathScannerClassLoader = false;
        this.useDefaultPathScannerClassLoaderAsParent = false;
        this.parentClassLoaderForPathScannerClassLoader = classLoader;
        this.pathScannerClassLoader = null;
        return this;
    }

    public SearchConfig useDefaultPathScannerClassLoaderAsParent(boolean value) {
        this.useDefaultPathScannerClassLoaderAsParent = value;
        this.useDefaultPathScannerClassLoader = !this.useDefaultPathScannerClassLoaderAsParent;
        this.parentClassLoaderForPathScannerClassLoader = null;
        this.pathScannerClassLoader = null;
        return this;
    }

    public SearchConfig useNewIsolatedClassLoader() {
        this.useDefaultPathScannerClassLoaderAsParent = false;
        this.useDefaultPathScannerClassLoader = false;
        this.parentClassLoaderForPathScannerClassLoader = null;
        this.pathScannerClassLoader = null;
        return this;
    }

    ClassCriteria getClassCriteria() {
        return this.classCriteria;
    }

    Collection<FileSystemItem> getPathsToBeScanned() {
        return this.pathsRetriever.get();
    }

    BiFunction<FileSystemItem, FileSystemItem.Criteria, Collection<FileSystemItem>> getFindFunction(FileSystemItem fileSystemItem) {
        return this.findFunctionSupplier.apply(fileSystemItem);
    }

    Predicate<FileSystemItem> getRefreshPathIf() {
        return this.refreshPathIf;
    }

    FileSystemItem.Criteria getAllFileFilters(FileSystemItem currentScannedPath) {
        if (this.additionalFileFilterSupplier != null) {
            return this.fileFilterSupplier.apply(currentScannedPath).and(this.additionalFileFilterSupplier.apply(currentScannedPath));
        }
        FileSystemItem.Criteria fileFilter = this.fileFilterSupplier.apply(currentScannedPath);
        if (fileFilter.getMinimumCollectionSizeForParallelIterationPredicate() == null) {
            fileFilter.setMinimumCollectionSizeForParallelIteration(this.minimumCollectionSizeForParallelIterationPredicate);
        }
        if (fileFilter.getPriority() == null) {
            fileFilter.withPriority(this.priority);
        }
        return fileFilter;
    }

    Predicate<Collection<?>> getMinimumCollectionSizeForParallelIterationPredicate() {
        return this.minimumCollectionSizeForParallelIterationPredicate;
    }

    boolean isFileFilterExternallySet() {
        return this.fileFiltersExtenallySet;
    }

    boolean isInitialized() {
        return this.pathsRetriever != null && this.searchContext != null;
    }

    <I, C extends SearchContext<I>> C getSearchContext() {
        return (C)this.searchContext;
    }

    public SearchConfig copyTo(SearchConfig destConfig) {
        destConfig.classCriteria = this.classCriteria.createCopy();
        destConfig.pathsRetriever = this.pathsRetriever;
        destConfig.findFunctionSupplier = this.findFunctionSupplier;
        destConfig.refreshPathIf = this.refreshPathIf;
        destConfig.fileFilterSupplier = this.fileFilterSupplier;
        destConfig.additionalFileFilterSupplier = this.additionalFileFilterSupplier;
        destConfig.pathsSupplier = this.pathsSupplier;
        destConfig.optimizePaths = this.optimizePaths;
        destConfig.useDefaultPathScannerClassLoader = this.useDefaultPathScannerClassLoader;
        destConfig.parentClassLoaderForPathScannerClassLoader = this.parentClassLoaderForPathScannerClassLoader;
        destConfig.pathScannerClassLoader = this.pathScannerClassLoader;
        destConfig.useDefaultPathScannerClassLoaderAsParent = this.useDefaultPathScannerClassLoaderAsParent;
        destConfig.waitForSearchEnding = this.waitForSearchEnding;
        destConfig.priority = this.priority;
        destConfig.minimumCollectionSizeForParallelIterationPredicate = this.minimumCollectionSizeForParallelIterationPredicate;
        return destConfig;
    }

    public SearchConfig createCopy() {
        return this.copyTo(new SearchConfig());
    }

    @Override
    public void close() {
        this.classCriteria.close();
        this.classCriteria = null;
        this.findFunctionSupplier = null;
        this.pathsRetriever = null;
        this.refreshPathIf = null;
        this.fileFilterSupplier = null;
        this.pathsSupplier = null;
        this.additionalFileFilterSupplier = null;
        this.parentClassLoaderForPathScannerClassLoader = null;
        this.pathScannerClassLoader = null;
        this.minimumCollectionSizeForParallelIterationPredicate = null;
        this.priority = null;
    }
}

