/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.burningwave.core.classes.ClassCriteria;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.ClassPathScanner;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.SearchContext;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

class ClassPathHunterImpl
extends ClassPathScanner.Abst<Collection<Class<?>>, SearchContext, ClassPathHunter.SearchResult>
implements ClassPathHunter {
    ClassPathHunterImpl(PathHelper pathHelper, Object defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, Properties config) {
        super(pathHelper, initContext -> SearchContext._create(initContext), context -> new ClassPathHunter.SearchResult((SearchContext)context), defaultPathScannerClassLoaderOrDefaultPathScannerClassLoaderSupplier, config);
    }

    @Override
    String getNameInConfigProperties() {
        return "class-path-hunter";
    }

    @Override
    String getDefaultPathScannerClassLoaderNameInConfigProperties() {
        return "class-path-hunter.default-path-scanner-class-loader";
    }

    @Override
    String getDefaultPathScannerClassLoaderCheckFileOptionsNameInConfigProperties() {
        return "class-path-hunter.new-isolated-path-scanner-class-loader.search-config.check-file-option";
    }

    @Override
    void addToContext(SearchContext context, ClassCriteria.TestContext criteriaTestContext, String basePath, FileSystemItem fileSystemItem, JavaClass javaClass) {
        String classPath = fileSystemItem.getAbsolutePath();
        FileSystemItem classPathAsFIS = FileSystemItem.ofPath(classPath.substring(0, classPath.lastIndexOf(javaClass.getPath())));
        context.addItemFound(basePath, classPathAsFIS.getAbsolutePath(), context.loadClass(javaClass.getName()));
    }

    @Override
    public void close() {
        this.closeResources(() -> this.pathHelper == null, task -> super.close());
    }

    static class SearchContext
    extends org.burningwave.core.classes.SearchContext<Collection<Class<?>>> {
        SearchContext(SearchContext.InitContext initContext) {
            super(initContext);
        }

        static SearchContext _create(SearchContext.InitContext initContext) {
            return new SearchContext(initContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void addItemFound(String basePathAsString, String classPathAsFile, Class<?> testedClass) {
            Map testedClassesForClassPathMap = this.retrieveCollectionForPath(this.itemsFoundMap, ConcurrentHashMap::new, basePathAsString);
            ConcurrentHashMap.KeySetView testedClassesForClassPath = (ConcurrentHashMap.KeySetView)testedClassesForClassPathMap.get(classPathAsFile);
            if (testedClassesForClassPath == null) {
                Map map = testedClassesForClassPathMap;
                synchronized (map) {
                    testedClassesForClassPath = (Collection)testedClassesForClassPathMap.get(classPathAsFile);
                    if (testedClassesForClassPath == null) {
                        testedClassesForClassPath = ConcurrentHashMap.newKeySet();
                        testedClassesForClassPathMap.put(classPathAsFile, testedClassesForClassPath);
                    }
                }
            }
            testedClassesForClassPath.add(testedClass);
            this.itemsFoundFlatMap.putAll(testedClassesForClassPathMap);
        }
    }
}

