/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.function.Supplier;
import org.burningwave.core.Closeable;
import org.burningwave.core.assembler.ComponentContainer;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.PathScannerClassLoader;
import org.burningwave.core.concurrent.Synchronizer;

class ClassLoaderManager<C extends ClassLoader>
implements Closeable {
    private Supplier<C> classLoaderSupplier;
    private Object classLoaderOrClassLoaderSupplier;
    private C classLoader;

    ClassLoaderManager(Object classLoaderOrClassLoaderSupplier) {
        this.classLoaderOrClassLoaderSupplier = classLoaderOrClassLoaderSupplier;
    }

    C get() {
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C get(Object client) {
        block32: {
            ClassLoader classLoaderTemp = null;
            Supplier<C> defaultClassLoaderSupplier = this.classLoaderSupplier;
            if (defaultClassLoaderSupplier != null && (classLoaderTemp = (ClassLoader)defaultClassLoaderSupplier.get()) != this.classLoader) {
                try (Synchronizer.Mutex mutex = StaticComponentContainer.Synchronizer.getMutex(this.getOperationId("getDefaultClassLoader"));){
                    Synchronizer.Mutex mutex2 = mutex;
                    synchronized (mutex2) {
                        defaultClassLoaderSupplier = this.classLoaderSupplier;
                        if (defaultClassLoaderSupplier != null && (classLoaderTemp = (ClassLoader)defaultClassLoaderSupplier.get()) != this.classLoader) {
                            C oldClassLoader = this.classLoader;
                            if (oldClassLoader != null && oldClassLoader instanceof MemoryClassLoader) {
                                ((MemoryClassLoader)oldClassLoader).unregister(this, true);
                            }
                            if (classLoaderTemp instanceof MemoryClassLoader) {
                                if (!((MemoryClassLoader)classLoaderTemp).register(this)) {
                                    classLoaderTemp = this.get(client);
                                } else {
                                    ((MemoryClassLoader)classLoaderTemp).register(client);
                                }
                            }
                            this.classLoader = classLoaderTemp;
                        }
                    }
                }
                return (C)classLoaderTemp;
            }
            if (this.classLoader != null) break block32;
            try (Synchronizer.Mutex mutex = StaticComponentContainer.Synchronizer.getMutex(this.getOperationId("getDefaultClassLoader"));){
                Synchronizer.Mutex mutex3 = mutex;
                synchronized (mutex3) {
                    block33: {
                        block30: {
                            Object defaultClassLoaderOrDefaultClassLoaderSupplier;
                            block31: {
                                if (this.classLoader != null) break block30;
                                defaultClassLoaderOrDefaultClassLoaderSupplier = ((Supplier)this.classLoaderOrClassLoaderSupplier).get();
                                if (!(defaultClassLoaderOrDefaultClassLoaderSupplier instanceof PathScannerClassLoader)) break block31;
                                this.classLoader = (ClassLoader)defaultClassLoaderOrDefaultClassLoaderSupplier;
                                ((MemoryClassLoader)this.classLoader).register(this);
                                ((MemoryClassLoader)this.classLoader).register(client);
                                C c = this.classLoader;
                                return c;
                            }
                            if (defaultClassLoaderOrDefaultClassLoaderSupplier instanceof Supplier) {
                                this.classLoaderSupplier = (Supplier)defaultClassLoaderOrDefaultClassLoaderSupplier;
                                C c = this.get(client);
                                return c;
                            }
                            break block33;
                        }
                        C c = this.classLoader;
                        return c;
                    }
                }
            }
        }
        return this.classLoader;
    }

    void reset() {
        StaticComponentContainer.Synchronizer.execute(this.getOperationId("getDefaultClassLoader"), () -> {
            C classLoader = this.classLoader;
            if (classLoader != null) {
                this.classLoaderSupplier = null;
                this.classLoader = null;
                if (classLoader instanceof MemoryClassLoader) {
                    ((MemoryClassLoader)classLoader).unregister(this, true);
                }
                try {
                    if (classLoader instanceof ComponentContainer.PathScannerClassLoader) {
                        ((ComponentContainer.PathScannerClassLoader)classLoader).markAsCloseable();
                    }
                }
                catch (Throwable exc) {
                    StaticComponentContainer.ManagedLoggersRepository.logWarn(this.getClass()::getName, "Exception occurred while resetting default path scanner classloader: {}", exc.getMessage());
                }
            }
        });
    }

    @Override
    public void close() {
        this.classLoaderOrClassLoaderSupplier = null;
        this.reset();
        this.classLoaderSupplier = null;
        this.classLoader = null;
    }
}

