/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import org.burningwave.core.Component;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.ByteCodeHunter;
import org.burningwave.core.classes.ClassFactory;
import org.burningwave.core.classes.ClassLoaderManager;
import org.burningwave.core.classes.ClassPathHelper;
import org.burningwave.core.classes.ClassPathHunter;
import org.burningwave.core.classes.JavaMemoryCompiler;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfig;
import org.burningwave.core.classes.LoadOrBuildAndDefineConfigAbst;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.classes.UnitSourceGenerator;
import org.burningwave.core.io.PathHelper;
import org.burningwave.core.iterable.Properties;

public class ClassFactoryImpl
implements ClassFactory,
Component {
    PathHelper pathHelper;
    ClassPathHelper classPathHelper;
    JavaMemoryCompiler javaMemoryCompiler;
    ByteCodeHunter byteCodeHunter;
    private ClassPathHunter classPathHunter;
    private Supplier<ClassPathHunter> classPathHunterSupplier;
    private ClassLoaderManager<ClassLoader> defaultClassLoaderManager;
    private Collection<ClassFactory.ClassRetriever> classRetrievers;
    Properties config;

    ClassFactoryImpl(ByteCodeHunter byteCodeHunter, Supplier<ClassPathHunter> classPathHunterSupplier, JavaMemoryCompiler javaMemoryCompiler, PathHelper pathHelper, ClassPathHelper classPathHelper, Object defaultClassLoaderOrDefaultClassLoaderSupplier, Properties config) {
        this.byteCodeHunter = byteCodeHunter;
        this.classPathHunterSupplier = classPathHunterSupplier;
        this.javaMemoryCompiler = javaMemoryCompiler;
        this.pathHelper = pathHelper;
        this.classPathHelper = classPathHelper;
        this.defaultClassLoaderManager = new ClassLoaderManager(defaultClassLoaderOrDefaultClassLoaderSupplier);
        this.classRetrievers = new CopyOnWriteArrayList<ClassFactory.ClassRetriever>();
        this.config = config;
        this.listenTo(config);
    }

    @Override
    public <K, V> void processChangeNotification(Properties properties, Properties.Event event, K key, V newValue, V previousValue) {
        String keyAsString;
        if (event.name().equals(Properties.Event.PUT.name()) && key instanceof String && (keyAsString = (String)key).equals("class-factory.default-class-loader")) {
            this.defaultClassLoaderManager.reset();
        }
    }

    ClassLoader getDefaultClassLoader(Object client) {
        return this.defaultClassLoaderManager.get(client);
    }

    ClassPathHunter getClassPathHunter() {
        return this.classPathHunter != null ? this.classPathHunter : (this.classPathHunter = this.classPathHunterSupplier.get());
    }

    @Override
    public ClassFactory.ClassRetriever loadOrBuildAndDefine(UnitSourceGenerator ... unitsCode) {
        return this.loadOrBuildAndDefine(LoadOrBuildAndDefineConfig.forUnitSourceGenerator(unitsCode));
    }

    @Override
    public <L extends LoadOrBuildAndDefineConfigAbst<L>> ClassFactory.ClassRetriever loadOrBuildAndDefine(L config) {
        if (config.isVirtualizeClassesEnabled()) {
            config.addClassPaths(this.pathHelper.getBurningwaveRuntimeClassPath());
        }
        return this.loadOrBuildAndDefine(config.getClassesName(), config.getCompileConfigSupplier(), config.isUseOneShotJavaCompilerEnabled(), StaticComponentContainer.IterableObjectHelper.merge(() -> config.getClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(), () -> config.getAdditionalClassRepositoriesWhereToSearchNotFoundClassesDuringLoading(), () -> {
            Collection<String> classRepositoriesForNotFoundClasses = this.pathHelper.getPaths(ClassFactory.Configuration.Key.CLASS_REPOSITORIES_FOR_DEFAULT_CLASS_LOADER);
            if (!classRepositoriesForNotFoundClasses.isEmpty()) {
                config.addClassRepositoriesWhereToSearchNotFoundClasses(classRepositoriesForNotFoundClasses);
            }
            return classRepositoriesForNotFoundClasses;
        }), (Object client) -> Optional.ofNullable(config.getClassLoader()).orElseGet(() -> this.getDefaultClassLoader(client)));
    }

    private ClassFactory.ClassRetriever loadOrBuildAndDefine(Collection<String> classNames, Supplier<JavaMemoryCompiler.Compilation.Config> compileConfigSupplier, boolean useOneShotJavaCompiler, Collection<String> additionalClassRepositoriesForClassLoader, Function<Object, ClassLoader> classLoaderSupplier) {
        try {
            Object temporaryClient = new Object(){};
            ClassLoader classLoader = classLoaderSupplier.apply(temporaryClient);
            return new ClassFactory.ClassRetriever(this, classRetriever -> {
                if (classLoader instanceof MemoryClassLoader) {
                    ((MemoryClassLoader)classLoader).register(classRetriever);
                    ((MemoryClassLoader)classLoader).unregister(temporaryClient, true);
                    if (classLoader != this.defaultClassLoaderManager.get()) {
                        ((MemoryClassLoader)classLoader).unregister(this, true);
                    }
                }
                return classLoader;
            }, compileConfigSupplier, useOneShotJavaCompiler, additionalClassRepositoriesForClassLoader, classNames);
        }
        catch (Throwable exc) {
            return (ClassFactory.ClassRetriever)StaticComponentContainer.Driver.throwException((Object)exc, new Object[0]);
        }
    }

    boolean register(ClassFactory.ClassRetriever classRetriever) {
        this.classRetrievers.add(classRetriever);
        return true;
    }

    boolean unregister(ClassFactory.ClassRetriever classRetriever) {
        this.classRetrievers.remove(classRetriever);
        return true;
    }

    @Override
    public void closeClassRetrievers() {
        StaticComponentContainer.Synchronizer.execute(this.getOperationId("closeClassRetrievers"), () -> {
            Collection<ClassFactory.ClassRetriever> classRetrievers = this.classRetrievers;
            if (classRetrievers != null) {
                for (ClassFactory.ClassRetriever classRetriever : classRetrievers) {
                    classRetriever.close();
                }
            }
        });
    }

    @Override
    public void reset(boolean closeClassRetrievers) {
        if (closeClassRetrievers) {
            this.closeClassRetrievers();
        }
        this.defaultClassLoaderManager.reset();
    }

    @Override
    public void close() {
        this.closeResources(() -> this.classRetrievers == null, tsk -> {
            this.defaultClassLoaderManager.close();
            this.unregister(this.config);
            this.closeClassRetrievers();
            StaticComponentContainer.BackgroundExecutor.createTask(task -> {
                this.classRetrievers = null;
            }).submit();
            this.pathHelper = null;
            this.javaMemoryCompiler = null;
            this.byteCodeHunter = null;
            this.classPathHunter = null;
            this.classPathHunterSupplier = null;
            this.config = null;
        });
    }
}

