/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.maven.plugin.processor;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.bsc.maven.plugin.processor.PlexusJavaCompilerWithOutput;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.compiler.manager.CompilerManager;

public class AnnotationProcessorCompiler
implements JavaCompiler {
    private static final String COMPILER_TARGET = "maven.compiler.target";
    private static final String COMPILER_SOURCE = "maven.compiler.source";
    private static final String PROCESSOR_TARGET = "maven.processor.target";
    private static final String PROCESSOR_SOURCE = "maven.processor.source";
    private static final String DEFAULT_SOURCE_VERSION = "1.7";
    private static final String DEFAULT_TARGET_VERSION = "1.7";
    final JavaCompiler systemJavaCompiler = ToolProvider.getSystemJavaCompiler();
    final MavenProject project;
    final MavenSession session;
    final CompilerManager plexusCompiler;
    final Toolchain _toolchain;

    public static JavaCompiler createOutProcess(Toolchain toolchain, CompilerManager plexusCompiler, MavenProject project, MavenSession session) {
        return new AnnotationProcessorCompiler(toolchain, plexusCompiler, project, session);
    }

    public static JavaCompiler createInProcess() {
        return ToolProvider.getSystemJavaCompiler();
    }

    static void printCommand(Compiler javac, CompilerConfiguration javacConf, PrintWriter out) throws CompilerException {
        out.println();
        out.println();
        out.println("javac \\");
        for (String c : javac.createCommandLine(javacConf)) {
            out.printf("%s \\\n", c);
        }
        out.println();
        out.println();
        out.println();
    }

    private AnnotationProcessorCompiler(Toolchain toolchain, CompilerManager plexusCompiler, MavenProject project, MavenSession session) {
        this.project = project;
        this.session = session;
        this.plexusCompiler = plexusCompiler;
        this._toolchain = toolchain;
    }

    public Optional<Toolchain> getToolchain() {
        return Optional.ofNullable(this._toolchain);
    }

    private boolean execute(Iterable<String> options, Iterable<? extends JavaFileObject> compilationUnits, Writer w) throws Exception {
        PrintWriter out = w instanceof PrintWriter ? (PrintWriter)w : new PrintWriter(w);
        CompilerConfiguration javacConf = new CompilerConfiguration();
        Iterator<String> ii = options.iterator();
        while (ii.hasNext()) {
            String option = ii.next();
            if ("-cp".equals(option)) {
                javacConf.addClasspathEntry(ii.next());
                continue;
            }
            if ("-sourcepath".equals(option)) {
                String[] sourceLocations;
                for (String path : sourceLocations = ii.next().split(Pattern.quote(File.pathSeparator))) {
                    File dir = new File(path);
                    if (!dir.exists()) continue;
                    javacConf.addSourceLocation(path);
                }
                continue;
            }
            if ("-proc:only".equals(option)) {
                javacConf.setProc("only");
                continue;
            }
            if ("-processor".equals(option)) {
                String[] processors = ii.next().split(",");
                javacConf.setAnnotationProcessors(processors);
                continue;
            }
            if ("-d".equals(option)) {
                javacConf.setOutputLocation(ii.next());
                continue;
            }
            if ("-s".equals(option)) {
                javacConf.setGeneratedSourcesDirectory(new File(ii.next()));
                continue;
            }
            if ("--release".equals(option)) {
                javacConf.setReleaseVersion(ii.next());
                continue;
            }
            if ("-encoding".equals(option)) {
                javacConf.setSourceEncoding(ii.next());
                continue;
            }
            javacConf.addCompilerCustomArgument(option, "");
        }
        Properties props = this.project.getProperties();
        String sourceVersion = props.getProperty(PROCESSOR_SOURCE, props.getProperty(COMPILER_SOURCE, "1.7"));
        String targetVersion = props.getProperty(PROCESSOR_TARGET, props.getProperty(COMPILER_TARGET, "1.7"));
        javacConf.setSourceVersion(sourceVersion);
        javacConf.setTargetVersion(targetVersion);
        javacConf.setWorkingDirectory(this.project.getBasedir());
        Set sourceFiles = StreamSupport.stream(compilationUnits.spliterator(), false).map(unit -> unit.toUri()).map(File::new).collect(Collectors.toSet());
        javacConf.setSourceFiles(sourceFiles);
        javacConf.setDebug(false);
        javacConf.setFork(true);
        javacConf.setVerbose(false);
        this.getToolchain().ifPresent(toolchain -> {
            String executable = toolchain.findTool("javac");
            javacConf.setExecutable(executable);
        });
        CompilerResult result = PlexusJavaCompilerWithOutput.INSTANCE.performCompile(javacConf);
        out.println(result.toString());
        out.flush();
        return result.isSuccess();
    }

    @Override
    public JavaCompiler.CompilationTask getTask(final Writer out, JavaFileManager fileManager, final DiagnosticListener<? super JavaFileObject> diagnosticListener, final Iterable<String> options, Iterable<String> classes, final Iterable<? extends JavaFileObject> compilationUnits) {
        return new JavaCompiler.CompilationTask(){

            @Override
            public void setProcessors(Iterable<? extends Processor> processors) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void setLocale(Locale locale) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Boolean call() {
                try {
                    return AnnotationProcessorCompiler.this.execute(options, compilationUnits, out);
                }
                catch (Exception ex) {
                    diagnosticListener.report(new Diagnostic<JavaFileObject>(){

                        @Override
                        public Diagnostic.Kind getKind() {
                            return Diagnostic.Kind.ERROR;
                        }

                        @Override
                        public String getMessage(Locale locale) {
                            return ex.getLocalizedMessage();
                        }

                        public String toString() {
                            return ex.getLocalizedMessage();
                        }

                        @Override
                        public JavaFileObject getSource() {
                            return null;
                        }

                        @Override
                        public long getPosition() {
                            return -1L;
                        }

                        @Override
                        public long getStartPosition() {
                            return -1L;
                        }

                        @Override
                        public long getEndPosition() {
                            return -1L;
                        }

                        @Override
                        public long getLineNumber() {
                            return -1L;
                        }

                        @Override
                        public long getColumnNumber() {
                            return -1L;
                        }

                        @Override
                        public String getCode() {
                            return null;
                        }
                    });
                    return false;
                }
            }
        };
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.systemJavaCompiler.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return this.systemJavaCompiler.getSourceVersions();
    }

    @Override
    public int isSupportedOption(String option) {
        return this.systemJavaCompiler.isSupportedOption(option);
    }
}

