/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.io.InputStream;
import java.math.BigInteger;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.bsc.confluence.rest.FilePart;
import org.bsc.confluence.rest.MultipartFormDataChannel;
import org.bsc.confluence.rest.Part;
import org.bsc.confluence.rest.StreamPart;
import org.bsc.confluence.rest.StringPart;

public class MultipartFormDataBodyPublisher
implements HttpRequest.BodyPublisher {
    private final String boundary = MultipartFormDataBodyPublisher.nextBoundary();
    private final List<Part> parts = new ArrayList<Part>();
    private Charset charset;
    private final HttpRequest.BodyPublisher delegate = HttpRequest.BodyPublishers.ofInputStream(() -> Channels.newInputStream(new MultipartFormDataChannel(this.boundary, this.parts, this.charset)));

    private static String nextBoundary() {
        BigInteger random = new BigInteger(128, new Random());
        try (Formatter formatter = new Formatter();){
            String string = formatter.format("-----------------------------%039d", random).toString();
            return string;
        }
    }

    public MultipartFormDataBodyPublisher() {
        this(StandardCharsets.UTF_8);
    }

    public MultipartFormDataBodyPublisher(Charset charset) {
        this.charset = charset;
    }

    private MultipartFormDataBodyPublisher add(Part part) {
        this.parts.add(part);
        return this;
    }

    public MultipartFormDataBodyPublisher add(String name, String value) {
        return this.add(new StringPart(name, value, this.charset));
    }

    public MultipartFormDataBodyPublisher addFile(String name, Path path) {
        return this.add(new FilePart(name, path));
    }

    public MultipartFormDataBodyPublisher addFile(String name, Path path, String contentType) {
        return this.add(new FilePart(name, path, contentType));
    }

    public MultipartFormDataBodyPublisher addStream(String name, String filename, Supplier<InputStream> supplier) {
        return this.add(new StreamPart(name, filename, () -> Channels.newChannel((InputStream)supplier.get())));
    }

    public MultipartFormDataBodyPublisher addStream(String name, String filename, Supplier<InputStream> supplier, String contentType) {
        return this.add(new StreamPart(name, filename, () -> Channels.newChannel((InputStream)supplier.get()), contentType));
    }

    public MultipartFormDataBodyPublisher addChannel(String name, String filename, Supplier<ReadableByteChannel> supplier) {
        return this.add(new StreamPart(name, filename, supplier));
    }

    public MultipartFormDataBodyPublisher addChannel(String name, String filename, Supplier<ReadableByteChannel> supplier, String contentType) {
        return this.add(new StreamPart(name, filename, supplier, contentType));
    }

    public String contentType() {
        try (Formatter formatter = new Formatter();){
            String string = formatter.format("multipart/form-data; boundary=%s", this.boundary).toString();
            return string;
        }
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> s) {
        this.delegate.subscribe(s);
    }

    @Override
    public long contentLength() {
        return this.delegate.contentLength();
    }
}

