/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.confluence.rest;

import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.stream.Collectors;

public class FormUrlEncodedBodyPublisher
implements HttpRequest.BodyPublisher {
    private final byte[] data;

    public final String getContentType() {
        return "application/x-www-form-urlencoded";
    }

    public FormUrlEncodedBodyPublisher(Map<String, String> fields) {
        this.data = fields.entrySet().stream().map(kv -> String.format("%s=%s", URLEncoder.encode((String)kv.getKey(), StandardCharsets.UTF_8), URLEncoder.encode((String)kv.getValue(), StandardCharsets.UTF_8))).collect(Collectors.joining("&")).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public long contentLength() {
        return this.data.length;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onNext(ByteBuffer.wrap(this.data));
        subscriber.onComplete();
    }
}

