/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.mojo;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bsc.confluence.ConfluenceService;
import org.bsc.confluence.DeployStateManager;
import org.bsc.confluence.model.Site;
import org.bsc.mojo.AbstractBaseConfluenceSiteMojo;
import org.bsc.mojo.DeployStateSupport;
import org.bsc.mojo.configuration.DeployStateInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Mojo(name="delete", threadSafe=true, requiresProject=false)
public class ConfluenceDeleteMojo
extends AbstractBaseConfluenceSiteMojo
implements DeployStateSupport {
    @Parameter(property="recursive", defaultValue="true")
    private boolean recursive;
    @Parameter
    protected DeployStateInfo deployState = new DeployStateInfo(false);
    private DeployStateManager _deployStateManager = null;

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    @Override
    public final DeployStateInfo getDeployState() {
        return this.deployState;
    }

    public final Optional<DeployStateManager> getDeployStateManager() {
        return Optional.ofNullable(this._deployStateManager);
    }

    private boolean deletePage(ConfluenceService confluence) {
        Optional<String> optStartPageTitle = Optional.empty();
        if (this.isSiteDescriptorValid()) {
            Site site = this.createSiteFromModel(this.getSiteModelVariables());
            optStartPageTitle = Optional.ofNullable(site.getHome().getName());
        }
        if (!optStartPageTitle.isPresent()) {
            optStartPageTitle = Optional.ofNullable(this.getPageTitle());
        }
        return optStartPageTitle.map(startPageTitle -> this.deletePage(confluence, (String)startPageTitle)).orElseGet(() -> {
            this.getLog().warn((CharSequence)"page title has not been provided!");
            return false;
        });
    }

    private <T extends ConfluenceService.Model.PageSummary> CompletableFuture<Void> deleteDescendents(ConfluenceService confluence, String startPageTitle, T parentPage) {
        if (!this.recursive) {
            return CompletableFuture.completedFuture(null);
        }
        return confluence.getDescendents(parentPage.getId()).thenAccept(descendents -> {
            if (descendents == null || descendents.isEmpty()) {
                this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not descendents!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                return;
            }
            for (ConfluenceService.Model.PageSummary descendent : descendents) {
                ((CompletableFuture)((CompletableFuture)confluence.removePage(descendent.getId()).exceptionally(ex -> {
                    this.getLog().warn((CharSequence)String.format("cannot remove descendent %s", descendent.getTitle()), ex);
                    return false;
                })).thenAccept(removed -> {
                    if (removed.booleanValue()) {
                        this.getLog().info((CharSequence)String.format("Page [%s]/[%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), startPageTitle, descendent.getTitle(), parentPage.getSpace()));
                    } else {
                        this.getLog().warn((CharSequence)String.format("Page [%s]/[%s]/[%s] in [%s] has not been removed!", parentPage.getTitle(), startPageTitle, descendent.getTitle(), parentPage.getSpace()));
                    }
                })).join();
            }
        });
    }

    private boolean deletePage(ConfluenceService confluence, String startPageTitle) {
        this.getLog().debug((CharSequence)String.format("start deleting from page [%s]", startPageTitle));
        Function<Boolean, Boolean> clearDeployState = result -> {
            if (result.booleanValue()) {
                this.getDeployStateManager().ifPresent(dpm -> dpm.clear().save());
            }
            return result;
        };
        return (Boolean)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.loadParentPage(confluence, Optional.empty()).thenCompose(parentPage -> confluence.getPageByTitle(parentPage.getId(), startPageTitle).thenCompose(start -> {
            if (!start.isPresent()) {
                this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] not found!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                return CompletableFuture.completedFuture(false);
            }
            return this.deleteDescendents(confluence, startPageTitle, (ConfluenceService.Model.PageSummary)start.get()).thenCompose(v -> confluence.removePage(((ConfluenceService.Model.PageSummary)start.get()).getId()).thenApply(success -> {
                if (success.booleanValue()) {
                    this.getLog().info((CharSequence)String.format("Page [%s]/[%s] in [%s] has been removed!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                } else {
                    this.getLog().warn((CharSequence)String.format("Page [%s]/[%s] in [%s] has not been removed!", parentPage.getTitle(), startPageTitle, parentPage.getSpace()));
                }
                return success;
            }));
        }))).exceptionally(ex -> {
            this.getLog().warn((CharSequence)ex.getMessage());
            return false;
        })).thenApply(clearDeployState)).join();
    }

    @Override
    public void execute(ConfluenceService confluence) throws Exception {
        this._deployStateManager = this.initDeployStateManager().orElse(null);
        this.deletePage(confluence);
    }
}

