/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown.commonmark;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bsc.markdown.MarkdownParserContext;
import org.bsc.markdown.MarkdownVisitorHelper;
import org.bsc.markdown.commonmark.extension.NoticeBlock;
import org.bsc.markdown.commonmark.extension.NoticeBlockExtension;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CommonmarkConfluenceWikiVisitor
implements Visitor {
    private Stack<StringBuilder> bufferStack = new Stack();
    private final MarkdownParserContext parseContext;
    private static final Pattern isHTMLCommentPattern = Pattern.compile("^([\\s]*)<!--(?:[\\s]*)(.+)-->$", 32);

    public static Parser parser() {
        return new Parser();
    }

    public CommonmarkConfluenceWikiVisitor(MarkdownParserContext parseContext) {
        this.parseContext = parseContext;
        this.bufferStack.push(new StringBuilder(512000));
    }

    private StringBuilder buffer() {
        return this.bufferStack.peek();
    }

    private boolean isParentRoot(Node node) {
        return node.getParent() instanceof Document;
    }

    public static String escapeMarkdownText(Node node, String text) {
        if (node != null && node.getParent() instanceof TableCell) {
            return MarkdownVisitorHelper.escapeMarkdownText((String)text, (MarkdownVisitorHelper.EscapeTextEnum)MarkdownVisitorHelper.EscapeTextEnum.LeftCurlyBrace, (MarkdownVisitorHelper.EscapeTextEnum[])new MarkdownVisitorHelper.EscapeTextEnum[0]);
        }
        return MarkdownVisitorHelper.escapeMarkdownText((String)text, (MarkdownVisitorHelper.EscapeTextEnum)MarkdownVisitorHelper.EscapeTextEnum.LeftCurlyBrace, (MarkdownVisitorHelper.EscapeTextEnum[])new MarkdownVisitorHelper.EscapeTextEnum[]{MarkdownVisitorHelper.EscapeTextEnum.LeftSquareBrace, MarkdownVisitorHelper.EscapeTextEnum.RightCurlyBrace, MarkdownVisitorHelper.EscapeTextEnum.RightSquareBrace});
    }

    public static Matcher parseHTMLComment(String text) {
        Objects.requireNonNull(text);
        return isHTMLCommentPattern.matcher(text);
    }

    public void visit(Document node) {
        this.processChildren(node).process();
    }

    public void visit(Paragraph node) {
        ChildrenProcessor<Paragraph> p = this.processChildren(node);
        if (this.isParentRoot((Node)node)) {
            p.post(() -> "\n");
        } else if (node.getParent() instanceof ListBlock) {
            p.pre(() -> "\n");
        }
        p.process().nl();
    }

    public void visit(HardLineBreak node) {
        this.processChildren(node).pre(() -> "\\\\").process().nl();
    }

    public void visit(SoftLineBreak node) {
        this.processChildren(node).process().nl();
    }

    public void visit(Text node) {
        String literal = CommonmarkConfluenceWikiVisitor.escapeMarkdownText((Node)node, node.getLiteral());
        this.processChildren(node).pre(() -> literal).process();
    }

    public void visit(Heading node) {
        this.processChildren(node).pre(() -> String.format("h%s. ", node.getLevel())).process().nl();
    }

    public void visit(ListItem node) {
        this.processChildren(node).process();
    }

    public void visit(OrderedList node) {
        Block parent = node.getParent();
        if (parent instanceof ListItem) {
            this.processChildren(node).map(arg_0 -> CommonmarkConfluenceWikiVisitor.lambda$visit$5((Node)parent, arg_0)).process();
        } else {
            this.processChildren(node).map(n -> "# ").process().nl();
        }
    }

    public void visit(BulletList node) {
        Block parent = node.getParent();
        if (parent instanceof ListItem) {
            this.processChildren(node).map(arg_0 -> CommonmarkConfluenceWikiVisitor.lambda$visit$7((Node)parent, arg_0)).process();
        } else {
            this.processChildren(node).map(n -> "* ").process().nl();
        }
    }

    public void visit(BlockQuote node) {
        this.processChildren(node).pre(() -> "{quote}\n").post(() -> "{quote}\n").process().nl(this.isParentRoot((Node)node));
    }

    public void visit(Code node) {
        String literal = CommonmarkConfluenceWikiVisitor.escapeMarkdownText((Node)node, node.getLiteral());
        this.processChildren(node).pre(() -> String.format("{{%s}}", literal)).process();
    }

    public void visit(FencedCodeBlock node) {
        Function<String, String> info = v -> v == null || v.length() == 0 ? "" : ":" + v;
        this.processChildren(node).pre(() -> String.format("{code%s}\n%s", info.apply(node.getInfo()), node.getLiteral())).post(() -> "{code}").process().nl();
    }

    public void visit(Emphasis node) {
        this.processChildren(node).pre(() -> "_").post(() -> "_").process();
    }

    public void visit(StrongEmphasis node) {
        this.processChildren(node).pre(() -> "*").post(() -> "*").process();
    }

    public void visit(Image node) {
        String destination = MarkdownVisitorHelper.processImageUrl((String)node.getDestination(), (MarkdownParserContext)this.parseContext);
        this.processChildren(node).pre(() -> String.format("!%s|", destination, node.getTitle())).post(() -> "!").process().nl(this.isParentRoot((Node)node));
    }

    public void visit(LinkReferenceDefinition node) {
        this.processChildren(node).process().nl();
    }

    public void visit(Link node) {
        String destination = MarkdownVisitorHelper.processLinkUrl((String)node.getDestination(), (MarkdownParserContext)this.parseContext);
        this.processChildren(node).pre(() -> "[").captureOutput(v -> this.buffer().append((String)v)).post(() -> String.format("|%s%s]", destination, Optional.ofNullable(node.getTitle()).map(v -> "|" + v).orElse(""))).process().nl(this.isParentRoot((Node)node));
    }

    public void visit(ThematicBreak node) {
        this.processChildren(node).pre(() -> "----").process().nl();
    }

    public void visit(TableBlock node) {
        this.processChildren(node).process();
    }

    public void visit(TableHead node) {
        this.processChildren(node).process();
    }

    public void visit(TableBody node) {
        this.processChildren(node).process();
    }

    public void visit(TableRow node) {
        this.processChildren(node).pre(() -> "|").post(() -> node.getParent() instanceof TableHead ? "|" : "").process().nl();
    }

    public void visit(TableCell node) {
        this.processChildren(node).captureOutput(value -> this.buffer().append(value.isEmpty() ? Character.valueOf(' ') : value)).pre(() -> node.isHeader() ? "|" : "").post(() -> "|").process();
    }

    private String processConfluenceMacro(String content) {
        Matcher m = MarkdownVisitorHelper.parseConfluenceMacro((String)content);
        if (!m.matches() || m.groupCount() != 3) {
            return content;
        }
        String mdContent = CommonmarkConfluenceWikiVisitor.parser().parseMarkdown(this.parseContext, m.group(2));
        return String.format("%s\n%s\n%s\n", m.group(1), mdContent, m.group(3));
    }

    public void visit(HtmlBlock node) {
        String literal = node.getLiteral();
        Matcher m = CommonmarkConfluenceWikiVisitor.parseHTMLComment(literal);
        if (m.matches() && MarkdownVisitorHelper.isConfluenceMacroOrVariable((String)m.group(2))) {
            String parsedText = m.group(2);
            this.processChildren(node).pre(() -> m.group(1)).post(() -> MarkdownVisitorHelper.isConfluenceMacro((String)parsedText) ? this.processConfluenceMacro(parsedText) : parsedText).process().nl();
        } else if (!this.parseContext.isSkipHtml()) {
            this.processChildren(node).pre(() -> String.format("{html}\n%s\n", literal)).post(() -> "{html}").process().nl();
        }
    }

    public void visit(HtmlInline node) {
        if (this.parseContext.isSkipHtml()) {
            return;
        }
        this.processChildren(node).process().nl();
    }

    public void visit(Strikethrough node) {
        this.processChildren(node).pre(() -> "-").post(() -> "-").process();
    }

    public void visit(NoticeBlock node) {
        String type = node.getType().getTagName();
        ChildrenProcessor<NoticeBlock> p = this.processChildren(node);
        if (node.getTitle().isPresent()) {
            p.pre(() -> String.format("{%s:title=%s}\n", type, node.getTitle().get()));
        } else {
            p.pre(() -> String.format("{%s}\n", type));
        }
        p.post(() -> String.format("{%s}\n", type)).process().nl(this.isParentRoot((Node)node));
    }

    public void visit(CustomNode node) {
        if (node instanceof Strikethrough) {
            this.visit((Strikethrough)node);
            return;
        }
        if (node instanceof TableCell) {
            this.visit((TableCell)node);
            return;
        }
        if (node instanceof TableRow) {
            this.visit((TableRow)node);
            return;
        }
        if (node instanceof TableHead) {
            this.visit((TableHead)node);
            return;
        }
        if (node instanceof TableBody) {
            this.visit((TableBody)node);
            return;
        }
        this.processChildren(node).pre(() -> String.format("<<CSTN type=\"%s\">>", node.getClass().getSimpleName())).post(() -> "<</CSTN>>").process().nl();
    }

    public void visit(CustomBlock node) {
        if (node instanceof TableBlock) {
            this.visit((TableBlock)node);
            return;
        }
        if (node instanceof NoticeBlock) {
            this.visit((NoticeBlock)node);
            return;
        }
        this.processChildren(node).pre(() -> String.format("<<CSTB type=\"%s\">>", node.getClass().getSimpleName())).post(() -> "<</CSTB>>").process().nl();
    }

    public void visit(IndentedCodeBlock node) {
        this.processChildren(node).pre(() -> "<<ICB>>").post(() -> "<</ICB>>").process().nl();
    }

    public String toString() {
        return this.buffer().toString();
    }

    protected <T extends Node> ChildrenProcessor<T> processChildren(T parent) {
        return new ChildrenProcessor(this, parent, false);
    }

    private static /* synthetic */ String lambda$visit$7(Node parent, Node n) {
        return parent.getParent() instanceof OrderedList ? "#* " : "** ";
    }

    private static /* synthetic */ String lambda$visit$5(Node parent, Node n) {
        return parent.getParent() instanceof OrderedList ? "## " : "*# ";
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class ChildrenProcessor<T extends Node> {
        private final boolean debug;
        Optional<Supplier<String>> pre = Optional.empty();
        Optional<Supplier<String>> post = Optional.empty();
        Optional<Function<Node, String>> map = Optional.empty();
        Optional<Consumer<String>> captureOutput = Optional.empty();
        final T parent;
        final /* synthetic */ CommonmarkConfluenceWikiVisitor this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ChildrenProcessor(T parent, boolean debug) {
            this.this$0 = (CommonmarkConfluenceWikiVisitor)this$0;
            this.parent = parent;
            this.debug = debug;
        }

        public ChildrenProcessor(T parent) {
            this(this$0, (Node)parent, false);
        }

        ChildrenProcessor<T> captureOutput(Consumer<String> v) {
            this.captureOutput = Optional.ofNullable(v);
            return this;
        }

        ChildrenProcessor<T> pre(Supplier<String> supplier) {
            this.pre = Optional.ofNullable(supplier);
            return this;
        }

        ChildrenProcessor<T> post(Supplier<String> supplier) {
            this.post = Optional.ofNullable(supplier);
            return this;
        }

        <A extends Node> ChildrenProcessor<T> map(Function<Node, String> v) {
            this.map = Optional.ofNullable(v);
            return this;
        }

        ChildrenProcessor<T> nl() {
            this.this$0.buffer().append('\n');
            return this;
        }

        ChildrenProcessor<T> nl(boolean condition) {
            if (condition) {
                this.this$0.buffer().append('\n');
            }
            return this;
        }

        ChildrenProcessor<T> process() {
            if (this.debug) {
                this.this$0.buffer().append(String.format("<%s>", this.parent.getClass().getSimpleName()));
            }
            this.pre.ifPresent(v -> this.this$0.buffer().append((String)v.get()));
            this.captureOutput.ifPresent(consumer -> this.this$0.bufferStack.push(new StringBuilder()));
            Node node = this.parent.getFirstChild();
            while (node != null) {
                Node next = node.getNext();
                if (this.map.isPresent()) {
                    this.this$0.buffer().append(this.map.get().apply(node));
                }
                node.accept((Visitor)this.this$0);
                node = next;
            }
            this.captureOutput.ifPresent(consumer -> consumer.accept(((StringBuilder)this.this$0.bufferStack.pop()).toString()));
            this.post.ifPresent(v -> this.this$0.buffer().append((String)v.get()));
            if (this.debug) {
                this.this$0.buffer().append(String.format("</%s>", this.parent.getClass().getSimpleName()));
            }
            return this;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Parser {
        private final List<Extension> extensions = Arrays.asList(StrikethroughExtension.create(), TablesExtension.create(), NoticeBlockExtension.create());
        private final org.commonmark.parser.Parser parser = org.commonmark.parser.Parser.builder().extensions(this.extensions).build();

        public final Node parse(String content) {
            return this.parser.parse(content);
        }

        public final String parseMarkdown(MarkdownParserContext context, String content) {
            Node node = this.parser.parse(content);
            CommonmarkConfluenceWikiVisitor visitor = new CommonmarkConfluenceWikiVisitor(context);
            node.accept((Visitor)visitor);
            return visitor.toString();
        }
    }
}

