/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.markdown.commonmark.extension;

import java.util.Optional;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.Visitor;

public class NoticeBlock
extends CustomBlock {
    final Type type;
    final Optional<String> title;

    public Type getType() {
        return this.type;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public NoticeBlock(Type type, String title) {
        this.type = type;
        this.title = Optional.ofNullable(title);
    }

    public NoticeBlock(Type type) {
        this.type = type;
        this.title = Optional.empty();
    }

    public void accept(Visitor visitor) {
        visitor.visit((CustomBlock)this);
    }

    public static enum Type {
        UNKNOWN,
        PANEL,
        NOTE,
        WARNING,
        INFO,
        TIP;


        public String getTagName() {
            return this.name().toLowerCase();
        }

        static Type fromString(String type) {
            try {
                return Type.valueOf(type.toUpperCase());
            }
            catch (Exception e) {
                return UNKNOWN;
            }
        }
    }
}

