/*
 * Decompiled with CFR 0.152.
 */
package org.brotli.dec;

import org.brotli.dec.WordTransformType;

final class Transform {
    private final byte[] prefix;
    private final WordTransformType type;
    private final byte[] suffix;
    static final Transform[] TRANSFORMS = new Transform[]{new Transform("", WordTransformType.IDENTITY, ""), new Transform("", WordTransformType.IDENTITY, " "), new Transform(" ", WordTransformType.IDENTITY, " "), new Transform("", WordTransformType.OMIT_FIRST_1, ""), new Transform("", WordTransformType.UPPERCASE_FIRST, " "), new Transform("", WordTransformType.IDENTITY, " the "), new Transform(" ", WordTransformType.IDENTITY, ""), new Transform("s ", WordTransformType.IDENTITY, " "), new Transform("", WordTransformType.IDENTITY, " of "), new Transform("", WordTransformType.UPPERCASE_FIRST, ""), new Transform("", WordTransformType.IDENTITY, " and "), new Transform("", WordTransformType.OMIT_FIRST_2, ""), new Transform("", WordTransformType.OMIT_LAST_1, ""), new Transform(", ", WordTransformType.IDENTITY, " "), new Transform("", WordTransformType.IDENTITY, ", "), new Transform(" ", WordTransformType.UPPERCASE_FIRST, " "), new Transform("", WordTransformType.IDENTITY, " in "), new Transform("", WordTransformType.IDENTITY, " to "), new Transform("e ", WordTransformType.IDENTITY, " "), new Transform("", WordTransformType.IDENTITY, "\""), new Transform("", WordTransformType.IDENTITY, "."), new Transform("", WordTransformType.IDENTITY, "\">"), new Transform("", WordTransformType.IDENTITY, "\n"), new Transform("", WordTransformType.OMIT_LAST_3, ""), new Transform("", WordTransformType.IDENTITY, "]"), new Transform("", WordTransformType.IDENTITY, " for "), new Transform("", WordTransformType.OMIT_FIRST_3, ""), new Transform("", WordTransformType.OMIT_LAST_2, ""), new Transform("", WordTransformType.IDENTITY, " a "), new Transform("", WordTransformType.IDENTITY, " that "), new Transform(" ", WordTransformType.UPPERCASE_FIRST, ""), new Transform("", WordTransformType.IDENTITY, ". "), new Transform(".", WordTransformType.IDENTITY, ""), new Transform(" ", WordTransformType.IDENTITY, ", "), new Transform("", WordTransformType.OMIT_FIRST_4, ""), new Transform("", WordTransformType.IDENTITY, " with "), new Transform("", WordTransformType.IDENTITY, "'"), new Transform("", WordTransformType.IDENTITY, " from "), new Transform("", WordTransformType.IDENTITY, " by "), new Transform("", WordTransformType.OMIT_FIRST_5, ""), new Transform("", WordTransformType.OMIT_FIRST_6, ""), new Transform(" the ", WordTransformType.IDENTITY, ""), new Transform("", WordTransformType.OMIT_LAST_4, ""), new Transform("", WordTransformType.IDENTITY, ". The "), new Transform("", WordTransformType.UPPERCASE_ALL, ""), new Transform("", WordTransformType.IDENTITY, " on "), new Transform("", WordTransformType.IDENTITY, " as "), new Transform("", WordTransformType.IDENTITY, " is "), new Transform("", WordTransformType.OMIT_LAST_7, ""), new Transform("", WordTransformType.OMIT_LAST_1, "ing "), new Transform("", WordTransformType.IDENTITY, "\n\t"), new Transform("", WordTransformType.IDENTITY, ":"), new Transform(" ", WordTransformType.IDENTITY, ". "), new Transform("", WordTransformType.IDENTITY, "ed "), new Transform("", WordTransformType.OMIT_FIRST_9, ""), new Transform("", WordTransformType.OMIT_FIRST_7, ""), new Transform("", WordTransformType.OMIT_LAST_6, ""), new Transform("", WordTransformType.IDENTITY, "("), new Transform("", WordTransformType.UPPERCASE_FIRST, ", "), new Transform("", WordTransformType.OMIT_LAST_8, ""), new Transform("", WordTransformType.IDENTITY, " at "), new Transform("", WordTransformType.IDENTITY, "ly "), new Transform(" the ", WordTransformType.IDENTITY, " of "), new Transform("", WordTransformType.OMIT_LAST_5, ""), new Transform("", WordTransformType.OMIT_LAST_9, ""), new Transform(" ", WordTransformType.UPPERCASE_FIRST, ", "), new Transform("", WordTransformType.UPPERCASE_FIRST, "\""), new Transform(".", WordTransformType.IDENTITY, "("), new Transform("", WordTransformType.UPPERCASE_ALL, " "), new Transform("", WordTransformType.UPPERCASE_FIRST, "\">"), new Transform("", WordTransformType.IDENTITY, "=\""), new Transform(" ", WordTransformType.IDENTITY, "."), new Transform(".com/", WordTransformType.IDENTITY, ""), new Transform(" the ", WordTransformType.IDENTITY, " of the "), new Transform("", WordTransformType.UPPERCASE_FIRST, "'"), new Transform("", WordTransformType.IDENTITY, ". This "), new Transform("", WordTransformType.IDENTITY, ","), new Transform(".", WordTransformType.IDENTITY, " "), new Transform("", WordTransformType.UPPERCASE_FIRST, "("), new Transform("", WordTransformType.UPPERCASE_FIRST, "."), new Transform("", WordTransformType.IDENTITY, " not "), new Transform(" ", WordTransformType.IDENTITY, "=\""), new Transform("", WordTransformType.IDENTITY, "er "), new Transform(" ", WordTransformType.UPPERCASE_ALL, " "), new Transform("", WordTransformType.IDENTITY, "al "), new Transform(" ", WordTransformType.UPPERCASE_ALL, ""), new Transform("", WordTransformType.IDENTITY, "='"), new Transform("", WordTransformType.UPPERCASE_ALL, "\""), new Transform("", WordTransformType.UPPERCASE_FIRST, ". "), new Transform(" ", WordTransformType.IDENTITY, "("), new Transform("", WordTransformType.IDENTITY, "ful "), new Transform(" ", WordTransformType.UPPERCASE_FIRST, ". "), new Transform("", WordTransformType.IDENTITY, "ive "), new Transform("", WordTransformType.IDENTITY, "less "), new Transform("", WordTransformType.UPPERCASE_ALL, "'"), new Transform("", WordTransformType.IDENTITY, "est "), new Transform(" ", WordTransformType.UPPERCASE_FIRST, "."), new Transform("", WordTransformType.UPPERCASE_ALL, "\">"), new Transform(" ", WordTransformType.IDENTITY, "='"), new Transform("", WordTransformType.UPPERCASE_FIRST, ","), new Transform("", WordTransformType.IDENTITY, "ize "), new Transform("", WordTransformType.UPPERCASE_ALL, "."), new Transform("\u00c2\u00a0", WordTransformType.IDENTITY, ""), new Transform(" ", WordTransformType.IDENTITY, ","), new Transform("", WordTransformType.UPPERCASE_FIRST, "=\""), new Transform("", WordTransformType.UPPERCASE_ALL, "=\""), new Transform("", WordTransformType.IDENTITY, "ous "), new Transform("", WordTransformType.UPPERCASE_ALL, ", "), new Transform("", WordTransformType.UPPERCASE_FIRST, "='"), new Transform(" ", WordTransformType.UPPERCASE_FIRST, ","), new Transform(" ", WordTransformType.UPPERCASE_ALL, "=\""), new Transform(" ", WordTransformType.UPPERCASE_ALL, ", "), new Transform("", WordTransformType.UPPERCASE_ALL, ","), new Transform("", WordTransformType.UPPERCASE_ALL, "("), new Transform("", WordTransformType.UPPERCASE_ALL, ". "), new Transform(" ", WordTransformType.UPPERCASE_ALL, "."), new Transform("", WordTransformType.UPPERCASE_ALL, "='"), new Transform(" ", WordTransformType.UPPERCASE_ALL, ". "), new Transform(" ", WordTransformType.UPPERCASE_FIRST, "=\""), new Transform(" ", WordTransformType.UPPERCASE_ALL, "='"), new Transform(" ", WordTransformType.UPPERCASE_FIRST, "='")};

    Transform(String prefix, WordTransformType type, String suffix) {
        this.prefix = Transform.readUniBytes(prefix);
        this.type = type;
        this.suffix = Transform.readUniBytes(suffix);
    }

    static byte[] readUniBytes(String uniBytes) {
        byte[] result = new byte[uniBytes.length()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)uniBytes.charAt(i);
        }
        return result;
    }

    static int transformDictionaryWord(byte[] dst, int dstOffset, byte[] word, int wordOffset, int len, Transform transform) {
        int offset = dstOffset;
        byte[] string = transform.prefix;
        int tmp = string.length;
        int i = 0;
        while (i < tmp) {
            dst[offset++] = string[i++];
        }
        WordTransformType op = transform.type;
        tmp = op.omitFirst;
        if (tmp > len) {
            tmp = len;
        }
        wordOffset += tmp;
        len -= tmp;
        for (i = len -= op.omitLast; i > 0; --i) {
            dst[offset++] = word[wordOffset++];
        }
        if (op == WordTransformType.UPPERCASE_ALL || op == WordTransformType.UPPERCASE_FIRST) {
            int uppercaseOffset = offset - len;
            if (op == WordTransformType.UPPERCASE_FIRST) {
                len = 1;
            }
            while (len > 0) {
                tmp = dst[uppercaseOffset] & 0xFF;
                if (tmp < 192) {
                    if (tmp >= 97 && tmp <= 122) {
                        int n = uppercaseOffset;
                        dst[n] = (byte)(dst[n] ^ 0x20);
                    }
                    ++uppercaseOffset;
                    --len;
                    continue;
                }
                if (tmp < 224) {
                    int n = uppercaseOffset + 1;
                    dst[n] = (byte)(dst[n] ^ 0x20);
                    uppercaseOffset += 2;
                    len -= 2;
                    continue;
                }
                int n = uppercaseOffset + 2;
                dst[n] = (byte)(dst[n] ^ 5);
                uppercaseOffset += 3;
                len -= 3;
            }
        }
        string = transform.suffix;
        tmp = string.length;
        i = 0;
        while (i < tmp) {
            dst[offset++] = string[i++];
        }
        return offset - dstOffset;
    }
}

