/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.service;

import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.core.web.service.TemplateCacheKeyResolverService;
import org.springframework.stereotype.Service;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

@Service(value="blTemplateCacheKeyResolver")
public class SimpleCacheKeyResolver
implements TemplateCacheKeyResolverService {
    @Override
    public String resolveCacheKey(Arguments arguments, Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStringValue(arguments, element, "cacheKey", true));
        sb.append(this.resolveTemplateName(arguments, element));
        return sb.toString();
    }

    protected String resolveTemplateName(Arguments arguments, Element element) {
        String templateName = this.getStringValue(arguments, element, "templateName", true);
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            templateName = (String)element.getNodeProperty("templateName");
        }
        if (StringUtils.isEmpty((CharSequence)templateName)) {
            templateName = element.getDocumentName();
        }
        return templateName;
    }

    protected String getStringValue(Arguments arguments, Element element, String attrName, boolean removeAttribute) {
        if (element.hasAttribute(attrName)) {
            String cacheKeyParam = element.getAttributeValue(attrName);
            Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, cacheKeyParam);
            if (removeAttribute) {
                element.removeAttribute(attrName);
            }
            return expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments).toString();
        }
        return "";
    }
}

