/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.broadleafcommerce.core.web.controller.checkout.AbstractCheckoutController;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutControllerExtensionHandler;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class BroadleafBillingInfoController
extends AbstractCheckoutController {
    public String saveBillingAddress(HttpServletRequest request, HttpServletResponse response, Model model, BillingInfoForm billingForm, BindingResult result) throws PricingException, ServiceException {
        Order cart = CartState.getCart();
        if (billingForm.isUseShippingAddress()) {
            this.copyShippingAddressToBillingAddress(cart, billingForm);
        }
        this.billingInfoFormValidator.validate(billingForm, (Errors)result);
        if (result.hasErrors()) {
            return this.getCheckoutView();
        }
        if (billingForm.getAddress().getPhonePrimary() != null && StringUtils.isEmpty((String)billingForm.getAddress().getPhonePrimary().getPhoneNumber())) {
            billingForm.getAddress().setPhonePrimary(null);
        }
        boolean found = false;
        for (OrderPayment p : cart.getPayments()) {
            if (!PaymentType.CREDIT_CARD.equals((Object)p.getType()) || !p.isActive()) continue;
            p.setBillingAddress(billingForm.getAddress());
            found = true;
        }
        if (!found) {
            OrderPayment tempOrderPayment = this.orderPaymentService.create();
            tempOrderPayment.setType(PaymentType.CREDIT_CARD);
            tempOrderPayment.setPaymentGatewayType(PaymentGatewayType.TEMPORARY);
            tempOrderPayment.setBillingAddress(billingForm.getAddress());
            tempOrderPayment.setOrder(cart);
            cart.getPayments().add(tempOrderPayment);
        }
        this.orderService.save(cart, Boolean.valueOf(true));
        if (this.isAjaxRequest(request)) {
            ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).addAdditionalModelVariables(model);
            return this.getCheckoutView();
        }
        return this.getCheckoutPageRedirect();
    }

    protected void copyShippingAddressToBillingAddress(Order order, BillingInfoForm billingInfoForm) {
        Address shipping;
        if (order.getFulfillmentGroups().get(0) != null && (shipping = ((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getAddress()) != null) {
            Address billing = this.addressService.create();
            billing.setFirstName(shipping.getFirstName());
            billing.setLastName(shipping.getLastName());
            billing.setAddressLine1(shipping.getAddressLine1());
            billing.setAddressLine2(shipping.getAddressLine2());
            billing.setCity(shipping.getCity());
            billing.setState(shipping.getState());
            billing.setPostalCode(shipping.getPostalCode());
            billing.setCountry(shipping.getCountry());
            billing.setPrimaryPhone(shipping.getPrimaryPhone());
            billing.setPhonePrimary(this.copyPhone(shipping.getPhonePrimary()));
            billing.setEmailAddress(shipping.getEmailAddress());
            billingInfoForm.setAddress(billing);
        }
    }

    protected Phone copyPhone(Phone phoneToCopy) {
        if (phoneToCopy != null) {
            Phone copy = this.phoneService.create();
            copy.setPhoneNumber(phoneToCopy.getPhoneNumber());
            return copy;
        }
        return null;
    }
}

