/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account.validator;

import javax.annotation.Resource;
import org.apache.commons.validator.GenericValidator;
import org.broadleafcommerce.core.web.controller.account.UpdateAccountForm;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component(value="blUpdateAccountValidator")
public class UpdateAccountValidator
implements Validator {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;

    public void validate(UpdateAccountForm form, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"emailAddress", (String)"emailAddress.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"firstName", (String)"firstName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"lastName", (String)"lastName.required");
        if (!errors.hasErrors()) {
            Customer customerMatchingNewEmail;
            if (!GenericValidator.isEmail((String)form.getEmailAddress())) {
                errors.rejectValue("emailAddress", "emailAddress.invalid");
            }
            if ((customerMatchingNewEmail = this.customerService.readCustomerByEmail(form.getEmailAddress())) != null && !CustomerState.getCustomer().getId().equals(customerMatchingNewEmail.getId())) {
                errors.rejectValue("emailAddress", "emailAddress.used");
            }
        }
    }

    public boolean supports(Class<?> clazz) {
        return false;
    }

    public void validate(Object target, Errors errors) {
    }
}

