/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SearchFacetWrapper;

@XmlRootElement(name="searchResults")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchResultsWrapper
extends BaseWrapper
implements APIWrapper<ProductSearchResult> {
    @XmlElement
    protected Integer page;
    @XmlElement
    protected Integer pageSize;
    @XmlElement
    protected Integer totalResults;
    @XmlElement
    protected Integer totalPages;
    @XmlElementWrapper(name="products")
    @XmlElement(name="product")
    protected List<ProductWrapper> products;
    @XmlElementWrapper(name="searchFacets")
    @XmlElement(name="searchFacet")
    protected List<SearchFacetWrapper> searchFacets;

    @Override
    public void wrapDetails(ProductSearchResult model, HttpServletRequest request) {
        this.page = model.getPage();
        this.pageSize = model.getPageSize();
        this.totalResults = model.getTotalResults();
        this.totalPages = model.getTotalPages();
        if (model.getProducts() != null) {
            this.products = new ArrayList<ProductWrapper>();
            for (Product product : model.getProducts()) {
                ProductWrapper productSummary = (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
                productSummary.wrapSummary(product, request);
                this.products.add(productSummary);
            }
        }
        if (model.getFacets() != null) {
            this.searchFacets = new ArrayList<SearchFacetWrapper>();
            for (SearchFacetDTO facet : model.getFacets()) {
                SearchFacetWrapper facetWrapper = (SearchFacetWrapper)this.context.getBean(SearchFacetWrapper.class.getName());
                facetWrapper.wrapSummary(facet, request);
                this.searchFacets.add(facetWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(ProductSearchResult model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }
}

