/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class TwitterImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 1908393649053616794L;
    private static final String PROFILE_URL = "https://api.twitter.com/1.1/users/show.json?screen_name=";
    private static final String CONTACTS_URL = "https://api.twitter.com/1.1/friends/ids.json?screen_name=%1$s&cursor=-1";
    private static final String LOOKUP_URL = "https://api.twitter.com/1.1/users/lookup.json?user_id=";
    private static final String UPDATE_STATUS_URL = "https://api.twitter.com/1.1/statuses/update.json?status=";
    private static final String IMAGE_UPLOAD_URL = "https://api.twitter.com/1.1/statuses/update_with_media.json";
    private static final String PROPERTY_DOMAIN = "twitter.com";
    private static final Map<String, String> ENDPOINTS;
    private static final Pattern IMAGE_FILE_PATTERN;
    private final Log LOG = LogFactory.getLog(TwitterImpl.class);
    private Permission scope;
    private boolean isVerify;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;

    public TwitterImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getRequestTokenUrl() != null) {
            ENDPOINTS.put("reqTokenURL", this.config.getRequestTokenUrl());
        } else {
            this.config.setRequestTokenUrl(ENDPOINTS.get("reqTokenURL"));
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth1(this.config, ENDPOINTS);
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessToken = accessGrant;
        this.isVerify = true;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("denied") != null) {
            throw new UserDeniedPermissionException();
        }
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        this.isVerify = true;
        return this.getProfile();
    }

    private Profile getProfile() throws Exception {
        String result;
        Profile profile = new Profile();
        String url = PROFILE_URL + this.accessToken.getAttribute("screen_name");
        this.LOG.debug((Object)("Obtaining user profile. Profile URL : " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url + ". Status :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + url, exc);
        }
        try {
            JSONObject pObj = new JSONObject(result);
            if (pObj.has("id_str")) {
                profile.setValidatedId(pObj.getString("id_str"));
            }
            if (pObj.has("name")) {
                profile.setFullName(pObj.getString("name"));
            }
            if (pObj.has("location")) {
                profile.setLocation(pObj.getString("location"));
            }
            if (pObj.has("screen_name")) {
                profile.setDisplayName(pObj.getString("screen_name"));
            }
            if (pObj.has("lang")) {
                profile.setLanguage(pObj.getString("lang"));
            }
            if (pObj.has("profile_image_url")) {
                profile.setProfileImageURL(pObj.getString("profile_image_url"));
            }
            profile.setProviderId(this.getProviderId());
            this.userProfile = profile;
            return profile;
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.info((Object)("Updatting status " + msg));
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        String message = msg;
        if (message.length() > 140) {
            this.LOG.debug((Object)"Truncating message up to 140 characters");
            message = message.substring(0, 140);
        }
        String url = UPDATE_STATUS_URL + URLEncoder.encode(message, "UTF-8");
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url, MethodType.POST.toString(), null, null, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to update status on " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to update status on " + url + ". Status :" + serviceResponse.getStatus());
        }
        return serviceResponse;
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String result;
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        String url = String.format(CONTACTS_URL, this.accessToken.getAttribute("screen_name"));
        ArrayList<Contact> plist = new ArrayList<Contact>();
        this.LOG.info((Object)("Fetching contacts from " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from " + url, ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url);
        }
        this.LOG.debug((Object)("User friends ids : " + result));
        try {
            JSONObject jobj = new JSONObject(result);
            if (jobj.has("ids")) {
                int i;
                JSONArray idList = jobj.getJSONArray("ids");
                int flength = idList.length();
                int[] ids = new int[flength];
                for (i = 0; i < idList.length(); ++i) {
                    ids[i] = idList.getInt(i);
                }
                if (flength > 0) {
                    if (flength > 100) {
                        int[] temparr;
                        i = flength / 100;
                        for (int j = 1; j <= i; ++j) {
                            temparr = new int[100];
                            int k = (j - 1) * 100;
                            int c = 0;
                            while (k < j * 100) {
                                temparr[c] = ids[k];
                                ++k;
                                ++c;
                            }
                            plist.addAll(this.lookupUsers(temparr));
                        }
                        if (flength > i * 100) {
                            temparr = new int[flength - i * 100];
                            int k = i * 100;
                            int c = 0;
                            while (k < flength) {
                                temparr[c] = ids[k];
                                ++k;
                                ++c;
                            }
                            plist.addAll(this.lookupUsers(temparr));
                        }
                    } else {
                        plist.addAll(this.lookupUsers(ids));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user friends json : " + result, e);
        }
        return plist;
    }

    private List<Contact> lookupUsers(int[] fids) throws Exception {
        String result;
        StringBuilder strb = new StringBuilder();
        ArrayList<Contact> plist = new ArrayList<Contact>();
        for (int value : fids) {
            if (strb.length() != 0) {
                strb.append(",");
            }
            strb.append(value);
        }
        String url = LOOKUP_URL + strb.toString();
        this.LOG.debug((Object)("Fetching info of following users : " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from " + url, ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url, e);
        }
        this.LOG.debug((Object)("Users info : " + result));
        JSONArray jarr = new JSONArray(result);
        for (int i = 0; i < jarr.length(); ++i) {
            JSONObject jobj = jarr.getJSONObject(i);
            Contact cont = new Contact();
            if (jobj.has("name")) {
                cont.setFirstName(jobj.getString("name"));
            }
            if (jobj.has("screen_name")) {
                cont.setDisplayName(jobj.getString("screen_name"));
                cont.setProfileUrl("https://twitter.com/" + jobj.getString("screen_name"));
            }
            cont.setProfileImageURL(jobj.optString("profile_image_url"));
            if (jobj.has("id_str")) {
                cont.setId(jobj.getString("id_str"));
            }
            plist.add(cont);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.info((Object)("Uploading Image :: " + fileName + ", message :: " + message));
        if (!IMAGE_FILE_PATTERN.matcher(fileName).find()) {
            throw new SocialAuthException("Twitter supports only PNG, JPG and GIF image formats");
        }
        String fileNameParam = "media[]";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("status", message);
        Response response = this.authenticationStrategy.uploadImage(IMAGE_UPLOAD_URL, MethodType.POST.toString(), map, null, fileName, inputStream, fileNameParam);
        this.LOG.info((Object)("Upload Image status::" + response.getStatus()));
        return response;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.twitter.FeedPluginImpl");
        list.add("org.brickred.socialauth.plugin.twitter.AlbumsPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        IMAGE_FILE_PATTERN = Pattern.compile("(jpg|jpeg|gif|png)$", 2);
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("reqTokenURL", "https://api.twitter.com/oauth/request_token");
        ENDPOINTS.put("authorizationURL", "https://api.twitter.com/oauth/authenticate");
        ENDPOINTS.put("accessTokenURL", "https://api.twitter.com/oauth/access_token");
    }
}

