/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class NimbleImpl
extends AbstractProvider {
    private static final long serialVersionUID = 8942981661253696430L;
    private static final String CONTACTS_URL = "https://api.nimble.com/api/v1/contacts?per_page=200";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(NimbleImpl.class);
    private Permission scope;
    private OAuthConfig config;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;

    public NimbleImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException, SocialAuthException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error") != null && "access_denied".equals(requestParams.get("error"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return null;
        }
        throw new SocialAuthException("Access token not found");
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Nimble");
        throw new SocialAuthException("Update Status is not implemented for Nimble");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        ArrayList<Contact> plist = new ArrayList<Contact>();
        this.LOG.info((Object)"Fetching contacts from https://api.nimble.com/api/v1/contacts?per_page=200");
        try {
            Response response = this.authenticationStrategy.executeFeed(CONTACTS_URL);
            respStr = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from https://api.nimble.com/api/v1/contacts?per_page=200", e);
        }
        try {
            this.LOG.debug((Object)("User Contacts list in json : " + respStr));
            JSONObject resp = new JSONObject(respStr);
            JSONArray responses = resp.getJSONArray("resources");
            this.LOG.debug((Object)("Found contacts : " + responses.length()));
            for (int i = 0; i < responses.length(); ++i) {
                JSONArray arr;
                JSONObject jobj;
                JSONObject obj = responses.getJSONObject(i);
                JSONObject fields = obj.getJSONObject("fields");
                Contact p = new Contact();
                if (!obj.has("record_type")) continue;
                if ("company".equals(obj.getString("record_type"))) {
                    if (fields.has("company name") && (jobj = (arr = fields.getJSONArray("company name")).getJSONObject(0)).has("value")) {
                        p.setFirstName(jobj.getString("value"));
                    }
                    if (obj.has("avatar_url")) {
                        p.setProfileImageURL(obj.getString("avatar_url"));
                    }
                    if (fields.has("URL") && (jobj = (arr = fields.getJSONArray("URL")).getJSONObject(0)).has("value")) {
                        p.setProfileUrl(jobj.getString("value"));
                    }
                    plist.add(p);
                    continue;
                }
                if (!"person".equals(obj.getString("record_type"))) continue;
                if (fields.has("last name") && (jobj = (arr = fields.getJSONArray("last name")).getJSONObject(0)).has("value")) {
                    p.setLastName(jobj.getString("value"));
                }
                if (fields.has("first name") && (jobj = (arr = fields.getJSONArray("first name")).getJSONObject(0)).has("value")) {
                    p.setFirstName(jobj.getString("value"));
                }
                if (obj.has("avatar_url")) {
                    p.setProfileImageURL(obj.getString("avatar_url"));
                }
                if (fields.has("URL")) {
                    arr = fields.getJSONArray("URL");
                    if (arr.length() == 1) {
                        jobj = arr.getJSONObject(0);
                        if (jobj.has("value")) {
                            p.setProfileUrl(jobj.getString("value"));
                        }
                    } else {
                        String url = null;
                        for (int k = 0; k < arr.length(); ++k) {
                            JSONObject jobj2 = arr.getJSONObject(k);
                            url = jobj2.optString("value");
                            if ("personal".equals(jobj2.optString("modifier"))) break;
                        }
                        if (url != null) {
                            p.setProfileUrl(url);
                        }
                    }
                }
                plist.add(p);
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts json : " + respStr, e);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        this.LOG.warn((Object)"WARNING: Get Profile function not implemented for Nimble");
        return null;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Nimble");
        throw new SocialAuthException("Upload Image is not implemented for Nimble");
    }

    private String getScope() {
        return null;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        ENDPOINTS.put("authorizationURL", "https://api.nimble.com/oauth/authorize");
        ENDPOINTS.put("accessTokenURL", "https://api.nimble.com/oauth/token");
    }
}

