/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.Hybrid;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OpenIdConsumer;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GoogleImpl
extends AbstractProvider {
    private static final long serialVersionUID = -6075582192266022341L;
    private static final String OAUTH_SCOPE = "https://www.google.com/m8/feeds/";
    private static final String CONTACTS_FEED_URL = "https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000";
    private static final String CONTACT_NAMESPACE = "http://schemas.google.com/g/2005";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(GoogleImpl.class);
    private Permission scope;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;

    public GoogleImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        this.accessToken = null;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getRequestTokenUrl() != null) {
            ENDPOINTS.put("reqTokenURL", this.config.getRequestTokenUrl());
        } else {
            this.config.setRequestTokenUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new Hybrid(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessToken = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        String url = this.authenticationStrategy.getLoginRedirectURL(successUrl);
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.LOG.debug((Object)"Verifying the authentication response from provider");
        if (requestParams.get("openid.mode") != null && "cancel".equals(requestParams.get("openid.mode"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        this.LOG.debug((Object)"Obtaining profile from OpenID response");
        return this.getProfile(requestParams);
    }

    private Profile getProfile(Map<String, String> requestParams) {
        this.userProfile = OpenIdConsumer.getUserInfo(requestParams);
        this.userProfile.setProviderId(this.getProviderId());
        this.LOG.debug((Object)("User Info : " + this.userProfile.toString()));
        return this.userProfile;
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Google");
        throw new SocialAuthException("Update Status is not implemented for Google");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        this.LOG.info((Object)"Fetching contacts from https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000");
        if (Permission.AUTHENTICATE_ONLY.equals(this.scope)) {
            throw new SocialAuthException("You have not set Permission to get contacts.");
        }
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(CONTACTS_FEED_URL);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000", ie);
        }
        ArrayList<Contact> plist = new ArrayList<Contact>();
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts from response.https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000", e);
        }
        NodeList contactsList = root.getElementsByTagName("entry");
        if (contactsList != null && contactsList.getLength() > 0) {
            this.LOG.debug((Object)("Found contacts : " + contactsList.getLength()));
            for (int i = 0; i < contactsList.getLength(); ++i) {
                String[] sarr;
                Element contact = (Element)contactsList.item(i);
                String fname = "";
                NodeList l = contact.getElementsByTagNameNS(CONTACT_NAMESPACE, "email");
                String address = null;
                String[] emailArr = null;
                if (l != null && l.getLength() > 0) {
                    Element el = (Element)l.item(0);
                    if (el != null) {
                        address = el.getAttribute("address");
                    }
                    if (l.getLength() > 1) {
                        emailArr = new String[l.getLength() - 1];
                        for (int k = 1; k < l.getLength(); ++k) {
                            Element e = (Element)l.item(k);
                            if (e == null) continue;
                            emailArr[k - 1] = e.getAttribute("address");
                        }
                    }
                }
                String lname = "";
                String dispName = XMLParseUtil.getElementData(contact, "title");
                if (dispName != null && (sarr = dispName.split(" ")).length > 0) {
                    if (sarr.length >= 1) {
                        fname = sarr[0];
                    }
                    if (sarr.length >= 2) {
                        StringBuilder sb = new StringBuilder();
                        for (int k = 1; k < sarr.length; ++k) {
                            sb.append(sarr[k]).append(" ");
                        }
                        lname = sb.toString();
                    }
                }
                String id = XMLParseUtil.getElementData(contact, "id");
                if (address == null || address.length() <= 0) continue;
                Contact p = new Contact();
                p.setFirstName(fname);
                p.setLastName(lname);
                p.setEmail(address);
                p.setDisplayName(dispName);
                p.setOtherEmails(emailArr);
                p.setId(id);
                plist.add(p);
            }
        } else {
            this.LOG.debug((Object)"No contacts were obtained from the feed : https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000");
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response serviceResponse = null;
        if (!MethodType.GET.toString().equals(methodType)) {
            throw new SocialAuthException("Only GET method is implemented in Google API function");
        }
        this.LOG.debug((Object)("Calling URL : " + url));
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Error while making request to URL : " + url, ie);
        }
        return serviceResponse;
    }

    @Override
    public Profile getUserProfile() {
        if (this.userProfile == null && this.accessToken != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : this.accessToken.getAttributes().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                map.put(key, value);
            }
            if (!map.isEmpty()) {
                this.getProfile(map);
            }
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Google");
        throw new SocialAuthException("Update Status is not implemented for Google");
    }

    private String getScope() {
        String scopeStr;
        if (Permission.AUTHENTICATE_ONLY.equals(this.scope)) {
            scopeStr = null;
        } else if (Permission.CUSTOM.equals(this.scope)) {
            StringBuffer sb = new StringBuffer();
            String[] arr = this.config.getCustomPermissions().split(",");
            sb.append(arr[0]);
            for (int i = 1; i < arr.length; ++i) {
                sb.append(" ").append(arr[i]);
            }
            scopeStr = sb.toString();
        } else {
            scopeStr = OAUTH_SCOPE;
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            scopeStr = scopeStr != null ? scopeStr + "," + pluginScopes : pluginScopes;
        }
        return scopeStr;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        ENDPOINTS.put("reqTokenURL", "https://www.google.com/accounts/o8/ud");
        ENDPOINTS.put("accessTokenURL", "https://www.google.com/accounts/OAuthGetAccessToken");
    }
}

