/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.instagram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Feed;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.plugin.FeedPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FeedPluginImpl
implements FeedPlugin,
Serializable {
    private static final long serialVersionUID = 7322246222894929129L;
    private static final String FEED_URL = "https://api.instagram.com/v1/users/self/feed";
    private final Log LOG = LogFactory.getLog(FeedPluginImpl.class);
    private ProviderSupport providerSupport;

    public FeedPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Feed> getFeeds() throws Exception {
        ArrayList<Feed> list = new ArrayList<Feed>();
        try {
            Response response = this.providerSupport.api(FEED_URL);
            String respStr = response.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("Feed Json response :: " + respStr));
            JSONObject resp = new JSONObject(respStr);
            JSONArray data = resp.getJSONArray("data");
            this.LOG.debug((Object)("Feeds count : " + data.length()));
            for (int i = 0; i < data.length(); ++i) {
                JSONObject iobj;
                Feed feed = new Feed();
                JSONObject obj = data.getJSONObject(i);
                if (obj.has("images") && (iobj = obj.getJSONObject("images")).has("low_resolution")) {
                    feed.setMessage(iobj.getJSONObject("low_resolution").optString("url"));
                }
                if (obj.has("user")) {
                    iobj = obj.getJSONObject("user");
                    if (iobj.has("full_name")) {
                        feed.setFrom(iobj.getString("full_name"));
                    }
                    if (iobj.has("id")) {
                        feed.setId(iobj.getString("id"));
                    }
                    if (iobj.has("username")) {
                        feed.setScreenName(iobj.getString("username"));
                    }
                }
                if (obj.has("created_time")) {
                    feed.setCreatedAt(new Date(Integer.parseInt(obj.getString("created_time"))));
                }
                list.add(feed);
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting Feeds from https://api.instagram.com/v1/users/self/feed", e);
        }
        return list;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

