/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KemBMParameter
extends ASN1Object {
    private final AlgorithmIdentifier kdf;
    private final ASN1Integer len;
    private final AlgorithmIdentifier mac;

    private KemBMParameter(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence size should 3");
        }
        this.kdf = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(0));
        this.len = ASN1Integer.getInstance((Object)seq.getObjectAt(1));
        this.mac = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(2));
    }

    public KemBMParameter(AlgorithmIdentifier kdf, ASN1Integer len, AlgorithmIdentifier mac) {
        this.kdf = kdf;
        this.len = len;
        this.mac = mac;
    }

    public KemBMParameter(AlgorithmIdentifier kdf, long len, AlgorithmIdentifier mac) {
        this(kdf, new ASN1Integer(len), mac);
    }

    public static KemBMParameter getInstance(Object o) {
        if (o instanceof KemBMParameter) {
            return (KemBMParameter)((Object)o);
        }
        if (o != null) {
            return new KemBMParameter(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public AlgorithmIdentifier getKdf() {
        return this.kdf;
    }

    public ASN1Integer getLen() {
        return this.len;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add((ASN1Encodable)this.kdf);
        v.add((ASN1Encodable)this.len);
        v.add((ASN1Encodable)this.mac);
        return new DERSequence(v);
    }
}

