/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;

public class Challenge
extends ASN1Object {
    private final AlgorithmIdentifier owf;
    private final ASN1OctetString witness;
    private final ASN1OctetString challenge;
    private final EnvelopedData encryptedRand;

    private Challenge(ASN1Sequence seq) {
        int index = 0;
        this.owf = seq.getObjectAt(0).toASN1Primitive() instanceof ASN1Sequence ? AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(index++)) : null;
        this.witness = ASN1OctetString.getInstance((Object)seq.getObjectAt(index++));
        this.challenge = ASN1OctetString.getInstance((Object)seq.getObjectAt(index++));
        if (seq.size() > index) {
            if (this.challenge.getOctets().length != 0) {
                throw new IllegalArgumentException("ambigous challenge");
            }
            this.encryptedRand = EnvelopedData.getInstance(ASN1TaggedObject.getInstance((Object)seq.getObjectAt(index)), true);
        } else {
            this.encryptedRand = null;
        }
    }

    public Challenge(byte[] witness, byte[] challenge) {
        this(null, witness, challenge);
    }

    public Challenge(byte[] witness, EnvelopedData encryptedRand) {
        this(null, witness, encryptedRand);
    }

    public Challenge(AlgorithmIdentifier owf, byte[] witness, byte[] challenge) {
        this.owf = owf;
        this.witness = new DEROctetString(witness);
        this.challenge = new DEROctetString(challenge);
        this.encryptedRand = null;
    }

    public Challenge(AlgorithmIdentifier owf, byte[] witness, EnvelopedData encryptedRand) {
        this.owf = owf;
        this.witness = new DEROctetString(witness);
        this.challenge = new DEROctetString(new byte[0]);
        this.encryptedRand = encryptedRand;
    }

    public static Challenge getInstance(Object o) {
        if (o instanceof Challenge) {
            return (Challenge)((Object)o);
        }
        if (o != null) {
            return new Challenge(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public byte[] getWitness() {
        return this.witness.getOctets();
    }

    public boolean isEncryptedRand() {
        return this.encryptedRand != null;
    }

    public byte[] getChallenge() {
        return this.challenge.getOctets();
    }

    public EnvelopedData getEncryptedRand() {
        return this.encryptedRand;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.addOptional((ASN1Encodable)this.owf);
        v.add((ASN1Encodable)this.witness);
        v.add((ASN1Encodable)this.challenge);
        if (this.encryptedRand != null) {
            v.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)this.encryptedRand));
        }
        return new DERSequence(v);
    }

    public static class Rand
    extends ASN1Object {
        private final ASN1Integer integer;
        private final GeneralName sender;

        public Rand(byte[] integer, GeneralName sender) {
            this(new ASN1Integer(integer), sender);
        }

        public Rand(ASN1Integer integer, GeneralName sender) {
            this.integer = integer;
            this.sender = sender;
        }

        private Rand(ASN1Sequence seq) {
            if (seq.size() != 2) {
                throw new IllegalArgumentException("expected sequence size of 2");
            }
            this.integer = ASN1Integer.getInstance((Object)seq.getObjectAt(0));
            this.sender = GeneralName.getInstance((Object)seq.getObjectAt(1));
        }

        public static Rand getInstance(Object o) {
            if (o instanceof Rand) {
                return (Rand)((Object)o);
            }
            if (o != null) {
                return new Rand(ASN1Sequence.getInstance((Object)o));
            }
            return null;
        }

        public ASN1Integer getInt() {
            return this.integer;
        }

        public GeneralName getSender() {
            return this.sender;
        }

        public ASN1Primitive toASN1Primitive() {
            return new DERSequence(new ASN1Encodable[]{this.integer, this.sender});
        }
    }
}

