/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import org.bouncycastle.tls.ByteQueue;
import org.bouncycastle.tls.DTLSEpoch;
import org.bouncycastle.tls.DTLSHandshakeRetransmit;
import org.bouncycastle.tls.DTLSRecordCallback;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DatagramSender;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.HeartbeatMessage;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.Timeout;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsFatalAlertReceived;
import org.bouncycastle.tls.TlsHeartbeat;
import org.bouncycastle.tls.TlsPeer;
import org.bouncycastle.tls.TlsTimeoutException;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsNullNullCipher;
import org.bouncycastle.util.Arrays;

class DTLSRecordLayer
implements DatagramTransport {
    static final int RECORD_HEADER_LENGTH = 13;
    private static final int MAX_FRAGMENT_LENGTH = 16384;
    private static final long TCP_MSL = 120000L;
    private static final long RETRANSMIT_TIMEOUT = 240000L;
    private final TlsContext context;
    private final TlsPeer peer;
    private final DatagramTransport transport;
    private final ByteQueue recordQueue = new ByteQueue();
    private final Object writeLock = new Object();
    private volatile boolean closed = false;
    private volatile boolean failed = false;
    private volatile ProtocolVersion readVersion = null;
    private volatile ProtocolVersion writeVersion = null;
    private volatile boolean inConnection;
    private volatile boolean inHandshake;
    private volatile int plaintextLimit;
    private DTLSEpoch currentEpoch;
    private DTLSEpoch pendingEpoch;
    private DTLSEpoch readEpoch;
    private DTLSEpoch writeEpoch;
    private DTLSHandshakeRetransmit retransmit = null;
    private DTLSEpoch retransmitEpoch = null;
    private Timeout retransmitTimeout = null;
    private TlsHeartbeat heartbeat = null;
    private boolean heartBeatResponder = false;
    private HeartbeatMessage heartbeatInFlight = null;
    private Timeout heartbeatTimeout = null;
    private int heartbeatResendMillis = -1;
    private Timeout heartbeatResendTimeout = null;

    static int receiveClientHelloRecord(byte[] data, int dataOff, int dataLen) throws IOException {
        if (dataLen < 13) {
            return -1;
        }
        short contentType = TlsUtils.readUint8(data, dataOff + 0);
        if (22 != contentType) {
            return -1;
        }
        ProtocolVersion version = TlsUtils.readVersion(data, dataOff + 1);
        if (!ProtocolVersion.DTLSv10.isEqualOrEarlierVersionOf(version)) {
            return -1;
        }
        int epoch = TlsUtils.readUint16(data, dataOff + 3);
        if (0 != epoch) {
            return -1;
        }
        int length = TlsUtils.readUint16(data, dataOff + 11);
        if (length < 1 || length > 16384) {
            return -1;
        }
        if (dataLen < 13 + length) {
            return -1;
        }
        short msgType = TlsUtils.readUint8(data, dataOff + 13);
        if (1 != msgType) {
            return -1;
        }
        return length;
    }

    static void sendHelloVerifyRequestRecord(DatagramSender sender, long recordSeq, byte[] message) throws IOException {
        TlsUtils.checkUint16(message.length);
        byte[] record = new byte[13 + message.length];
        TlsUtils.writeUint8((short)22, record, 0);
        TlsUtils.writeVersion(ProtocolVersion.DTLSv10, record, 1);
        TlsUtils.writeUint16(0, record, 3);
        TlsUtils.writeUint48(recordSeq, record, 5);
        TlsUtils.writeUint16(message.length, record, 11);
        System.arraycopy(message, 0, record, 13, message.length);
        DTLSRecordLayer.sendDatagram(sender, record, 0, record.length);
    }

    private static void sendDatagram(DatagramSender sender, byte[] buf, int off, int len) throws IOException {
        try {
            sender.send(buf, off, len);
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = 0;
            throw e;
        }
    }

    DTLSRecordLayer(TlsContext context, TlsPeer peer, DatagramTransport transport) {
        this.context = context;
        this.peer = peer;
        this.transport = transport;
        this.inHandshake = true;
        this.currentEpoch = new DTLSEpoch(0, TlsNullNullCipher.INSTANCE, 13, 13);
        this.pendingEpoch = null;
        this.readEpoch = this.currentEpoch;
        this.writeEpoch = this.currentEpoch;
        this.setPlaintextLimit(16384);
    }

    boolean isClosed() {
        return this.closed;
    }

    boolean isFailed() {
        return this.failed;
    }

    void resetAfterHelloVerifyRequestServer(long recordSeq) {
        this.inConnection = true;
        this.currentEpoch.setSequenceNumber(recordSeq);
        this.currentEpoch.getReplayWindow().reset(recordSeq);
    }

    void setPlaintextLimit(int plaintextLimit) {
        this.plaintextLimit = plaintextLimit;
    }

    int getReadEpoch() {
        return this.readEpoch.getEpoch();
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion readVersion) {
        this.readVersion = readVersion;
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void initPendingEpoch(TlsCipher pendingCipher) {
        if (this.pendingEpoch != null) {
            throw new IllegalStateException();
        }
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        byte[] connectionIDLocal = securityParameters.getConnectionIDLocal();
        byte[] connectionIDPeer = securityParameters.getConnectionIDPeer();
        int recordHeaderLengthRead = 13 + (connectionIDPeer != null ? connectionIDPeer.length : 0);
        int recordHeaderLengthWrite = 13 + (connectionIDLocal != null ? connectionIDLocal.length : 0);
        this.pendingEpoch = new DTLSEpoch(this.writeEpoch.getEpoch() + 1, pendingCipher, recordHeaderLengthRead, recordHeaderLengthWrite);
    }

    void handshakeSuccessful(DTLSHandshakeRetransmit retransmit) {
        if (this.readEpoch == this.currentEpoch || this.writeEpoch == this.currentEpoch) {
            throw new IllegalStateException();
        }
        if (null != retransmit) {
            this.retransmit = retransmit;
            this.retransmitEpoch = this.currentEpoch;
            this.retransmitTimeout = new Timeout(240000L);
        }
        this.inHandshake = false;
        this.currentEpoch = this.pendingEpoch;
        this.pendingEpoch = null;
    }

    void initHeartbeat(TlsHeartbeat heartbeat, boolean heartbeatResponder) {
        if (this.inHandshake) {
            throw new IllegalStateException();
        }
        this.heartbeat = heartbeat;
        this.heartBeatResponder = heartbeatResponder;
        if (null != heartbeat) {
            this.resetHeartbeat();
        }
    }

    void resetWriteEpoch() {
        this.writeEpoch = null != this.retransmitEpoch ? this.retransmitEpoch : this.currentEpoch;
    }

    @Override
    public int getReceiveLimit() throws IOException {
        int ciphertextLimit = this.transport.getReceiveLimit() - this.readEpoch.getRecordHeaderLengthRead();
        TlsCipher cipher = this.readEpoch.getCipher();
        int plaintextDecodeLimit = cipher.getPlaintextDecodeLimit(ciphertextLimit);
        return Math.min(this.plaintextLimit, plaintextDecodeLimit);
    }

    @Override
    public int getSendLimit() throws IOException {
        TlsCipher cipher = this.writeEpoch.getCipher();
        int ciphertextLimit = this.transport.getSendLimit() - this.writeEpoch.getRecordHeaderLengthWrite();
        int plaintextEncodeLimit = cipher.getPlaintextEncodeLimit(ciphertextLimit);
        return Math.min(this.plaintextLimit, plaintextEncodeLimit);
    }

    @Override
    public int receive(byte[] buf, int off, int len, int waitMillis) throws IOException {
        return this.receive(buf, off, len, waitMillis, null);
    }

    int receive(byte[] buf, int off, int len, int waitMillis, DTLSRecordCallback recordCallback) throws IOException {
        long currentTimeMillis = System.currentTimeMillis();
        Timeout timeout = Timeout.forWaitMillis(waitMillis, currentTimeMillis);
        byte[] record = null;
        while (waitMillis >= 0) {
            int received;
            int processed;
            if (null != this.retransmitTimeout && this.retransmitTimeout.remainingMillis(currentTimeMillis) < 1L) {
                this.retransmit = null;
                this.retransmitEpoch = null;
                this.retransmitTimeout = null;
            }
            if (Timeout.hasExpired(this.heartbeatTimeout, currentTimeMillis)) {
                if (null != this.heartbeatInFlight) {
                    throw new TlsTimeoutException("Heartbeat timed out");
                }
                this.heartbeatInFlight = HeartbeatMessage.create(this.context, (short)1, this.heartbeat.generatePayload());
                this.heartbeatTimeout = new Timeout(this.heartbeat.getTimeoutMillis(), currentTimeMillis);
                this.heartbeatResendMillis = this.peer.getHandshakeResendTimeMillis();
                this.heartbeatResendTimeout = new Timeout(this.heartbeatResendMillis, currentTimeMillis);
                this.sendHeartbeatMessage(this.heartbeatInFlight);
            } else if (Timeout.hasExpired(this.heartbeatResendTimeout, currentTimeMillis)) {
                this.heartbeatResendMillis = DTLSReliableHandshake.backOff(this.heartbeatResendMillis);
                this.heartbeatResendTimeout = new Timeout(this.heartbeatResendMillis, currentTimeMillis);
                this.sendHeartbeatMessage(this.heartbeatInFlight);
            }
            waitMillis = Timeout.constrainWaitMillis(waitMillis, this.heartbeatTimeout, currentTimeMillis);
            waitMillis = Timeout.constrainWaitMillis(waitMillis, this.heartbeatResendTimeout, currentTimeMillis);
            if (waitMillis < 0) {
                waitMillis = 1;
            }
            int receiveLimit = this.transport.getReceiveLimit();
            if (null == record || record.length < receiveLimit) {
                record = new byte[receiveLimit];
            }
            if ((processed = this.processRecord(received = this.receiveRecord(record, 0, receiveLimit, waitMillis), record, buf, off, len, recordCallback)) >= 0) {
                return processed;
            }
            currentTimeMillis = System.currentTimeMillis();
            waitMillis = Timeout.getWaitMillis(timeout, currentTimeMillis);
        }
        return -1;
    }

    int receivePending(byte[] buf, int off, int len, DTLSRecordCallback recordCallback) throws IOException {
        if (this.recordQueue.available() > 0) {
            int receiveLimit = this.recordQueue.available();
            byte[] record = new byte[receiveLimit];
            do {
                int received;
                int processed;
                if ((processed = this.processRecord(received = this.receivePendingRecord(record, 0, receiveLimit), record, buf, off, len, recordCallback)) < 0) continue;
                return processed;
            } while (this.recordQueue.available() > 0);
        }
        return -1;
    }

    @Override
    public void send(byte[] buf, int off, int len) throws IOException {
        short contentType = 23;
        if (this.inHandshake || this.writeEpoch == this.retransmitEpoch) {
            contentType = 22;
            short handshakeType = TlsUtils.readUint8(buf, off);
            if (handshakeType == 20) {
                DTLSEpoch nextEpoch = null;
                if (this.inHandshake) {
                    nextEpoch = this.pendingEpoch;
                } else if (this.writeEpoch == this.retransmitEpoch) {
                    nextEpoch = this.currentEpoch;
                }
                if (nextEpoch == null) {
                    throw new IllegalStateException();
                }
                byte[] data = new byte[]{1};
                this.sendRecord((short)20, data, 0, data.length);
                this.writeEpoch = nextEpoch;
            }
        }
        this.sendRecord(contentType, buf, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.inHandshake && this.inConnection) {
                this.warn((short)90, "User canceled handshake");
            }
            this.closeTransport();
        }
    }

    void fail(short alertDescription) {
        if (!this.closed) {
            if (this.inConnection) {
                try {
                    this.raiseAlert((short)2, alertDescription, null, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.failed = true;
            this.closeTransport();
        }
    }

    void failed() {
        if (!this.closed) {
            this.failed = true;
            this.closeTransport();
        }
    }

    void warn(short alertDescription, String message) throws IOException {
        this.raiseAlert((short)1, alertDescription, message, null);
    }

    private void closeTransport() {
        if (!this.closed) {
            try {
                if (!this.failed) {
                    this.warn((short)0, null);
                }
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    private void raiseAlert(short alertLevel, short alertDescription, String message, Throwable cause) throws IOException {
        this.peer.notifyAlertRaised(alertLevel, alertDescription, message, cause);
        byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
        this.sendRecord((short)21, error, 0, 2);
    }

    private int receiveDatagram(byte[] buf, int off, int len, int waitMillis) throws IOException {
        try {
            int received = this.transport.receive(buf, off, len, waitMillis);
            if (received <= len) {
                return received;
            }
        }
        catch (SocketTimeoutException received) {
        }
        catch (InterruptedIOException e) {
            e.bytesTransferred = 0;
            throw e;
        }
        return -1;
    }

    private int processRecord(int received, byte[] record, byte[] buf, int off, int len, DTLSRecordCallback recordCallback) throws IOException {
        TlsDecodeResult decoded;
        int length;
        if (received < 13) {
            return -1;
        }
        short recordType = TlsUtils.readUint8(record, 0);
        switch (recordType) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            default: {
                return -1;
            }
        }
        ProtocolVersion recordVersion = TlsUtils.readVersion(record, 1);
        if (!recordVersion.isDTLS()) {
            return -1;
        }
        int epoch = TlsUtils.readUint16(record, 3);
        DTLSEpoch recordEpoch = null;
        if (epoch == this.readEpoch.getEpoch()) {
            recordEpoch = this.readEpoch;
        } else if (null != this.retransmitEpoch && epoch == this.retransmitEpoch.getEpoch() && recordType == 22) {
            recordEpoch = this.retransmitEpoch;
        }
        if (null == recordEpoch) {
            return -1;
        }
        long seq = TlsUtils.readUint48(record, 5);
        if (recordEpoch.getReplayWindow().shouldDiscard(seq)) {
            return -1;
        }
        int recordHeaderLength = recordEpoch.getRecordHeaderLengthRead();
        if (recordHeaderLength > 13) {
            if (25 != recordType) {
                return -1;
            }
            if (received < recordHeaderLength) {
                return -1;
            }
            byte[] connectionID = this.context.getSecurityParameters().getConnectionIDPeer();
            if (!Arrays.constantTimeAreEqual((int)connectionID.length, (byte[])connectionID, (int)0, (byte[])record, (int)11)) {
                return -1;
            }
        } else if (25 == recordType) {
            return -1;
        }
        if (received != (length = TlsUtils.readUint16(record, recordHeaderLength - 2)) + recordHeaderLength) {
            return -1;
        }
        if (null != this.readVersion && !this.readVersion.equals(recordVersion)) {
            boolean isClientHelloFragment;
            boolean bl = isClientHelloFragment = this.getReadEpoch() == 0 && length > 0 && 22 == recordType && 1 == TlsUtils.readUint8(record, recordHeaderLength);
            if (!isClientHelloFragment) {
                return -1;
            }
        }
        long macSeqNo = DTLSRecordLayer.getMacSequenceNumber(recordEpoch.getEpoch(), seq);
        try {
            decoded = recordEpoch.getCipher().decodeCiphertext(macSeqNo, recordType, recordVersion, record, recordHeaderLength, length);
        }
        catch (TlsFatalAlert fatalAlert) {
            if (20 == fatalAlert.getAlertDescription()) {
                return -1;
            }
            throw fatalAlert;
        }
        if (decoded.len > this.plaintextLimit) {
            return -1;
        }
        if (decoded.len < 1 && decoded.contentType != 23) {
            return -1;
        }
        if (null == this.readVersion) {
            boolean isHelloVerifyRequest;
            boolean bl = isHelloVerifyRequest = this.getReadEpoch() == 0 && length > 0 && 22 == recordType && 3 == TlsUtils.readUint8(record, recordHeaderLength);
            if (isHelloVerifyRequest) {
                if (!ProtocolVersion.DTLSv12.isEqualOrLaterVersionOf(recordVersion)) {
                    return -1;
                }
            } else {
                this.readVersion = recordVersion;
            }
        }
        boolean isLatestConfirmed = recordEpoch.getReplayWindow().reportAuthenticated(seq);
        if (recordCallback != null) {
            int flags = 0;
            if (recordEpoch == this.readEpoch && isLatestConfirmed) {
                flags |= 1;
            }
            if (25 == recordType) {
                flags |= 2;
            }
            recordCallback.recordAccepted(flags);
        }
        switch (decoded.contentType) {
            case 21: {
                if (decoded.len == 2) {
                    short alertLevel = TlsUtils.readUint8(decoded.buf, decoded.off);
                    short alertDescription = TlsUtils.readUint8(decoded.buf, decoded.off + 1);
                    this.peer.notifyAlertReceived(alertLevel, alertDescription);
                    if (alertLevel == 2) {
                        this.failed();
                        throw new TlsFatalAlertReceived(alertDescription);
                    }
                    if (alertDescription == 0) {
                        this.closeTransport();
                    }
                }
                return -1;
            }
            case 23: {
                if (!this.inHandshake) break;
                return -1;
            }
            case 20: {
                for (int i = 0; i < decoded.len; ++i) {
                    short message = TlsUtils.readUint8(decoded.buf, decoded.off + i);
                    if (message != 1 || this.pendingEpoch == null) continue;
                    this.readEpoch = this.pendingEpoch;
                }
                return -1;
            }
            case 22: {
                if (this.inHandshake) break;
                if (null != this.retransmit) {
                    this.retransmit.receivedHandshakeRecord(epoch, decoded.buf, decoded.off, decoded.len);
                }
                return -1;
            }
            case 24: {
                if (null != this.heartbeatInFlight || this.heartBeatResponder) {
                    try {
                        ByteArrayInputStream input = new ByteArrayInputStream(decoded.buf, decoded.off, decoded.len);
                        HeartbeatMessage heartbeatMessage = HeartbeatMessage.parse(input);
                        if (null != heartbeatMessage) {
                            switch (heartbeatMessage.getType()) {
                                case 1: {
                                    if (!this.heartBeatResponder) break;
                                    HeartbeatMessage response = HeartbeatMessage.create(this.context, (short)2, heartbeatMessage.getPayload());
                                    this.sendHeartbeatMessage(response);
                                    break;
                                }
                                case 2: {
                                    if (null == this.heartbeatInFlight || !Arrays.areEqual((byte[])heartbeatMessage.getPayload(), (byte[])this.heartbeatInFlight.getPayload())) break;
                                    this.resetHeartbeat();
                                    break;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return -1;
            }
            default: {
                return -1;
            }
        }
        if (!this.inHandshake && null != this.retransmit) {
            this.retransmit = null;
            this.retransmitEpoch = null;
            this.retransmitTimeout = null;
        }
        if (decoded.len > len) {
            throw new TlsFatalAlert(80);
        }
        System.arraycopy(decoded.buf, decoded.off, buf, off, decoded.len);
        return decoded.len;
    }

    private int receivePendingRecord(byte[] buf, int off, int len) throws IOException {
        int recordLength = 13;
        if (this.recordQueue.available() >= recordLength) {
            int epoch = this.recordQueue.readUint16(3);
            DTLSEpoch recordEpoch = null;
            if (epoch == this.readEpoch.getEpoch()) {
                recordEpoch = this.readEpoch;
            } else if (null != this.retransmitEpoch && epoch == this.retransmitEpoch.getEpoch()) {
                recordEpoch = this.retransmitEpoch;
            }
            if (null == recordEpoch) {
                this.recordQueue.removeData(this.recordQueue.available());
                return -1;
            }
            recordLength = recordEpoch.getRecordHeaderLengthRead();
            if (this.recordQueue.available() >= recordLength) {
                int fragmentLength = this.recordQueue.readUint16(recordLength - 2);
                recordLength += fragmentLength;
            }
        }
        int received = Math.min(this.recordQueue.available(), recordLength);
        this.recordQueue.removeData(buf, off, received, 0);
        return received;
    }

    private int receiveRecord(byte[] buf, int off, int len, int waitMillis) throws IOException {
        if (this.recordQueue.available() > 0) {
            return this.receivePendingRecord(buf, off, len);
        }
        int received = this.receiveDatagram(buf, off, len, waitMillis);
        if (received >= 13) {
            int fragmentLength;
            int recordLength;
            this.inConnection = true;
            int epoch = TlsUtils.readUint16(buf, off + 3);
            DTLSEpoch recordEpoch = null;
            if (epoch == this.readEpoch.getEpoch()) {
                recordEpoch = this.readEpoch;
            } else if (null != this.retransmitEpoch && epoch == this.retransmitEpoch.getEpoch()) {
                recordEpoch = this.retransmitEpoch;
            }
            if (null == recordEpoch) {
                return -1;
            }
            int recordHeaderLength = recordEpoch.getRecordHeaderLengthRead();
            if (received >= recordHeaderLength && received > (recordLength = recordHeaderLength + (fragmentLength = TlsUtils.readUint16(buf, off + recordHeaderLength - 2)))) {
                this.recordQueue.addData(buf, off + recordLength, received - recordLength);
                received = recordLength;
            }
        }
        return received;
    }

    private void resetHeartbeat() {
        this.heartbeatInFlight = null;
        this.heartbeatResendMillis = -1;
        this.heartbeatResendTimeout = null;
        this.heartbeatTimeout = new Timeout(this.heartbeat.getIdleMillis());
    }

    private void sendHeartbeatMessage(HeartbeatMessage heartbeatMessage) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        heartbeatMessage.encode(output);
        byte[] buf = output.toByteArray();
        this.sendRecord((short)24, buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRecord(short contentType, byte[] buf, int off, int len) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        if (len > this.plaintextLimit) {
            throw new TlsFatalAlert(80);
        }
        if (len < 1 && contentType != 23) {
            throw new TlsFatalAlert(80);
        }
        Object object = this.writeLock;
        synchronized (object) {
            int recordEpoch = this.writeEpoch.getEpoch();
            long recordSequenceNumber = this.writeEpoch.allocateSequenceNumber();
            long macSequenceNumber = DTLSRecordLayer.getMacSequenceNumber(recordEpoch, recordSequenceNumber);
            ProtocolVersion recordVersion = this.writeVersion;
            int recordHeaderLength = this.writeEpoch.getRecordHeaderLengthWrite();
            TlsEncodeResult encoded = this.writeEpoch.getCipher().encodePlaintext(macSequenceNumber, contentType, recordVersion, recordHeaderLength, buf, off, len);
            int ciphertextLength = encoded.len - recordHeaderLength;
            TlsUtils.checkUint16(ciphertextLength);
            TlsUtils.writeUint8(encoded.recordType, encoded.buf, encoded.off + 0);
            TlsUtils.writeVersion(recordVersion, encoded.buf, encoded.off + 1);
            TlsUtils.writeUint16(recordEpoch, encoded.buf, encoded.off + 3);
            TlsUtils.writeUint48(recordSequenceNumber, encoded.buf, encoded.off + 5);
            if (recordHeaderLength > 13) {
                byte[] connectionID = this.context.getSecurityParameters().getConnectionIDLocal();
                System.arraycopy(connectionID, 0, encoded.buf, encoded.off + 11, connectionID.length);
            }
            TlsUtils.writeUint16(ciphertextLength, encoded.buf, encoded.off + (recordHeaderLength - 2));
            DTLSRecordLayer.sendDatagram(this.transport, encoded.buf, encoded.off, encoded.len);
        }
    }

    private static long getMacSequenceNumber(int epoch, long sequence_number) {
        return ((long)epoch & 0xFFFFFFFFL) << 48 | sequence_number;
    }
}

