/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.provider.ImportSSLSession;
import org.bouncycastle.jsse.provider.OldCertUtil;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ImportSSLSession_7
extends BCExtendedSSLSession
implements ImportSSLSession {
    final ExtendedSSLSession sslSession;

    ImportSSLSession_7(ExtendedSSLSession sslSession) {
        this.sslSession = sslSession;
    }

    @Override
    public SSLSession unwrap() {
        return this.sslSession;
    }

    public boolean equals(Object obj) {
        return null != obj && obj.equals(this.sslSession);
    }

    @Override
    public int getApplicationBufferSize() {
        return this.sslSession.getApplicationBufferSize();
    }

    @Override
    public String getCipherSuite() {
        return this.sslSession.getCipherSuite();
    }

    @Override
    public long getCreationTime() {
        return this.sslSession.getCreationTime();
    }

    @Override
    public byte[] getId() {
        return this.sslSession.getId();
    }

    @Override
    public long getLastAccessedTime() {
        return this.sslSession.getLastAccessedTime();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.sslSession.getLocalCertificates();
    }

    @Override
    public Principal getLocalPrincipal() {
        return this.sslSession.getLocalPrincipal();
    }

    @Override
    public String[] getLocalSupportedSignatureAlgorithms() {
        return this.sslSession.getLocalSupportedSignatureAlgorithms();
    }

    @Override
    public int getPacketBufferSize() {
        return this.sslSession.getPacketBufferSize();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return OldCertUtil.getPeerCertificateChain(this);
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.sslSession.getPeerCertificates();
    }

    @Override
    public String getPeerHost() {
        return this.sslSession.getPeerHost();
    }

    @Override
    public int getPeerPort() {
        return this.sslSession.getPeerPort();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.sslSession.getPeerPrincipal();
    }

    @Override
    public String[] getPeerSupportedSignatureAlgorithms() {
        return this.sslSession.getPeerSupportedSignatureAlgorithms();
    }

    @Override
    public String getProtocol() {
        return this.sslSession.getProtocol();
    }

    @Override
    public List<BCSNIServerName> getRequestedServerNames() {
        return Collections.emptyList();
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.sslSession.getSessionContext();
    }

    @Override
    public Object getValue(String name) {
        return this.sslSession.getValue(name);
    }

    @Override
    public String[] getValueNames() {
        return this.sslSession.getValueNames();
    }

    public int hashCode() {
        return this.sslSession.hashCode();
    }

    @Override
    public void invalidate() {
        this.sslSession.invalidate();
    }

    @Override
    public boolean isFipsMode() {
        SSLSessionContext sessionContext = this.getSessionContext();
        if (sessionContext instanceof ProvSSLSessionContext) {
            return ((ProvSSLSessionContext)sessionContext).getContextData().isFipsMode();
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.sslSession.isValid();
    }

    @Override
    public void putValue(String name, Object value) {
        this.sslSession.putValue(name, value);
    }

    @Override
    public void removeValue(String name) {
        this.sslSession.removeValue(name);
    }

    public String toString() {
        return this.sslSession.toString();
    }
}

