/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.tls.ClientHello;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DatagramSender;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.TlsMACOutputStream;
import org.bouncycastle.util.Arrays;

public class DTLSVerifier {
    private final TlsCrypto crypto;
    private final byte[] macKey;

    public DTLSVerifier(TlsCrypto crypto) {
        this.crypto = crypto;
        this.macKey = new byte[32];
        crypto.getSecureRandom().nextBytes(this.macKey);
    }

    public DTLSRequest verifyRequest(byte[] clientID, byte[] data, int dataOff, int dataLen, DatagramSender sender) {
        try {
            int msgLen = DTLSRecordLayer.receiveClientHelloRecord(data, dataOff, dataLen);
            if (msgLen < 0) {
                return null;
            }
            int bodyLength = msgLen - 12;
            if (bodyLength < 39) {
                return null;
            }
            int msgOff = dataOff + 13;
            ByteArrayInputStream buf = DTLSReliableHandshake.receiveClientHelloMessage(data, msgOff, msgLen);
            if (buf == null) {
                return null;
            }
            ByteArrayOutputStream macInput = new ByteArrayOutputStream(bodyLength);
            ClientHello clientHello = ClientHello.parse(buf, macInput);
            if (clientHello == null) {
                return null;
            }
            long recordSeq = TlsUtils.readUint48(data, dataOff + 5);
            byte[] cookie = clientHello.getCookie();
            TlsHMAC mac = this.crypto.createHMAC(3);
            mac.setKey(this.macKey, 0, this.macKey.length);
            mac.update(clientID, 0, clientID.length);
            macInput.writeTo(new TlsMACOutputStream(mac));
            byte[] expectedCookie = mac.calculateMAC();
            if (Arrays.constantTimeAreEqual((byte[])expectedCookie, (byte[])cookie)) {
                byte[] message = TlsUtils.copyOfRangeExact(data, msgOff, msgOff + msgLen);
                return new DTLSRequest(recordSeq, message, clientHello);
            }
            DTLSReliableHandshake.sendHelloVerifyRequest(sender, recordSeq, expectedCookie);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

