/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.tls.crypto.TlsAgreement;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JceTlsMLKemDomain;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JceTlsMLKem
implements TlsAgreement {
    protected final JceTlsMLKemDomain domain;
    protected MLKEMPrivateKeyParameters privateKey;
    protected MLKEMPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public JceTlsMLKem(JceTlsMLKemDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation encap = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(encap.getSecret());
            return encap.getEncapsulation();
        }
        AsymmetricCipherKeyPair kp = this.domain.generateKeyPair();
        this.privateKey = (MLKEMPrivateKeyParameters)kp.getPrivate();
        return this.domain.encodePublicKey((MLKEMPublicKeyParameters)kp.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(peerValue);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, peerValue);
            this.privateKey = null;
        }
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        TlsSecret secret = this.secret;
        this.secret = null;
        return secret;
    }
}

